/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.workflow;

import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.taskcenter.plugin.validate.BeforeSubmitCustomEventArgs;
import kd.bos.workflow.taskcenter.plugin.validate.BeforeSubmitCustomEventArgsClosedCallBack;

public class BankWorkCalWorkFlowCtrlPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(BankWorkCalWorkFlowCtrlPlugin.class);
    private static final String DATA_KEY = "data";
    private static final String FROM_KEY = "from";
    private static final String FORM_ID = "cas_bankworkcal_confirm";
    private static final String PAGE_CACHE_KEY_CALLBACK = "bankWorkCalWorkFlowCtrlResult";

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (e instanceof BeforeSubmitCustomEventArgs) {
            String result = this.getPageCache().get(PAGE_CACHE_KEY_CALLBACK);
            if (Boolean.parseBoolean(result)) {
                return;
            }
            BeforeSubmitCustomEventArgs be = (BeforeSubmitCustomEventArgs)e;
            String bizIdentifyKey = this.getPageCache().get("bizIdentifyKey");
            logger.info("\u4e1a\u52a1\u6807\u8bc6-bizIdentifyKey:" + bizIdentifyKey);
            if ("NEED_BWC_CONFIRM".equals(bizIdentifyKey)) {
                String[] resultSplit;
                String pageId = this.getPageCache().get("billPageId");
                IFormView billPageView = this.getView().getViewNoPlugin(pageId);
                IDataModel billPageModel = billPageView.getModel();
                DynamicObject businessBill = BusinessDataServiceHelper.loadSingle((Object)billPageModel.getDataEntity().getPkValue(), (DynamicObjectType)billPageModel.getDataEntityType());
                String checkResult = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"BankWorkCalCheckService", (String)"check", (Object[])new Object[]{businessBill});
                if (StringUtils.isNotEmpty((CharSequence)checkResult) && (resultSplit = checkResult.split("##")).length == 2) {
                    String ctrlStrategy;
                    switch (ctrlStrategy = resultSplit[0]) {
                        case "confirm": {
                            be.setCancel(true);
                            FormShowParameter parameter = new FormShowParameter();
                            Map customParams = parameter.getCustomParams();
                            customParams.put(DATA_KEY, resultSplit[1]);
                            customParams.put(FROM_KEY, "workflow");
                            parameter.setStatus(OperationStatus.VIEW);
                            parameter.setFormId(FORM_ID);
                            parameter.getOpenStyle().setShowType(ShowType.Modal);
                            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORM_ID));
                            this.getView().showForm(parameter);
                            break;
                        }
                        case "strict": {
                            be.setCancel(true);
                            this.getView().showTipNotification(resultSplit[1]);
                            break;
                        }
                        default: {
                            this.continueWorkFlow();
                        }
                    }
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        boolean confirmResult;
        Object returnDataObject;
        if (null == e) {
            return;
        }
        String callBackId = e.getActionId();
        if (FORM_ID.equals(callBackId) && null != (returnDataObject = e.getReturnData()) && (confirmResult = Boolean.parseBoolean(returnDataObject.toString()))) {
            this.continueWorkFlow();
        }
    }

    private void continueWorkFlow() {
        BeforeSubmitCustomEventArgsClosedCallBack args = new BeforeSubmitCustomEventArgsClosedCallBack((Object)this.getView(), null, null, null);
        args.setDoSubmitTask(true);
        this.getPageCache().put(PAGE_CACHE_KEY_CALLBACK, "true");
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)args);
    }
}

