/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.sdk.annotation.SdkDeprecated;

public class ThreadService {
    private static final kd.bos.unifiedthreadpool.api.ThreadExecutorService THREAD_EXECUTOR;

    public static void execute(Runnable command, TaskType taskType) {
        ThreadService.execute(command, taskType, null);
    }

    @SdkDeprecated
    public static void execute(Runnable command, TaskType taskType, RequestContext context) {
        ThreadService.execute(command, taskType, context, null);
    }

    public static void execute(Runnable command, TaskType taskType, RequestContext context, OperationContext oc) {
        ThreadExecutorService executeService = taskType.getExtStrategy().getExecuteService();
        executeService.execute(command, taskType.getName(), context, oc);
    }

    public static <T> Future<T> submit(Callable<T> task, TaskType taskType) {
        return ThreadService.submit(task, taskType, null, null);
    }

    public static <T> Future<T> submit(Callable<T> task, TaskType taskType, RequestContext context) {
        return ThreadService.submit(task, taskType, context, null);
    }

    public static <T> Future<T> submit(Callable<T> task, TaskType taskType, RequestContext context, OperationContext oc) {
        ThreadExecutorService executeService = taskType.getExtStrategy().getExecuteService();
        return executeService.submit(task, taskType.getName(), context, oc);
    }

    protected static kd.bos.unifiedthreadpool.api.ThreadExecutorService getThreadExecutor() {
        return THREAD_EXECUTOR;
    }

    static {
        ThreadPoolStrategy threadPoolStrategy = ThreadPoolStrategyFactory.create();
        threadPoolStrategy.setMaxThreadNum(150);
        threadPoolStrategy.setMinThreadNum(50);
        threadPoolStrategy.setOverflowThreadNum(20);
        threadPoolStrategy.setThreadIdeMinutes(1L);
        for (TaskType taskType : TaskType.values()) {
            threadPoolStrategy.register(taskType.build());
        }
        THREAD_EXECUTOR = ThreadPoolFactory.create((String)"fi", (String)"fi-threadpool", (ThreadPoolStrategy)threadPoolStrategy);
    }
}

