/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.botp.helper.CasHelper;
import kd.bos.ext.fi.func.BaseDataBean;
import kd.bos.ext.fi.plugin.ArApConvert.util.EmptyUtils;
import kd.bos.ext.fi.util.FiCacheManager;

public class MatchingHelper {
    private static final String MATCHING_KEY_PREFIX = "fun_match_";
    private static final int MATCHING_TIMEOUT_SECOND = 300;
    private static final String OPP_BANK_NUMBER = "oppbanknumber";

    public static String getMatchingRedisKey(Long orgId, String matchingText, String entityName) {
        return MATCHING_KEY_PREFIX + orgId + "_" + entityName + "_" + matchingText;
    }

    public static void putCache(String key, Object value) {
        FiCacheManager.put(key, value, 300);
    }

    public static BaseDataBean getMatchDataFromCache(String key) {
        return FiCacheManager.get(key, BaseDataBean.class);
    }

    public static String getMatchingRedisKey(DynamicObject detail, String matchingText, String entity, Long orgId) {
        String cacheKey;
        if (StringUtils.equals((CharSequence)entity, (CharSequence)"bei_transdetail_cas") && CasHelper.isNotEmpty(detail) && CasHelper.isNotEmpty(detail.getString(OPP_BANK_NUMBER))) {
            String oppBankNumber = detail.getString(OPP_BANK_NUMBER);
            cacheKey = MatchingHelper.getMatchingRedisKey(orgId, EmptyUtils.isNotEmpty(matchingText) ? oppBankNumber + "_" + matchingText : oppBankNumber, entity);
        } else {
            cacheKey = MatchingHelper.getMatchingRedisKey(orgId, EmptyUtils.isNotEmpty(matchingText) ? matchingText : "", entity);
        }
        return cacheKey;
    }
}

