/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.util.price;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.ext.fi.util.price.AbstractPriceCalculator;
import kd.sdk.annotation.SdkDeprecated;

@SdkDeprecated
public class TaxUnitPriceCalculator
extends AbstractPriceCalculator {
    public TaxUnitPriceCalculator(BigDecimal quantity, BigDecimal taxunitprice, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision) {
        this.isTax = true;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.taxunitprice = taxunitprice.setScale(10, RoundingMode.HALF_UP);
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
    }

    public TaxUnitPriceCalculator(BigDecimal quantity, BigDecimal taxunitprice, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision, BigDecimal adjustamt) {
        this.isTax = true;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.taxunitprice = taxunitprice.setScale(10, RoundingMode.HALF_UP);
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
        this.adjustamt = adjustamt;
    }

    public TaxUnitPriceCalculator(BigDecimal quantity, BigDecimal taxunitprice, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision, BigDecimal adjustamt, BigDecimal discountAmt) {
        this.isTax = true;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.taxunitprice = taxunitprice.setScale(10, RoundingMode.HALF_UP);
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
        this.adjustamt = adjustamt;
        if ("TOTAL".equals(discountmode)) {
            this.discountamount = discountAmt;
        }
    }

    @Override
    public void calculate() {
        this.unitprice = this.taxunitprice.divide(ONE.add(this.taxrate), 10, RoundingMode.HALF_UP);
        if ("PERCENT".equals(this.discountmode)) {
            this.discountamount = this.taxunitprice.multiply(this.quantity).multiply(this.discountrate.divide(ONE_HUNDRED)).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        } else if ("PERUNIT".equals(this.discountmode)) {
            this.discountamount = this.quantity.multiply(this.discountrate).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        }
        this.pricetaxtotal = this.taxunitprice.multiply(this.quantity).setScale(this.currencyPrecision, RoundingMode.HALF_UP).subtract(this.discountamount);
        this.tax = this.pricetaxtotal.multiply(this.taxrate).divide(ONE.add(this.taxrate), 10, RoundingMode.HALF_UP).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        this.amount = this.pricetaxtotal.subtract(this.tax);
        this.pricetaxtotal = this.pricetaxtotal.add(this.adjustamt);
        if (this.discountamount.compareTo(BigDecimal.ZERO) == 0) {
            this.actunitprice = this.unitprice;
            this.acttaxunitprice = this.taxunitprice;
        } else {
            this.actunitprice = this.amount.divide(this.quantity, 10, RoundingMode.HALF_UP);
            this.acttaxunitprice = this.pricetaxtotal.divide(this.quantity, 10, RoundingMode.HALF_UP);
        }
    }
}

