/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.pmgt.bizrule;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public interface ProjectBudgetControlOpAction {
    public static final Log log = LogFactory.getLog(ProjectBudgetControlOpAction.class);

    default public void doAction(DynamicObject[] bills, String methodName, String operationKey) {
        if (bills == null || bills.length == 0 || methodName == null || operationKey == null) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                List billList = Arrays.stream(bills).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"pmgt", (String)"pmbs", (String)"ProjectBudgetService", (String)methodName, (Object[])new Object[]{billList, operationKey});
            }
            catch (Exception e1) {
                h.markRollback();
                log.error("updateBudgetError\uff1a", (Throwable)e1);
                if (e1.getMessage() == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u9879\u76ee\u4e91\u201c\u9879\u76ee\u9884\u7b97\u63a5\u53e3\u201d\u5931\u8d25\uff0c\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"ProjectBudgetControlOpAction_0", (String)"bos-ext-fi", (Object[])new Object[0]));
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u9879\u76ee\u4e91\u201c\u9879\u76ee\u9884\u7b97\u63a5\u53e3\u201d\u62a5\u9519\uff0c\u62a5\u9519\u4fe1\u606f\uff1a%s\u3002", (String)"ProjectBudgetControlOpAction_1", (String)"bos-ext-fi", (Object[])new Object[0]), e1.getMessage()));
            }
        }
    }
}

