/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.pmgt.validate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class ProjectBudgetUpdateValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        boolean enableBatchOp = ProjectBudgetUpdateValidator.enableBatchOpParam();
        if (enableBatchOp) {
            List bills = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
            Object result = DispatchServiceHelper.invokeBizService((String)"pmgt", (String)"pmbs", (String)"ProjectBudgetService", (String)"batchValidateBudget", (Object[])new Object[]{bills, this.getOperateKey()});
            this.setErrorMsg(dataEntities, result);
        } else {
            if (dataEntities.length > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d7\u9879\u76ee\u4e91\u9884\u7b97\u63a7\u5236\u7684\u5355\u636e\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\u4e1a\u52a1\uff0c\u8bf7\u53ea\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"ProjectBudgetUpdateValidator_0", (String)"bos-ext-fi", (Object[])new Object[0]));
            }
            DynamicObject bill = dataEntities[0].getDataEntity();
            Object result = DispatchServiceHelper.invokeBizService((String)"pmgt", (String)"pmbs", (String)"ProjectBudgetService", (String)"validateBudget", (Object[])new Object[]{bill, this.getOperateKey()});
            this.setErrorMsg(dataEntities, result);
        }
    }

    private static boolean enableBatchOpParam() {
        boolean enableBatchOp = false;
        QFilter qFilter = new QFilter("appid", "=", (Object)"03PF22H/7KKW");
        qFilter.and("key", "=", (Object)"PMGT_BUDGET_ENABLE_BATCH_OP");
        Map customParamAppMap = BusinessDataServiceHelper.loadFromCache((String)"bos_customparam_app", (String)"id,value", (QFilter[])new QFilter[]{qFilter});
        if (!customParamAppMap.isEmpty()) {
            Set customParamApps = customParamAppMap.entrySet();
            for (Map.Entry customParamApp : customParamApps) {
                DynamicObject dyObj = (DynamicObject)customParamApp.getValue();
                Object value = dyObj.get("value");
                if (value == null || !value.toString().equalsIgnoreCase("true") && !value.toString().equalsIgnoreCase("false")) continue;
                enableBatchOp = Boolean.parseBoolean(value.toString());
            }
        }
        return enableBatchOp;
    }

    private void setErrorMsg(ExtendedDataEntity[] dataEntities, Object result) {
        Object resultObject = JSON.toJSON((Object)result);
        JSONObject resultJson = JSON.parseObject((String)resultObject.toString());
        boolean outOfControl = resultJson.getBoolean("outOfControl");
        boolean outOfRemind = resultJson.getBoolean("outOfRemind");
        String msg = resultJson.getString("msg");
        if (StringUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        if (outOfControl) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.addErrorMessage(dataEntity, msg);
            }
            return;
        }
        if (outOfRemind) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.addWarningMessage(dataEntity, msg);
            }
        }
    }
}

