/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkDeprecated;

public class DapFunctionTypes {
    private static Log log = LogFactory.getLog(DapFunctionTypes.class);
    public static final String FuncFile_FI_Dap = "/FI_DapFunctionTypes.xml";
    private static final String FUNCFILE_FI_DAP_EN_US = "/FI_DapFunctionTypes.en_US.xml";
    public static final String DapFuncModelDefineFile = "/dap/func/dapfuncmodules.txt";
    private static final String FUNC_PATH = "/dap/func/";
    private static final String FUNC_ENDSUFFIX = ".func";
    private static final String FUNC_END_LANG = "en_US";
    private static FunctionTypes sysDapFuncs = null;
    private static String sysDapType = null;
    private static String sysLanguage = null;

    @SdkDeprecated
    public static synchronized FunctionTypes get() {
        return DapFunctionTypes.get("bill");
    }

    @SdkDeprecated
    public static synchronized FunctionTypes get(String type) {
        String language = ResManager.getLanguage();
        if (!type.equals(sysDapType) || !language.equals(sysLanguage)) {
            DynamicObjectCollection collection;
            URL url_dap = FunctionTypes.class.getResource(DapFunctionTypes.getFuncFileName());
            sysDapFuncs = FunctionTypes.get((URL)url_dap, (boolean)true);
            FunctionTypes bizBillFuncTypes = DapFunctionTypes.loadBizCloudFuncTypes();
            sysDapFuncs.getFunctionGroups().addAll(bizBillFuncTypes.getFunctionGroups());
            sysDapFuncs.getFunctionTypes().addAll(bizBillFuncTypes.getFunctionTypes());
            if ("event".equals(type) && !(collection = QueryServiceHelper.query((String)"ai_event_fx_black", (String)"group,fx", null, null)).isEmpty()) {
                for (DynamicObject object : collection) {
                    Iterator iterator = sysDapFuncs.getFunctionTypes().iterator();
                    while (iterator.hasNext()) {
                        if (!object.get("fx").equals(((FunctionType)iterator.next()).getName().toString().trim())) continue;
                        iterator.remove();
                    }
                }
            }
        }
        sysDapType = type;
        sysLanguage = language;
        return sysDapFuncs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FunctionTypes loadBizCloudFuncTypes() {
        FunctionTypes functionTypes = new FunctionTypes();
        InputStream modulesStream = FunctionTypes.class.getResourceAsStream(DapFuncModelDefineFile);
        if (modulesStream != null) {
            BufferedReader modulesReader = null;
            String modules = null;
            try {
                String[] mos;
                modulesReader = new BufferedReader(new InputStreamReader(modulesStream));
                modules = modulesReader.readLine();
                if (StringUtils.isNotEmpty((String)modules) && (mos = modules.split(",")) != null && mos.length > 0) {
                    for (String m : mos) {
                        URL url = FunctionTypes.class.getResource(DapFunctionTypes.getFuncPath(m));
                        if (url == null) continue;
                        FunctionTypes appFuncs = FunctionTypes.get((URL)url, (boolean)false);
                        functionTypes.getFunctionGroups().addAll(appFuncs.getFunctionGroups());
                        functionTypes.getFunctionTypes().addAll(appFuncs.getFunctionTypes());
                    }
                }
            }
            catch (IOException e1) {
                log.error((Throwable)e1);
            }
            finally {
                try {
                    if (modulesReader != null) {
                        modulesReader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return functionTypes;
    }

    private static String getFuncFileName() {
        String language = ResManager.getLanguage().toLowerCase();
        if (language.startsWith("en_")) {
            return FUNCFILE_FI_DAP_EN_US;
        }
        return FuncFile_FI_Dap;
    }

    private static String getFuncPath(String module) {
        String language = ResManager.getLanguage().toLowerCase();
        StringBuilder sb = new StringBuilder(FUNC_PATH);
        sb.append(module.toLowerCase());
        if (language.startsWith("en_")) {
            sb.append(".").append(FUNC_END_LANG);
        }
        sb.append(FUNC_ENDSUFFIX);
        return sb.toString();
    }
}

