/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.writeback;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.AbstractDapWriteBackImpl;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.helper.DapServiceHelper;

public abstract class AbstractDapVoucherWriteBack
extends AbstractDapWriteBackImpl {
    private static final Log log = LogFactory.getLog(AbstractDapVoucherWriteBack.class);

    @Override
    public void writeBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)billEntityNumber);
        Set<Long> keySet = billToVch.keySet();
        log.info("AbstractDapVoucherWriteBack#keySet:" + keySet);
        if (VoucherOperation.Create == operation || VoucherOperation.Submit == operation) {
            log.info("AbstractDapVoucherWriteBack#\u5f00\u59cb\u6267\u884c\u751f\u6210\u51ed\u8bc1\u53cd\u5199:" + (Object)((Object)operation));
            Object vchStatusField = this.getVchEnableStatus();
            ArrayList<Object[]> params = new ArrayList<Object[]>(billToVch.size());
            for (Long me : keySet) {
                Object[] param = new Object[]{vchStatusField, me};
                params.add(param);
                if (params.size() < 1000) continue;
                log.info("AbstractDapVoucherWriteBack#\u5f00\u59cb\u6267\u884c\u751f\u6210\u51ed\u8bc1\u53cd\u5199SQL\uff0cmt.getAlias()\uff1a{}\uff0cgetVchStatusField()\uff1a{}", (Object)mt.getAlias(), (Object)this.getVchStatusField());
                this.batchExecuteSql(this.getDBRoute(), "update " + mt.getAlias() + " set " + this.getVchStatusField() + " = ?  where fid = ?", params);
                log.info("AbstractDapVoucherWriteBack#\u7ed3\u675f\u6267\u884c\u751f\u6210\u51ed\u8bc1\u53cd\u5199SQL");
                params.clear();
            }
            log.info("AbstractDapVoucherWriteBack#\u6700\u540e#\u5f00\u59cb\u6267\u884c\u751f\u6210\u51ed\u8bc1\u53cd\u5199SQL\uff0cmt.getAlias()\uff1a{}\uff0cgetVchStatusField()\uff1a{}", (Object)mt.getAlias(), (Object)this.getVchStatusField());
            if (params.size() > 0) {
                this.batchExecuteSql(this.getDBRoute(), "update " + mt.getAlias() + " set " + this.getVchStatusField() + " = ?  where fid = ?", params);
            }
            log.info("AbstractDapVoucherWriteBack#\u6700\u540e#\u7ed3\u675f\u6267\u884c\u751f\u6210\u51ed\u8bc1\u53cd\u5199SQL");
        } else if (VoucherOperation.Delete == operation) {
            log.info("AbstractDapVoucherWriteBack#\u5f00\u59cb\u6267\u884c\u5220\u9664\u51ed\u8bc1\u53cd\u5199:" + (Object)((Object)operation));
            Map<Long, Set<Long>> billVoucherIdMap = this.getBillVoucherIdsMap(billEntityNumber, keySet);
            Object vchDisableStatus = this.getVchDisableStatus();
            ArrayList<Object[]> params = new ArrayList<Object[]>(keySet.size());
            for (Map.Entry<Long, Voucher> entry : billToVch.entrySet()) {
                boolean isExistsVoucher;
                Long me = entry.getKey();
                long voucherId = entry.getValue().getId();
                Set<Long> existsVouchers = billVoucherIdMap.get(me);
                boolean bl = isExistsVoucher = existsVouchers != null;
                if (isExistsVoucher) {
                    existsVouchers.removeIf(v -> voucherId == v);
                }
                if (!isExistsVoucher || existsVouchers.isEmpty()) {
                    Object[] param = new Object[]{vchDisableStatus, me};
                    params.add(param);
                }
                if (params.size() < 1000) continue;
                log.info("AbstractDapVoucherWriteBack#\u5f00\u59cb\u6267\u884c\u5220\u9664\u51ed\u8bc1\u53cd\u5199SQL\uff0cmt.getAlias()\uff1a{}\uff0cgetVchStatusField()\uff1a{}", (Object)mt.getAlias(), (Object)this.getVchStatusField());
                this.batchExecuteSql(this.getDBRoute(), "update " + mt.getAlias() + " set " + this.getVchStatusField() + " = ?  where fid = ?", params);
                params.clear();
                log.info("AbstractDapVoucherWriteBack#\u7ed3\u675f\u6267\u884c\u5220\u9664\u51ed\u8bc1\u53cd\u5199SQL");
            }
            log.info("AbstractDapVoucherWriteBack#\u6700\u540e#\u5f00\u59cb\u6267\u884c\u5220\u9664\u51ed\u8bc1\u53cd\u5199SQL\uff0cmt.getAlias()\uff1a{}\uff0cgetVchStatusField()\uff1a{}", (Object)mt.getAlias(), (Object)this.getVchStatusField());
            if (params.size() > 0) {
                this.batchExecuteSql(this.getDBRoute(), "update " + mt.getAlias() + " set " + this.getVchStatusField() + " = ?  where fid = ?", params);
            }
            log.info("AbstractDapVoucherWriteBack#\u6700\u540e#\u7ed3\u675f\u6267\u884c\u5220\u9664\u51ed\u8bc1\u53cd\u5199SQL");
        }
    }

    @Override
    protected String getVchStatusField() {
        return "fisvoucher";
    }

    @Override
    protected Object getVchEnableStatus() {
        return true;
    }

    @Override
    protected Object getVchDisableStatus() {
        return false;
    }

    @Override
    protected DBRoute getDBRoute() {
        return DBRoute.of((String)"cas");
    }

    public int[] batchExecuteSql(DBRoute db, String sql, List<Object[]> params) {
        return DB.executeBatch((DBRoute)db, (String)sql, params);
    }

    private Map<Long, Set<Long>> getBillVoucherIdsMap(String billEntityNumber, Set<Long> billIds) {
        HashMap<Long, Set<Long>> billVoucherIdsMap = new HashMap<Long, Set<Long>>(16);
        BillToVchRelationDto billToVchRelationDto = DapServiceHelper.getBillToVchReDtoByBillTypeAndIds(billEntityNumber, billIds);
        for (BillToVchRelationDto.BillToVoucherRelation relation : billToVchRelationDto) {
            Set voucherIds = billVoucherIdsMap.computeIfAbsent(relation.getBillId(), k -> new HashSet());
            voucherIds.add(relation.getVoucherId());
        }
        return billVoucherIdsMap;
    }
}

