/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.dap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.AbstractDapWriteBackImpl;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.fi.fa.formplugin.dap.AccDateValidateUtil;

public class FaBillWriteBackVoucher
extends AbstractDapWriteBackImpl {
    private static final List<String> SPECIAL_BILL_NUMBER = Arrays.asList("fa_change_dept", "fa_mergebill", "fa_assetsplitbill");
    private static String FIN_BILL_NUMBER = "fa_card_fin";

    @Override
    public void writeBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        if (SPECIAL_BILL_NUMBER.contains(billEntityNumber)) {
            MainEntityType mt = EntityMetadataCache.getDataEntityType((String)billEntityNumber);
            if (VoucherOperation.Create == operation) {
                DB.execute((DBRoute)this.getDBRoute(), (String)("update " + mt.getAlias() + " set fvoucherflag = ?  where fid in (" + StringUtils.join((Object[])billToVch.keySet().toArray(), (char)',') + ")"), (Object[])new Object[]{"C"});
            } else if (VoucherOperation.Delete == operation) {
                DB.execute((DBRoute)this.getDBRoute(), (String)("update " + mt.getAlias() + " set fvoucherflag = ?  where fid in (" + StringUtils.join((Object[])billToVch.keySet().toArray(), (char)',') + ")"), (Object[])new Object[]{"B"});
            }
        } else if (FIN_BILL_NUMBER.equals(billEntityNumber)) {
            Set<Long> finIdSet = billToVch.keySet();
            SqlBuilder queryFinCardSql = new SqlBuilder();
            queryFinCardSql.append("select fnumber,forg from t_fa_card_fin where", new Object[0]);
            queryFinCardSql.appendIn("fid", finIdSet.toArray());
            DataSet finDs = DB.queryDataSet((String)"kd.fi.fa.formplugin.dap.FaBillWriteBackVoucher", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)queryFinCardSql);
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
            if (VoucherOperation.Create == operation) {
                String updateSql = "update t_fa_card_fin set fhasvoucher = '1' where fnumber = ? and forg = ?;";
                for (Row fin : finDs) {
                    String fnumber = fin.getString("fnumber");
                    long orgId = fin.getLong("forg");
                    Object[] param = new Object[]{fnumber, orgId};
                    updateParams.add(param);
                    if (updateParams.size() < 10000) continue;
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)updateSql, updateParams);
                    updateParams.clear();
                }
                if (updateParams.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)updateSql, updateParams);
                }
            } else if (VoucherOperation.Delete == operation) {
                String updateSql = "update t_fa_card_fin set fhasvoucher = '0' where fnumber = ? and forg = ?;";
                for (Row fin : finDs) {
                    String fnumber = fin.getString("fnumber");
                    long orgId = fin.getLong("forg");
                    Object[] param = new Object[]{fnumber, orgId};
                    updateParams.add(param);
                    if (updateParams.size() < 10000) continue;
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)updateSql, updateParams);
                    updateParams.clear();
                }
                if (updateParams.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)updateSql, updateParams);
                }
            }
        } else {
            long exitVoucher = EntityMetadataCache.getDataEntityType((String)billEntityNumber).getAllFields().values().stream().filter(v -> "fhasvoucher".equals(v.getAlias())).count();
            if (exitVoucher > 0L) {
                super.writeBack(operation, billEntityNumber, billToVch);
            }
        }
    }

    @Override
    protected String getVchStatusField() {
        return "fhasvoucher";
    }

    @Override
    protected Object getVchEnableStatus() {
        return true;
    }

    @Override
    protected Object getVchDisableStatus() {
        return false;
    }

    @Override
    protected DBRoute getDBRoute() {
        return DBRoute.of((String)"fa");
    }

    @Override
    public Map<Long, String> validate(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(billToVch.size());
        if (VoucherOperation.Delete == operation) {
            Map<Long, Long> billToVchIdMap = billToVch.entrySet().stream().filter(v -> v.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, v -> ((Voucher)v.getValue()).getId()));
            AccDateValidateUtil.validateAccDateDelete(billEntityNumber, billToVchIdMap, resultMap);
        }
        return resultMap;
    }
}

