/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.iep.info.IntellExceOperInfo;
import kd.fi.iep.info.IntellExecDetailLog;
import kd.fi.iep.util.LogORMHelper;

public class IntellAccountSchemaExecLogDaoNew {
    private static final Log logger = LogFactory.getLog((String)"IntellAccountSchemaExecLogDaoNew");

    public static boolean containsProperty(MainEntityType type, String key) {
        return type.getAllFields().containsKey(key);
    }

    public static void batchInsertExceLog(IntellExceOperInfo exceOperInfo, Date execstartdate, Object[] sucessList, String status, String msg, String traceId) {
        if (sucessList == null || sucessList.length == 0 || IntellAccountSchemaExecLogDaoNew.isDeleteOpe(exceOperInfo)) {
            logger.info("\u667a\u80fd\u6838\u7b97\u540e\u53f0\u4e8b\u52a1\u65e5\u5fd7\uff0c\u63d2\u5165\u65e5\u5fd7\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)exceOperInfo.getBussiness());
        String numberProp = null;
        int numberType = 0;
        if (IntellAccountSchemaExecLogDaoNew.containsProperty(type, "billno") && !type.getName().equalsIgnoreCase("ai_buildreport")) {
            numberProp = "billno";
            numberType = 1;
        } else if (IntellAccountSchemaExecLogDaoNew.containsProperty(type, "number")) {
            numberProp = "number";
            numberType = 2;
        }
        StringBuilder sel = new StringBuilder("id");
        if (Objects.nonNull(type.getMainOrg())) {
            sel.append(",").append(type.getMainOrg());
            sel.append(",").append(type.getMainOrg()).append(".number");
            sel.append(",").append(type.getMainOrg()).append(".name");
        }
        if (Objects.nonNull(numberProp)) {
            sel.append(",").append(numberProp);
        }
        try (TXHandle h = TX.requiresNew();){
            DynamicObjectCollection coll = QueryServiceHelper.query((String)exceOperInfo.getBussiness(), (String)sel.toString(), (QFilter[])new QFilter("id", "in", (Object)sucessList).toArray());
            DynamicObjectCollection exeLogArray = new DynamicObjectCollection();
            ArrayList<IntellExecDetailLog> execDetailLogs = new ArrayList<IntellExecDetailLog>(coll.size());
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"iep_intellexecdetaillog");
                IntellAccountSchemaExecLogDaoNew.createExeLog(exceOperInfo, execstartdate, logObj, (DynamicObject)coll.get(i), status, exceOperInfo.getOperLogId(), numberType, msg, type.getMainOrg(), traceId);
                exeLogArray.add(i, logObj);
                if (i >= 1000) continue;
                execDetailLogs.add(new IntellExecDetailLog(logObj, exceOperInfo.getBussinessName()));
            }
            if (exeLogArray.size() == 0) {
                return;
            }
            try {
                LogORMHelper.insert((List<DynamicObject>)exeLogArray);
                exceOperInfo.addAllExecDetailLogs(execDetailLogs);
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("\u667a\u80fd\u6838\u7b97\u540e\u53f0\u4e8b\u52a1\u65e5\u5fd7\uff0c\u6267\u884c\u6210\u529f\u7684\u5355\u636e\uff0c\u63d2\u5165\u65e5\u5fd7\u6570\u636e\u53d1\u751f\u62a5\u9519:" + e);
                throw e;
            }
        }
    }

    public static void batchInsertExceLog(IntellExceOperInfo exceOperInfo, Date execstartdate, Object[] srcbillObjs, String status, Map<Object, String> pkErrorMap, String traceId) {
        if (srcbillObjs == null || srcbillObjs.length <= 0) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)exceOperInfo.getBussiness());
        String numberProp = null;
        int numberType = 0;
        if (IntellAccountSchemaExecLogDaoNew.containsProperty(type, "billno")) {
            numberProp = "billno";
            numberType = 1;
        } else if (IntellAccountSchemaExecLogDaoNew.containsProperty(type, "number")) {
            numberProp = "number";
            numberType = 2;
        }
        StringBuilder sel = new StringBuilder("id");
        if (Objects.nonNull(type.getMainOrg())) {
            sel.append(",").append(type.getMainOrg());
            sel.append(",").append(type.getMainOrg()).append(".number");
            sel.append(",").append(type.getMainOrg()).append(".name");
        }
        if (Objects.nonNull(numberProp)) {
            sel.append(",").append(numberProp);
        }
        try (TXHandle h = TX.requiresNew();){
            DynamicObjectCollection coll = QueryServiceHelper.query((String)exceOperInfo.getBussiness(), (String)sel.toString(), (QFilter[])new QFilter("id", "in", (Object)srcbillObjs).toArray());
            DynamicObjectCollection exeLogArray = new DynamicObjectCollection();
            ArrayList<IntellExecDetailLog> execDetailLogs = new ArrayList<IntellExecDetailLog>(coll.size());
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"iep_intellexecdetaillog");
                IntellAccountSchemaExecLogDaoNew.createExeLog(exceOperInfo, execstartdate, logObj, (DynamicObject)coll.get(i), status, exceOperInfo.getOperLogId(), numberType, pkErrorMap.get(((DynamicObject)coll.get(i)).get("id")), type.getMainOrg(), traceId);
                exeLogArray.add(i, logObj);
                if (i >= 1000) continue;
                execDetailLogs.add(new IntellExecDetailLog(logObj, exceOperInfo.getBussinessName()));
            }
            if (exeLogArray.size() == 0) {
                return;
            }
            try {
                LogORMHelper.insert((List<DynamicObject>)exeLogArray);
                exceOperInfo.addAllExecDetailLogs(execDetailLogs);
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("\u667a\u80fd\u6838\u7b97\u540e\u53f0\u4e8b\u52a1\u65e5\u5fd7\uff0c\u6267\u884c\u5931\u8d25\u7684\u5355\u636e\uff0c\u63d2\u5165\u65e5\u5fd7\u6570\u636e\u53d1\u751f\u62a5\u9519:" + e);
                throw e;
            }
        }
    }

    private static void createExeLog(IntellExceOperInfo exceOperInfo, Date execstartdate, DynamicObject logObj, DynamicObject srcbillObj, String status, long operlogId, int numberType, String msg, String mainOrg, String traceId) {
        logObj.set("intelschemaid", (Object)exceOperInfo.getSchemaId());
        logObj.set("intelschemanumber", (Object)exceOperInfo.getSchemaNumber());
        logObj.set("intelschemaname", (Object)exceOperInfo.getSchemaName());
        logObj.set("bizapp", (Object)exceOperInfo.getAppId());
        logObj.set("bizappnumber", (Object)exceOperInfo.getAppNumber());
        logObj.set("bizappname", (Object)exceOperInfo.getAppName());
        logObj.set("bussiness", (Object)exceOperInfo.getBussiness());
        logObj.set("oper", (Object)exceOperInfo.getOper());
        logObj.set("opersumlogid", (Object)operlogId);
        logObj.set("schemasumlogid", (Object)exceOperInfo.getSumLogId());
        logObj.set("creator", (Object)exceOperInfo.getCreatorId());
        logObj.set("execstatus", (Object)status);
        logObj.set("execnumber", (Object)0);
        if (null != msg && msg.length() > 500) {
            msg = String.format("TraceId:%s  %s...", traceId, msg.substring(0, 500));
        }
        logObj.set("execdetail", (Object)msg);
        if (srcbillObj != null) {
            if (StringUtils.isNotBlank((CharSequence)mainOrg)) {
                logObj.set("sourceorgid", srcbillObj.get(mainOrg));
                logObj.set("sourceorgnumber", srcbillObj.get(mainOrg + ".number"));
                logObj.set("sourceorgname", srcbillObj.get(mainOrg + ".name"));
            }
            if (numberType == 1) {
                logObj.set("srcbillnumber", srcbillObj.get("billno"));
            } else if (numberType == 2) {
                logObj.set("srcbillnumber", srcbillObj.get("number"));
            }
            logObj.set("srcbillid", (Object)srcbillObj.getLong("id"));
        }
        if (execstartdate == null) {
            execstartdate = new Date();
        }
        logObj.set("createtime", (Object)execstartdate);
        logObj.set("lastexectime", (Object)execstartdate);
        logObj.set("opdate", (Object)execstartdate);
        logObj.set("opdesc", null);
        logObj.set("opname", (Object)exceOperInfo.getOperName());
        logObj.set("username", (Object)exceOperInfo.getCreatorName());
    }

    private static boolean isDeleteOpe(IntellExceOperInfo operInfo) {
        String bussiness = operInfo.getBussiness();
        String operationName = operInfo.getOper();
        List ops = EntityMetadataCache.getDataEntityOperate((String)bussiness);
        for (Map each : ops) {
            String operationkey = String.valueOf(each.get("key"));
            String type = String.valueOf(each.get("type"));
            if (!Objects.nonNull(operationkey) || !operationkey.equals(operationName)) continue;
            return "delete".equals(type);
        }
        return false;
    }

    public static void insertExceLog(IntellExceOperInfo exceOperInfo, Date execstartdate, DynamicObject srcbillObj, String status, long operlogId, int numberType, String msg, String mainOrg, String traceId) {
        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"iep_intellexecdetaillog");
        IntellAccountSchemaExecLogDaoNew.createExeLog(exceOperInfo, execstartdate, logObj, srcbillObj, status, operlogId, numberType, msg, mainOrg, traceId);
        exceOperInfo.addExecDetailLog(new IntellExecDetailLog(logObj, exceOperInfo.getBussinessName()));
        LogORMHelper.insert(Collections.singletonList(logObj));
    }

    public static void updateExceLog(List<DynamicObject> coll) {
        if (coll.size() == 0) {
            return;
        }
        LogORMHelper.update(coll);
    }

    public static int deleteExecLog(QFilter[] filters) {
        return LogORMHelper.delete("iep_intellexecdetaillog", filters);
    }

    public static DynamicObjectCollection queryExceLog(String selectFields, QFilter[] filters, int limit, int offset) {
        return LogORMHelper.query("iep_intellexecdetaillog", selectFields, filters, limit, offset);
    }

    public static DataSet queryExceLogDataSet(String selectFields, QFilter[] filters, int limit, int offset) {
        return LogORMHelper.queryDataSet("iep_intellexecdetaillog", selectFields, filters, limit, offset);
    }

    public static int countExecLog(QFilter[] filters) {
        return LogORMHelper.count("iep_intellexecdetaillog", filters);
    }
}

