/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.task;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;

public class FIDataCheckScheduleTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(FIDataCheckScheduleTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext paramRequestContext, Map<String, Object> paramMap) throws KDException {
        LOGGER.info(" FIDataCheckScheduleTask start");
        List<DynamicObject> tasks = FIDataCheckUtil.sortTask();
        if (!tasks.isEmpty()) {
            for (int i = 0; i < tasks.size(); ++i) {
                String message;
                String appId = tasks.get(i).getString("appid");
                String plugin = tasks.get(i).getString("plugin");
                String number = tasks.get(i).getString("number");
                String clouldId = tasks.get(i).getString("cloudid");
                String longId = clouldId + "." + appId;
                String serviceAppId = ServiceLookup.getServiceAppId((String)longId);
                FIDataCheckUtil.saveResult(number, serviceAppId, true, "FIDataCheckScheduleTask start", plugin.trim());
                DispatchService dispatchService = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
                boolean result = false;
                try {
                    result = (Boolean)dispatchService.invoke("kd.bos.ext.fi.servicehelper.ServiceFactory", "DataCheckService", "check", new Object[]{plugin.trim(), serviceAppId, number});
                    message = ResManager.loadKDString((String)"\u6570\u636e\u68c0\u67e5\u901a\u8fc7", (String)"FIDataCheckScheduleTask_1", (String)"bos-ext-fi", (Object[])new Object[0]);
                    if (!result) continue;
                    FIDataCheckUtil.saveResult(number, serviceAppId, result, message, plugin);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    message = "FIDataCheckScheduleTask end";
                    FIDataCheckUtil.saveResult(number, serviceAppId, result, message, plugin);
                }
            }
        }
        LOGGER.info(" FIDataCheckScheduleTask end");
    }
}

