/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.iep.enums.ExecuteType;
import kd.fi.iep.task.IntellAccountingExecPlan;
import kd.fi.iep.util.DateUtil;
import kd.fi.iep.util.IntellExecuteUtil;

public class IntellExceTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(IntellExceTask.class);

    public void execute(RequestContext paramRequestContext, Map<String, Object> paramMap) throws KDException {
        this.rebuildTable();
        LOGGER.info(" IntellExceTask execute param: {}", (Object)SerializationUtils.toJsonString(paramMap));
        if (paramMap == null || paramMap.isEmpty()) {
            return;
        }
        ExecuteType type = "1".equals(paramMap.get("type")) ? ExecuteType.MANUAL : ExecuteType.AUTO;
        List arra = paramMap.get("intellSchemaidList") instanceof String ? (List)SerializationUtils.fromJsonString((String)String.valueOf(paramMap.get("intellSchemaidList")), List.class) : (List)paramMap.get("intellSchemaidList");
        if (Objects.isNull(arra) || arra.size() == 0) {
            return;
        }
        ArrayList<Long> shemaidList = new ArrayList<Long>(arra.size());
        for (Map value : arra) {
            Long id = (Long)value.get("Id");
            if (ExecuteType.MANUAL != type && this.isStopTimeRang(id)) continue;
            shemaidList.add(id);
        }
        if (shemaidList.size() > 0) {
            IntellAccountingExecPlan com = new IntellAccountingExecPlan(shemaidList, this.taskId, type);
            com.intelSchemaHandler();
        }
    }

    private boolean isStopTimeRang(Long schemeId) {
        boolean exists = QueryServiceHelper.exists((String)"gl_intellexecschema", (Object)schemeId);
        if (exists) {
            DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"gl_intellexecschema");
            Integer currentTime = IntellExecuteUtil.getSecondByTime();
            Integer stopStartTime = schemeDyn.getInt("stoptimerange_starttime");
            Integer stopEndTime = schemeDyn.getInt("stoptimerange_endtime");
            LOGGER.info("currentTime : {}  stopStartTime : {} stopEndTime : {}", new Object[]{currentTime, stopStartTime, stopEndTime});
            return currentTime <= stopEndTime && currentTime >= stopStartTime;
        }
        return true;
    }

    private void rebuildTable() {
        try (TXHandle txHandle = TX.requiresNew();){
            Date date = DateUtil.getDateFormat(new Date(), true);
            QFilter filter = QFilter.of((String)"lastexectime < ?", (Object[])new Object[]{date});
            boolean exists = QueryServiceHelper.exists((String)"iep_todaycomplete", (QFilter[])filter.toArray());
            if (exists) {
                DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)"truncate table t_iep_todaycomplete");
                DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)"truncate table t_iep_todaycompentry");
                LOGGER.info("-IntellExceTask- {}", (Object)date);
            }
        }
        catch (Exception e) {
            LOGGER.error("-IntellExceTask- faile:", (Throwable)e);
        }
    }
}

