/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fa.business.util.FiBillParamUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.fi.iep.dao.FormDesignDao;
import kd.fi.iep.dao.IntellAccountSchemaExecLogDao;
import kd.fi.iep.dao.IntellAccountSchemaExecLogDaoNew;
import kd.fi.iep.enums.ExecuteStatus;
import kd.fi.iep.enums.ExecuteType;
import kd.fi.iep.info.IntellExceOperInfo;
import kd.fi.iep.info.IntellSchemeExecInfo;
import kd.fi.iep.task.AbstractExecute;
import kd.fi.iep.task.impl.VchBatchExecute;
import kd.fi.iep.util.IntellExecuteUtil;

public class VoucherBatchBuildExecService {
    private static final Log LOG = LogFactory.getLog(VoucherBatchBuildExecService.class);
    private static final int MAX_PROCESS_RECORDS = 100000;
    private static final int MAX_BUSINESS_COUNT = 1000000;
    protected static final int BATCH_SIZE = 2000;
    private IntellSchemeExecInfo schemeExecInfo;
    private List<QFilter> commonFilters;
    private String scheduleTaskId;
    private ExecuteType paramType;
    private long sumLogId;
    private long operSumLogId;
    private VchBatchExecute vchBatchExecute;
    private AtomicBoolean isExistFailBill = new AtomicBoolean(false);

    public VoucherBatchBuildExecService(IntellSchemeExecInfo schemeExecInfo, List<QFilter> commonDataFilters, String taskId, ExecuteType taskParamType, long sumLogId, long operSumLogId, VchBatchExecute vchBatchExecute) {
        this.schemeExecInfo = schemeExecInfo;
        this.commonFilters = commonDataFilters;
        this.scheduleTaskId = taskId;
        this.paramType = taskParamType;
        this.sumLogId = sumLogId;
        this.operSumLogId = operSumLogId;
        this.vchBatchExecute = vchBatchExecute;
    }

    public void executeBatch() {
        block6: {
            try {
                String orgFieldName = this.getEntityOrgFieldName();
                String[] groupbys = this.getGroupbys();
                DataSet billData = this.getIdByBill(orgFieldName, groupbys);
                if (Objects.isNull(orgFieldName)) {
                    orgFieldName = "org";
                }
                if (this.isEnableBusinesstask()) {
                    LOG.info(" isEnableBusinesstask_boolean {}", (Object)true);
                    DataSet successBusinessData = this.getIdByBusinessTask();
                    String[] selectFields = (String[])Stream.concat(Stream.of("id", orgFieldName), Arrays.stream(groupbys)).distinct().toArray(String[]::new);
                    DataSet billDataCopy = billData.copy().join(successBusinessData).on("id", "sourcebillid").select(selectFields).finish();
                    this.process(billDataCopy, orgFieldName, groupbys);
                }
                if (this.isEnableDapw()) {
                    LOG.info(" isEnableDapw_boolean {}", (Object)true);
                    DataSet tableData = this.getIdByTableDapw();
                    boolean isKingdeeISV = this.isEntityKingdeeISV();
                    LOG.info(" isKingdeeISV_boolean {}", (Object)isKingdeeISV);
                    if (tableData != null && (isKingdeeISV || !tableData.isEmpty())) {
                        String[] selectFields = (String[])Stream.concat(Stream.of("id", orgFieldName), Arrays.stream(groupbys)).distinct().toArray(String[]::new);
                        billData = billData.join(tableData).on("id", "sourcebillid").on(orgFieldName, "orgid").select(selectFields).finish();
                    }
                }
                this.process(billData, orgFieldName, groupbys);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                if (this.operSumLogId == 0L) break block6;
                this.writeErrorLog(e.getMessage());
            }
        }
    }

    private boolean isEnableDapw() {
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>(3);
        customFilters.add(new QFilter("org", "=", (Object)0L));
        customFilters.add(new QFilter("depreuse", "=", (Object)0L));
        customFilters.add(new QFilter("entity", "=", (Object)this.schemeExecInfo.getExceOperInfo().getBussiness()));
        String valueStr = FiBillParamUtil.getStringValue("83bfebc8000002ac", "3815fd11000209ac", "fi.iep.task.enabledapw", customFilters, false);
        return StringUtils.isEmpty((String)valueStr) || Boolean.parseBoolean(valueStr);
    }

    private boolean isEnableBusinesstask() {
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>(3);
        customFilters.add(new QFilter("org", "=", (Object)0L));
        customFilters.add(new QFilter("depreuse", "=", (Object)0L));
        customFilters.add(new QFilter("entity", "=", (Object)this.schemeExecInfo.getExceOperInfo().getBussiness()));
        String valueStr = FiBillParamUtil.getStringValue("83bfebc8000002ac", "3815fd11000209ac", "fi.iep.task.enablebusinesstask", customFilters, false);
        return StringUtils.isNotEmpty((String)valueStr) && Boolean.parseBoolean(valueStr);
    }

    private DataSet getIdByBill(String orgFieldName, String[] groupbys) {
        DataSet result;
        if (Objects.nonNull(orgFieldName)) {
            String selectFields = Stream.concat(Stream.of("id", orgFieldName), Arrays.stream(groupbys)).distinct().collect(Collectors.joining(","));
            result = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.schemeExecInfo.getExceOperInfo().getBussiness(), (String)selectFields, (QFilter[])this.commonFilters.toArray(new QFilter[0]), null);
        } else {
            orgFieldName = "org";
            String selectFields = Stream.concat(Stream.of("id"), Arrays.stream(groupbys)).distinct().collect(Collectors.joining(","));
            result = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.schemeExecInfo.getExceOperInfo().getBussiness(), (String)selectFields, (QFilter[])this.commonFilters.toArray(new QFilter[0]), null).addField("0L", orgFieldName);
        }
        result = result.distinct();
        return result;
    }

    private DataSet getIdByTableDapw() {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.schemeExecInfo.getExceOperInfo().getBussiness());
        DBRoute dbRouteKey = DBRoute.of((String)dataEntityType.getDBRouteKey());
        String tableName = dataEntityType.getAlias() + "_DAPW";
        boolean exitsTable = DB.exitsTable((DBRoute)dbRouteKey, (String)tableName);
        DataSet tableData = null;
        if (exitsTable) {
            String sqlQuery = "SELECT fsourcebillid sourcebillid,forgid orgid FROM " + tableName;
            tableData = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRouteKey, (String)sqlQuery);
        }
        return tableData;
    }

    private DataSet getIdByBusinessTask() {
        DataSet successBusinessData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"iep_businesstask", (String)"entityid sourcebillid", (QFilter[])new QFilter("business", "=", (Object)this.schemeExecInfo.getExceOperInfo().getBussiness()).toArray(), null);
        return successBusinessData;
    }

    private void process(DataSet billData, String orgFieldName, String[] groupbys) {
        Date execStartDate = new Date();
        IntellExceOperInfo exceOperInfo = this.schemeExecInfo.getExceOperInfo();
        if (billData.isEmpty()) {
            LOG.info("intell_schema_build_voucher batch: 0, just tag, dont write log.");
            String bussinessName = FormDesignDao.getFormName(exceOperInfo.getBussiness());
            String msg = String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7b26\u5408\u8be5\u65b9\u6848\u3010%1$s%2$s\u3011\u64cd\u4f5c\u7684\u524d\u7f6e\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"VoucherBatchBuildExecService_1", (String)"bos-ext-fi", (Object[])new Object[0]), bussinessName, exceOperInfo.getOperName());
            exceOperInfo.setExecDetails(msg);
            return;
        }
        if (ExecuteType.AUTO == exceOperInfo.getExecuteType()) {
            DataSet removeFailBillId = AbstractExecute.removeFailBillId(this.schemeExecInfo.getExceOperInfo(), this.isExistFailBill);
            final HashSet removeFailBillIds = new HashSet(16);
            removeFailBillId.forEach(x -> removeFailBillIds.add(x.getLong("srcbillid")));
            LOG.info(" remove fail billid size {}", (Object)removeFailBillIds.size());
            billData = billData.filter(new FilterFunction(){
                private static final long serialVersionUID = 3098195192275394299L;

                public boolean test(Row row) {
                    return !removeFailBillIds.contains(row.getLong("id"));
                }
            });
        }
        int size = billData.copy().count("id", false);
        LOG.info(" processBillData_size {}", (Object)size);
        this.schemeExecInfo.appendRecordTC(size);
        IntellSchemeExecInfo.execInfoWriteCache(this.schemeExecInfo);
        int BATCH_SIZE = Math.max(this.schemeExecInfo.getExceOperInfo().getEachbatchsize(), 10000);
        HashSet<Long> curBatch = new HashSet<Long>(BATCH_SIZE);
        ExecuteStatus operStatus = ExecuteStatus.FINISH;
        HashSet<ExecuteStatus> operStatusSet = new HashSet<ExecuteStatus>(3);
        try (TraceSpan submitSpan = Tracer.create((String)VoucherBatchBuildExecService.class.getSimpleName(), (String)"submitData");){
            DataSet[] rowsColl;
            String[] groupbysNew = (String[])Stream.concat(Stream.of(orgFieldName), Arrays.stream(groupbys)).distinct().toArray(String[]::new);
            block11: for (DataSet rows : rowsColl = billData.splitByGroup(groupbysNew)) {
                if (IntellExecuteUtil.isStopExcute(this.schemeExecInfo)) break;
                while (rows.hasNext()) {
                    Row next = rows.next();
                    curBatch.add(next.getLong("id"));
                    if (curBatch.size() != BATCH_SIZE && rows.hasNext()) continue;
                    if (IntellExecuteUtil.isStopExcute(this.schemeExecInfo)) continue block11;
                    operStatus = this.process(curBatch, exceOperInfo, execStartDate, next.getLong(orgFieldName), size);
                    operStatusSet.add(operStatus);
                    curBatch.clear();
                }
            }
            if (operStatusSet.contains((Object)ExecuteStatus.STOP)) {
                operStatus = ExecuteStatus.STOP;
            } else if (operStatusSet.contains((Object)ExecuteStatus.FAIL)) {
                operStatus = ExecuteStatus.FAIL;
            }
            exceOperInfo.setExecuteStatus(operStatus);
        }
        catch (KDBizException e) {
            exceOperInfo.setExecuteStatus(ExecuteStatus.FAIL);
            LOG.error((Throwable)e);
        }
    }

    private ExecuteStatus process(Set<Long> curBatch, IntellExceOperInfo exceOperInfo, Date execStartDate, Long orgId, int size) {
        ExecuteStatus operStatus = ExecuteStatus.FINISH;
        if (curBatch.size() == 0) {
            return operStatus;
        }
        StringBuffer batchErrMsg = new StringBuffer();
        try (TraceSpan batchSpan = Tracer.create((String)VoucherBatchBuildExecService.class.getSimpleName(), (String)String.format("submitBatch_%s_%s", orgId, curBatch.size()));){
            operStatus = this.vchBatchExecute.startExecOperation(exceOperInfo.getSchemaId(), size, execStartDate, exceOperInfo, batchErrMsg, new ArrayList<Long>(curBatch));
            LOG.info(String.format("intell_schema_build_voucher curGroup bills: %s, batch: %s, org: %s, status: %s, msg: %s, cost: %s", new Object[]{size, curBatch.size(), orgId, operStatus, batchErrMsg.toString(), Tracer.getCurrentSpan().getCost()}));
        }
        if (ExecuteStatus.FAIL == operStatus) {
            LOG.info(String.format("intell_schema_build_voucher curGroup bills: %s, batch: %s, org: %s, status: %s, msg: %s", new Object[]{size, curBatch.size(), orgId, operStatus, batchErrMsg}));
        }
        return operStatus;
    }

    private void getIdByBill(String orgFieldName, List<BillVO> waitingBills) {
        HashSet<Long> billIds = new HashSet<Long>(16);
        DataSet rows = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.schemeExecInfo.getExceOperInfo().getBussiness(), (String)"id", (QFilter[])this.commonFilters.toArray(new QFilter[0]), null);
        while (rows.hasNext()) {
            Row next = rows.next();
            billIds.add(next.getLong("id"));
            if (billIds.size() != 2000 && rows.hasNext()) continue;
            if (IntellExecuteUtil.isStopExcute(this.schemeExecInfo)) break;
            waitingBills.addAll(this.getBillVO(billIds, orgFieldName));
            billIds.clear();
        }
    }

    private void getIdByTableDapw(String orgFieldName, List<BillVO> waitingBills) {
        String tableName;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.schemeExecInfo.getExceOperInfo().getBussiness());
        DBRoute dbRouteKey = DBRoute.of((String)dataEntityType.getDBRouteKey());
        boolean exitsTable = DB.exitsTable((DBRoute)dbRouteKey, (String)(tableName = dataEntityType.getAlias() + "_DAPW"));
        if (exitsTable) {
            if (this.hasDAPWMaxBillType(dbRouteKey, tableName)) {
                return;
            }
            String sqlQuery = "SELECT fsourcebillid FROM " + tableName + " ORDER BY fsourcebillid DESC";
            DB.query((DBRoute)dbRouteKey, (String)sqlQuery, rs -> {
                HashSet<Long> sourcebillIdlst = new HashSet<Long>(16);
                boolean hasNext = rs.next();
                while (waitingBills.size() < 100000) {
                    if (hasNext) {
                        sourcebillIdlst.add(rs.getLong("fsourcebillid"));
                        if (sourcebillIdlst.size() % 2000 == 0 || !(hasNext = rs.next())) {
                            if (IntellExecuteUtil.isStopExcute(this.schemeExecInfo)) break;
                            waitingBills.addAll(this.getBillVO(sourcebillIdlst, orgFieldName));
                            sourcebillIdlst.clear();
                        }
                    }
                    if (hasNext) continue;
                    break;
                }
                return null;
            });
        }
    }

    private void getIdByBusinessTask(String orgFieldName, List<BillVO> waitingBills) {
        if (this.hasMaxBillType()) {
            return;
        }
        try (DataSet successBusinessData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"iep_businesstask", (String)"entityid", (QFilter[])new QFilter("business", "=", (Object)this.schemeExecInfo.getExceOperInfo().getBussiness()).toArray(), (String)"entityid desc");){
            HashSet<Long> entityids = new HashSet<Long>(16);
            while (successBusinessData.hasNext()) {
                if (waitingBills.size() >= 100000) {
                    break;
                }
                entityids.add(successBusinessData.next().getLong("entityid"));
                if (entityids.size() % 2000 != 0 && successBusinessData.hasNext()) continue;
                if (IntellExecuteUtil.isStopExcute(this.schemeExecInfo)) {
                    break;
                }
                waitingBills.addAll(this.getBillVO(entityids, orgFieldName));
                entityids.clear();
            }
        }
    }

    private boolean hasMaxBillType() {
        IAppCache iep = AppCache.get((String)"iep");
        String key = String.format("businesstask-billtype-%s-count", this.schemeExecInfo.getExceOperInfo().getBussiness());
        Long count = (Long)iep.get(key, Long.class);
        if (Objects.isNull(iep.get(key, Long.class))) {
            count = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"iep_businesstask", (String)"entityid", (QFilter[])new QFilter("business", "=", (Object)this.schemeExecInfo.getExceOperInfo().getBussiness()).toArray(), null).count("entityid", true);
            iep.put(key, (Object)count);
        }
        LOG.info("hasMaxBillType_SIZE {}", (Object)count);
        return count > 1000000L;
    }

    private boolean hasDAPWMaxBillType(DBRoute route, String tableName) {
        IAppCache iep = AppCache.get((String)"iep");
        String key = String.format("businesstask-dapw-billtype-%s-count", tableName);
        Long count = (Long)iep.get(key, Long.class);
        if (Objects.isNull(iep.get(key, Long.class))) {
            String sql = "SELECT count(*) FROM " + tableName + "";
            count = (Long)DB.query((DBRoute)route, (String)sql, resultSet -> {
                resultSet.next();
                Long countN = resultSet.getLong(1);
                iep.put(key, (Object)countN);
                return countN;
            });
        }
        LOG.info("hasDAPWMaxBillType_SIZE {}", (Object)count);
        return count > 1000000L;
    }

    private List<BillVO> getBillVO(Set<Long> bullIds, String orgFieldName) {
        DataSet result;
        QFilter[] filters;
        IntellExceOperInfo exceOperInfo = this.schemeExecInfo.getExceOperInfo();
        if (ExecuteType.AUTO == exceOperInfo.getExecuteType()) {
            boolean isExist = AbstractExecute.removeFailBillId(bullIds, bullIds, exceOperInfo.getBussiness(), exceOperInfo);
            this.isExistFailBill.compareAndSet(false, isExist);
        }
        QFilter qfId = new QFilter("id", "in", bullIds);
        if (Objects.isNull(this.commonFilters)) {
            filters = qfId.toArray();
        } else {
            ArrayList<QFilter> filter = new ArrayList<QFilter>(this.commonFilters);
            filter.add(qfId);
            filters = filter.toArray(new QFilter[0]);
        }
        if (Objects.nonNull(orgFieldName)) {
            result = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)exceOperInfo.getBussiness(), (String)("id," + orgFieldName), (QFilter[])filters, null);
        } else {
            orgFieldName = "org";
            result = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)exceOperInfo.getBussiness(), (String)"id", (QFilter[])filters, null).addField("0L", orgFieldName);
        }
        ArrayList<BillVO> waitingBills = new ArrayList<BillVO>(16);
        while (result.hasNext()) {
            Row entry = result.next();
            waitingBills.add(new BillVO(entry.getLong("id"), entry.getLong(orgFieldName)));
        }
        LOG.info(String.format("intell_bill_size: %s", waitingBills.size()));
        result.close();
        return waitingBills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void process(List<BillVO> bills) {
        Date execStartDate = new Date();
        IntellExceOperInfo exceOperInfo = this.schemeExecInfo.getExceOperInfo();
        this.schemeExecInfo.appendRecordTC(bills.size());
        IntellSchemeExecInfo.execInfoWriteCache(this.schemeExecInfo);
        if (CollectionUtils.isEmpty(bills)) {
            LOG.info("intell_schema_build_voucher batch: 0, just tag, dont write log.");
            String bussinessName = FormDesignDao.getFormName(exceOperInfo.getBussiness());
            String msg = String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7b26\u5408\u8be5\u65b9\u6848\u3010%1$s%2$s\u3011\u64cd\u4f5c\u7684\u524d\u7f6e\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"VoucherBatchBuildExecService_1", (String)"bos-ext-fi", (Object[])new Object[0]), bussinessName, exceOperInfo.getOperName());
            exceOperInfo.setExecDetails(msg);
            return;
        }
        HashMap orgBillGroup = new HashMap();
        for (BillVO billVO : bills) {
            if (!orgBillGroup.containsKey(billVO.getOrgId())) {
                orgBillGroup.put(billVO.getOrgId(), new ArrayList(16));
            }
            ((List)orgBillGroup.get(billVO.getOrgId())).add(billVO.getBillId());
        }
        List sortedOrgBills = orgBillGroup.entrySet().stream().map(x -> new OrgBillGroup((Long)x.getKey(), (List)x.getValue())).collect(Collectors.toList());
        Collections.sort(sortedOrgBills);
        int BATCH_SIZE = Math.max(this.schemeExecInfo.getExceOperInfo().getEachbatchsize(), 10000);
        ArrayList<Long> curBatch = new ArrayList(BATCH_SIZE);
        StringBuffer errMsg = new StringBuffer();
        StringBuffer batchErrMsg = null;
        ExecuteStatus operStatus = ExecuteStatus.FINISH;
        HashSet<ExecuteStatus> operStatusSet = new HashSet<ExecuteStatus>(3);
        try (TraceSpan submitSpan = Tracer.create((String)VoucherBatchBuildExecService.class.getSimpleName(), (String)"submitData");){
            int grpIndex = 0;
            while (grpIndex < sortedOrgBills.size()) {
                block49: {
                    OrgBillGroup curGroup = (OrgBillGroup)sortedOrgBills.get(grpIndex);
                    if (curGroup.count() > BATCH_SIZE) {
                        int batchCount = (int)Math.ceil((double)curGroup.count() * 1.0 / (double)BATCH_SIZE);
                        int batchIndex = 0;
                    }
                    curBatch.addAll(curGroup.billIds);
                    batchErrMsg = new StringBuffer();
                    try {
                        try (TraceSpan batchSpan = Tracer.create((String)VoucherBatchBuildExecService.class.getSimpleName(), (String)String.format("submitBatch_%s_%s", curGroup.getOrgId(), curBatch.size()));){
                            operStatus = this.vchBatchExecute.startExecOperation(exceOperInfo.getSchemaId(), bills.size(), new Date(), exceOperInfo, errMsg, curBatch);
                            LOG.info(String.format("intell_schema_build_voucher bills: %s, batch: %s, org: %s, status: %s, msg: %s, cost: %s", new Object[]{bills.size(), curBatch.size(), curGroup.orgId, operStatus, batchErrMsg, Tracer.getCurrentSpan().getCost()}));
                        }
                        if (ExecuteStatus.FAIL != operStatus) break block49;
                    }
                    catch (Throwable throwable) {
                        if (ExecuteStatus.FAIL != operStatus) throw throwable;
                        LOG.info(String.format("intell_schema_build_voucher bills: %s, batch: %s, org: %s, status: %s, msg: %s", new Object[]{bills.size(), curBatch.size(), curGroup.orgId, operStatus, batchErrMsg}));
                        throw throwable;
                    }
                    LOG.info(String.format("intell_schema_build_voucher bills: %s, batch: %s, org: %s, status: %s, msg: %s", new Object[]{bills.size(), curBatch.size(), curGroup.orgId, operStatus, batchErrMsg}));
                }
                curBatch.clear();
                if (operStatusSet.contains((Object)ExecuteStatus.STOP)) {
                    operStatus = ExecuteStatus.STOP;
                } else if (operStatusSet.contains((Object)ExecuteStatus.FAIL)) {
                    operStatus = ExecuteStatus.FAIL;
                }
                exceOperInfo.setExecuteStatus(operStatus);
                ++grpIndex;
            }
            return;
        }
        catch (KDBizException e) {
            exceOperInfo.setExecuteStatus(ExecuteStatus.FAIL);
            LOG.error((Throwable)e);
        }
    }

    public String getEntityOrgFieldName() {
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)this.schemeExecInfo.getExceOperInfo().getBussiness());
        return bizEntityType.getMainOrg();
    }

    private String[] getGroupbys() {
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)this.schemeExecInfo.getExceOperInfo().getBussiness());
        Set fields = bizEntityType.getFields().keySet();
        String groupbys = this.schemeExecInfo.getExceOperInfo().getGroupbyscoll();
        return (String[])Arrays.stream(groupbys.split(",")).filter(fields::contains).distinct().toArray(String[]::new);
    }

    private boolean isEntityKingdeeISV() {
        String entityId = MetadataDao.getIdByNumber((String)this.schemeExecInfo.getExceOperInfo().getBussiness(), (MetaCategory)MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        return "kingdee".equalsIgnoreCase(formMetadata.getIsv());
    }

    private void writeErrorLog(String msg) {
        try (TXHandle handle = TX.requiresNew();){
            IntellAccountSchemaExecLogDaoNew.insertExceLog(this.schemeExecInfo.getExceOperInfo(), new Date(), null, "3", this.operSumLogId, 0, msg, null, this.vchBatchExecute.traceId);
            IntellAccountSchemaExecLogDao.updateOperSumLog(this.operSumLogId, "3", new Date(), msg, 0);
            IntellAccountSchemaExecLogDao.updateExecSumLog(this.sumLogId, "3", new Date());
        }
    }

    private static class OrgBillGroup
    implements Comparable<OrgBillGroup> {
        private Long orgId;
        private List<Long> billIds;

        public OrgBillGroup(Long orgId, List<Long> billIds) {
            this.orgId = orgId;
            this.billIds = billIds;
        }

        public int count() {
            if (CollectionUtils.isEmpty(this.billIds)) {
                return 0;
            }
            return this.billIds.size();
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public List<Long> getBillIds() {
            return this.billIds;
        }

        public void setBillIds(List<Long> billIds) {
            this.billIds = billIds;
        }

        @Override
        public int compareTo(OrgBillGroup another) {
            if (Objects.isNull(another)) {
                return 1;
            }
            return Integer.compare(another.count(), this.count());
        }
    }

    private static class BillVO {
        private Long billId;
        private Long orgId;

        public BillVO(Long billId, Long orgId) {
            this.billId = billId;
            this.orgId = orgId;
        }

        public Long getBillId() {
            return this.billId;
        }

        public void setBillId(Long billId) {
            this.billId = billId;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BillVO billVO = (BillVO)o;
            return Objects.equals(this.billId, billVO.billId);
        }

        public int hashCode() {
            return Objects.hash(this.billId);
        }
    }
}

