/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.assigncfg;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.ArrayUtils;

public class AssignCfgOpAction
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(AssignCfgOpAction.class);
    private static final String CLOUD_ID = "mpscmm";
    private static final String APP_ID = "msbd";
    private static final String SERVICE_NAME = "AssignCfgService";
    public static final String METHOD_NAME = "triggerByOperation";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Object[] bills = e.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])bills)) {
            return;
        }
        MainEntityType mainEntityType = (MainEntityType)bills[0].getDataEntityType();
        String entityNumber = mainEntityType.getName();
        String operationKey = e.getOperationKey();
        List ids = Stream.of(bills).map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
        try {
            log.info("\u5355\u636e\u6807\u8bc6:{},\u5355\u636eid:{},\u64cd\u4f5c\u7f16\u7801:{}", new Object[]{entityNumber, ids, operationKey});
            DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)METHOD_NAME, (Object[])new Object[]{entityNumber, bills, operationKey});
        }
        catch (KDException ex) {
            log.error("\u53d6\u503c\u914d\u7f6e\u5f02\u5e38KDException", (Object)ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            log.error("\u53d6\u503c\u914d\u7f6e\u5f02\u5e38Exception", (Object)ex.getMessage());
            throw ex;
        }
    }
}

