/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.bizrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.SCMCLang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;

public class DeleteSettleOpAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(DeleteSettleOpAction.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        if (datas == null || datas.length == 0) {
            return;
        }
        OperateOption option = this.getOption();
        boolean isIgnore = "true".equalsIgnoreCase(option.getVariableValue("ismoperate", "false"));
        if (isIgnore) {
            return;
        }
        String entityName = datas[0].getDataEntityType().getName();
        ArrayList<Long> ids = new ArrayList<Long>(datas.length);
        for (DynamicObject data : datas) {
            long billId = data.getLong("id");
            ids.add(billId);
        }
        Map result = null;
        boolean isException = false;
        String erroMessage = null;
        try (TXHandle tx = TX.requiresNew();){
            try {
                logger.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u53cd\u7ed3\u7b97\u670d\u52a1\u8c03\u7528\u5f00\u59cb\uff1a\u3010%s\u3011\u3010%s\u3011", entityName, ids));
                result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ism", (String)"SettleBillService", (String)"batchDeleteSettleBill", (Object[])new Object[]{ids, entityName});
                logger.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u53cd\u7ed3\u7b97\u670d\u52a1\u8c03\u7528\u7ed3\u675f\uff1a\u3010%s\u3011", result));
            }
            catch (Exception excep) {
                isException = true;
                erroMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)excep);
            }
        }
        if (isException) {
            throw new KDBizException(SCMCLang.ismCallFail(erroMessage));
        }
        Boolean isSuccess = (Boolean)result.get("isSuccess");
        if (!isSuccess.booleanValue()) {
            this.checkErroInfo((String)result.get("info"));
        }
    }

    private void checkErroInfo(String info) {
        boolean isSkip = true;
        StringBuilder erroStrs = new StringBuilder();
        try {
            Map detailInfos = (Map)SerializationUtils.fromJsonString((String)info, Map.class);
            for (Map.Entry detailInfo : detailInfos.entrySet()) {
                for (Map erroInfo : (List)detailInfo.getValue()) {
                    if ("ISMEC-000000".equals(erroInfo.get("code"))) continue;
                    isSkip = false;
                    erroStrs.append((String)erroInfo.get("message"));
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u53cd\u7ed3\u7b97\u670d\u52a1\u8c03\u7528\u7ed3\u675f\uff0c\u89e3\u6790\u7ed3\u679c\u5f02\u5e38\uff1a\u3010%s\u3011", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        if (!isSkip) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u53cd\u7ed3\u7b97\u5931\u8d25\uff1a\u201c%s\u201d", (String)"unSettleErro", (String)"bos-ext-scmc", (Object[])new Object[0]), erroStrs.toString()));
        }
    }
}

