/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.bizrule;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.scmc.validation.UpmOperateValidator;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class UpmOperateAction
extends AbstractOpBizRuleAction {
    private static final String SCENES_CODE = "upm_bill_operate";
    private static final String CLOUD_ID = "scmc";
    private static final String APP_ID = "upm";
    private static final String SERVICE_NAME = "UpmBillOperateService";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new UpmOperateValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.callUpmOperate(e.getDataEntities(), e.getOperationKey());
    }

    private void callUpmOperate(DynamicObject[] bills, String operationKey) {
        if (bills.length > 0) {
            ArrayList<Long> billIds = new ArrayList<Long>(bills.length);
            for (DynamicObject bill : bills) {
                billIds.add(bill.getLong("id"));
            }
            String formid = bills[0].getDataEntityType().getName();
            IDataEntityType entityType = bills[0].getDataEntityType();
            if ("scm".equals(entityType.getDBRouteKey())) {
                DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)"UpmMasterfileService", (String)"handleByBillOperate", (Object[])new Object[]{formid, operationKey, billIds});
            } else {
                CommonParam param = new CommonParam();
                param.put((Object)"formid", (Object)bills[0].getDataEntityType().getName());
                param.put((Object)"operate", (Object)operationKey);
                param.put((Object)"billIds", billIds);
                ECServiceHelper.execute((String)SCENES_CODE, null, (String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (Param)param);
            }
        }
    }
}

