/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.bizrule.asyncop.sn;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.ext.scmc.sn.helper.SerialNumberHelper;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.Propagation;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SNInOutWarehouseOpAction
extends AbstractOpBizRuleAction {
    Log logger = LogFactory.getLog((String)"kd.bos.ext.scmc.bizrule.asyncop.sn.SNInOutWarehouseOpAction");
    public static final String ENTITY_PURINBILL = "im_purinbill";
    public static final String ENTITY_SALEOUTBILL = "im_saloutbill";
    public static final String ENTITY_TRANSINBILL = "im_transinbill";
    public static final String ENTITY_TRANSOUTBILL = "im_transoutbill";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] invBills = e.getDataEntities();
        String operationKey = e.getOperationKey();
        this.callSnService(invBills, operationKey);
    }

    private void callSnService(DynamicObject[] bills, String operationKey) {
        if (bills == null || bills.length == 0) {
            return;
        }
        ArrayList<Long> hasSNBillIdList = new ArrayList<Long>(bills.length);
        String billType = bills[0].getDynamicObjectType().getName();
        Map<Long, List<DynamicObject>> billSerialConfigs = SerialNumberHelper.getBillSerialConfigs(bills);
        for (DynamicObject bill : bills) {
            Long billid = (Long)bill.getPkValue();
            List<DynamicObject> configs = billSerialConfigs.get(billid);
            if (!SerialNumberHelper.isInvBillEnableSerial(bill, configs, operationKey) || SerialNumberHelper.isVirtualBill(bill) || SerialNumberHelper.isInitBill(bill)) continue;
            hasSNBillIdList.add(billid);
        }
        if (hasSNBillIdList.isEmpty()) {
            return;
        }
        this.logger.debug("BillTplOp:\u6ce8\u518c\u5e8f\u5217\u53f7\u5904\u7406\u5206\u5e03\u5f0f\u4e8b\u52a1");
        ECGlobalSession.begin((String)"scm_bill_audit", (DBRoute)DBRoute.of((String)"scmc"), (Propagation)Propagation.REQUIRES_NEW);
        CommonParam param = new CommonParam();
        param.put((Object)"billtype", (Object)billType);
        param.put((Object)"operate", (Object)"audit");
        param.put((Object)"billIds", hasSNBillIdList);
        ECGlobalSession.register((String)"scmc", (String)"sbs", (String)"SerialNumberAuditECService", (Param)param, (String)"callSnService");
        ECGlobalSession.setBusinessType((String)"snService");
        ArrayList<String> businessInfoList = new ArrayList<String>(hasSNBillIdList.size());
        for (Long billId : hasSNBillIdList) {
            businessInfoList.add(billType + "#" + billId.toString());
        }
        ECGlobalSession.setBusinessInfo(businessInfoList);
        ECGlobalSession.setAsync((boolean)false);
    }
}

