/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.changemodel.helper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.validate.ConditionValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ChangeModelHelper {
    public static DynamicObject getChangeModel4XBill(String xBillEntiyId) {
        QFilter qf1 = new QFilter("xbill", "=", (Object)xBillEntiyId);
        QFilter qf2 = new QFilter("enable", "=", (Object)"1");
        QFilter qf3 = new QFilter("changetype", "=", (Object)"B");
        Map map = BusinessDataServiceHelper.loadFromCache((String)"plat_changemodel", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (map != null && map.size() > 0) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static DynamicObject getChangeModel(String entityId) {
        QFilter qf1 = new QFilter("srcbill", "=", (Object)entityId);
        QFilter qf2 = new QFilter("enable", "=", (Object)"1");
        Map map = BusinessDataServiceHelper.loadFromCache((String)"plat_changemodel", (QFilter[])new QFilter[]{qf1, qf2});
        if (map != null && map.size() > 0) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static DynamicObject getChangeModel4Revise(String entityId) {
        QFilter qf1 = new QFilter("srcbill", "=", (Object)entityId);
        QFilter qf2 = new QFilter("enable", "=", (Object)"1");
        QFilter qf3 = new QFilter("changetype", "=", (Object)"A");
        Map map = BusinessDataServiceHelper.loadFromCache((String)"plat_changemodel", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (map != null && map.size() > 0) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static boolean isBillCanRevise(String entityId, Long pkId) {
        if (entityId == null || pkId == null) {
            return false;
        }
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4Revise(entityId);
        if (changeModel == null) {
            return false;
        }
        String runcondition = changeModel.getString("areaconditionjson_tag");
        if (StringUtils.isNotBlank((CharSequence)runcondition)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)runcondition, FilterCondition.class);
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityId), condition);
            fb.buildFilter();
            QFilter qFilter = fb.getQFilter();
            if (qFilter != null) {
                QFilter pkQFilter = new QFilter("id", "=", (Object)pkId);
                pkQFilter.and(qFilter);
                return QueryServiceHelper.exists((String)entityId, (QFilter[])new QFilter[]{pkQFilter});
            }
        }
        return true;
    }

    public static Set<String> getCanReviseFields(String entityId) {
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4Revise(entityId);
        HashSet<String> fields = new HashSet<String>(8);
        if (changeModel == null) {
            return fields;
        }
        DynamicObjectCollection entrys = changeModel.getDynamicObjectCollection("revisefields");
        if (entrys != null) {
            for (DynamicObject entry : entrys) {
                String field = entry.getString("revisefield");
                Boolean canRevise = entry.getBoolean("canrevise");
                if (!StringUtils.isNotBlank((CharSequence)field) || !Boolean.TRUE.equals(canRevise)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static Set<String> getCanLogFields(String entityId) {
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4Revise(entityId);
        HashSet<String> fields = new HashSet<String>(8);
        if (changeModel == null) {
            return fields;
        }
        DynamicObjectCollection entrys = changeModel.getDynamicObjectCollection("revisefields");
        if (entrys != null) {
            for (DynamicObject entry : entrys) {
                String field = entry.getString("revisefield");
                Boolean canRevise = entry.getBoolean("canreviselog");
                if (!StringUtils.isNotBlank((CharSequence)field) || !Boolean.TRUE.equals(canRevise)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static List<AbstractValidator> getReviseValidations(String entityId, String opkey) {
        String validoptype;
        DynamicObject changemodel = ChangeModelHelper.getChangeModel4Revise(entityId);
        if (changemodel != null && StringUtils.isNotEmpty((CharSequence)(validoptype = changemodel.getString("validoptype"))) && validoptype.contains(opkey)) {
            DynamicObjectCollection validcol = changemodel.getDynamicObjectCollection("validentity");
            ArrayList<AbstractValidator> validators = new ArrayList<AbstractValidator>();
            for (DynamicObject valid : validcol) {
                ConditionValidation validation = ChangeModelHelper.convertStringToValidate(valid.getString("validconditionjson_tag"));
                if (validation == null || !validation.getEnabled()) continue;
                ConditionValidator validator = new ConditionValidator();
                validator.setValidation(validation.createValidate());
                validators.add((AbstractValidator)validator);
            }
            return validators;
        }
        return null;
    }

    public static boolean isNeedSaveValid(String entityId) {
        DynamicObject changemodel = ChangeModelHelper.getChangeModel4Revise(entityId);
        if (changemodel == null) {
            return false;
        }
        String validTime = changemodel.getString("updatetype");
        return "save".equals(validTime);
    }

    private static ConditionValidation convertStringToValidate(String validconditionjson) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)validconditionjson)) {
            ArrayList<IDataEntityType> dTypes = new ArrayList<IDataEntityType>();
            dTypes.add(DataEntityType.getDataEntityType(ConditionValidation.class));
            ListDcxmlBinder binder = new ListDcxmlBinder(false, dTypes);
            Map parameter = (Map)SerializationUtils.fromJsonString((String)validconditionjson, Map.class);
            DcJsonSerializer ds = new DcJsonSerializer((DcBinder)binder);
            ds.setIsLocaleValueFull(true);
            ConditionValidation validation = (ConditionValidation)ds.deserializeFromMap(parameter, null);
            if (validation.getDescription() == null && StringUtils.isNotBlank(parameter.get("Description")) && parameter.get("Description") instanceof String) {
                validation.setDescription(new LocaleString((String)parameter.get("Description")));
            }
            if (validation.getMessage() == null && StringUtils.isNotBlank(parameter.get("Message")) && parameter.get("Message") instanceof String) {
                validation.setMessage(new LocaleString((String)parameter.get("Message")));
            }
            return validation;
        }
        return null;
    }

    public static Map<String, String> getCusParaMapping(String entityId) {
        List customparameters;
        HashMap<String, String> fieldMapping = new HashMap<String, String>(8);
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4Revise(entityId);
        if (changeModel == null) {
            return fieldMapping;
        }
        String customparameter = changeModel.getString("customparameter_tag");
        if (StringUtils.isNotBlank((CharSequence)customparameter) && (customparameters = (List)SerializationUtils.fromJsonString((String)customparameter, List.class)).size() > 0) {
            customparameters.forEach(m -> fieldMapping.put((String)m.get("name"), (String)m.get("val")));
        }
        fieldMapping.putIfAbsent("changestatus", "changestatus");
        fieldMapping.putIfAbsent("version", "version");
        fieldMapping.putIfAbsent("changer", "changer");
        fieldMapping.putIfAbsent("changedate", "changedate");
        return fieldMapping;
    }

    public static Set<String> getPreparePropertys(Map<String, String> cusParam, MainEntityType entityType) {
        Set<String> canLogFields;
        HashSet<String> propertys = new HashSet<String>(8);
        propertys.add(cusParam.get("changestatus"));
        propertys.add(cusParam.get("changer"));
        propertys.add(cusParam.get("changedate"));
        propertys.add(cusParam.get("version"));
        String billNo = ((BillEntityType)entityType).getBillNo();
        propertys.add(billNo);
        Set<String> canReviseFields = ChangeModelHelper.getCanReviseFields(entityType.getName());
        if (canReviseFields != null) {
            propertys.addAll(canReviseFields);
        }
        if ((canLogFields = ChangeModelHelper.getCanLogFields(entityType.getName())) != null) {
            propertys.addAll(canLogFields);
        }
        propertys.remove(null);
        return propertys;
    }

    public static Map<String, Map<String, String>> getXBillEntryAndOp(DynamicObject changeModel) {
        Map<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (changeModel == null) {
            return result;
        }
        String[] plugins = ChangeModelHelper.getChangeService(changeModel);
        if (plugins == null || plugins.length == 0) {
            result = ChangeModelHelper.getXBillEntryAndOpFromCustpama(changeModel);
            if (result == null || result.size() == 0) {
                result = new HashMap();
                HashMap<String, String> value = new HashMap<String, String>();
                value.put("entity", "billentry");
                value.put("entry_toolbar", "tbmainentry");
                value.put("btn_add", "addrow");
                value.put("btn_delete", "deleterow");
                value.put("btn_modify", "modifyrow");
                value.put("changetype", "billentrychangetype");
                value.put("srcid", "billentrysrcid");
                result.put((String)value.get("entity"), (Map<String, String>)value);
            }
            return result;
        }
        for (String plugin : plugins) {
            try {
                Class<?> c = Class.forName(plugin);
                Method m = c.getMethod("getXBillEntryAndOp", new Class[0]);
                Object r = m.invoke(c.newInstance(), new Object[0]);
                if (!(r instanceof Map)) continue;
                result.putAll((Map)r);
            }
            catch (Exception e) {
                String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u6a21\u578b\u201c\u63d2\u4ef6\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChangeModelHelper_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
                throw new KDBizException(errMsg);
            }
        }
        return result;
    }

    public static Map<String, Map<String, String>> getXBillEntryAndOpFromCustpama(DynamicObject changeModel) {
        String customparameter = changeModel.getString("customparameter_tag");
        if (customparameter == null || customparameter.isEmpty()) {
            return null;
        }
        String xbilldtstr = "";
        if (changeModel.getDynamicObject("xbill") != null && changeModel.getDynamicObject("xbill").getPkValue() != null) {
            xbilldtstr = (String)changeModel.getDynamicObject("xbill").getPkValue();
        }
        MainEntityType xBillDt = MetadataServiceHelper.getDataEntityType((String)xbilldtstr);
        List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities((IDataEntityType)xBillDt);
        List customparameters = new ArrayList(16);
        try {
            customparameters = (List)SerializationUtils.fromJsonString((String)customparameter, customparameters.getClass());
            HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
            for (Map map : customparameters) {
                for (EntityType xBillentryEntity : xBillentryEntitys) {
                    if (!xBillentryEntity.getName().equalsIgnoreCase((String)map.get("name"))) continue;
                    try {
                        Map propertymapping = (Map)SerializationUtils.fromJsonString((String)((String)map.get("val")), Map.class);
                        result.put((String)map.get("name"), propertymapping);
                    }
                    catch (Exception ee) {
                        String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u6a21\u578b\u201c\u81ea\u5b9a\u4e49\u53c2\u6570\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChangeModelHelper_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
                        throw new KDBizException(errMsg);
                    }
                }
            }
            return result;
        }
        catch (Exception ee) {
            String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u6a21\u578b\u201c\u81ea\u5b9a\u4e49\u53c2\u6570\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChangeModelHelper_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
    }

    public static List<EntityType> getChildEntities(IDataEntityType entityType) {
        ArrayList<EntityType> childEntities = new ArrayList<EntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            childEntities.add(childEntity);
            childEntities.addAll(ChangeModelHelper.getChildEntities((IDataEntityType)childEntity));
        }
        return childEntities;
    }

    public static String[] getChangeService(DynamicObject changeModel) {
        if (changeModel == null) {
            return null;
        }
        DynamicObjectCollection plugins = changeModel.getDynamicObjectCollection("pluginentity");
        if (plugins == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (DynamicObject plugin : plugins) {
            Boolean pluginenable = plugin.getBoolean("pluginenable");
            String classname = plugin.getString("classname");
            if (!pluginenable.booleanValue() || !StringUtils.isNotBlank((CharSequence)classname)) continue;
            res.add(classname);
        }
        if (res.size() != 0) {
            return res.toArray(new String[res.size()]);
        }
        return null;
    }

    public static DynamicObject invokeReviseLogServise(DynamicObject originalBill, DynamicObject reviseBill, String opType) {
        return (DynamicObject)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"BillChangeService", (String)"recReviseLog", (Object[])new Object[]{originalBill, reviseBill, opType});
    }
}

