/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.changemodel.operation;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.changemodel.helper.ChangeModelHelper;
import kd.bos.ext.scmc.changemodel.validator.ReviseUnSubmitValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ReviseUnSubmitOpServise
extends EntityOperateService {
    private static final Log log = LogFactory.getLog(ReviseUnSubmitOpServise.class);

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        Map<String, String> fieldMapping = ChangeModelHelper.getCusParaMapping(this.billEntityType.getName());
        if (fieldMapping != null && fieldMapping.size() > 0) {
            fieldMapping.forEach((k, v) -> this.getOption().setVariableValue(k, v));
            fieldKeys.addAll(ChangeModelHelper.getPreparePropertys(fieldMapping, this.getBillEntityType()));
        }
    }

    protected void addDefaultValidator(List<AbstractValidator> e) {
        super.addDefaultValidator(e);
        e.add(new ReviseUnSubmitValidator());
    }

    protected void executeOperate(DynamicObject[] dynamicObjects) {
        try {
            if (dynamicObjects != null) {
                Map variables = this.getOption().getVariables();
                String changeStatusId = "";
                if (variables.containsKey("changestatus")) {
                    changeStatusId = this.getOption().getVariableValue("changestatus");
                }
                for (DynamicObject bill : dynamicObjects) {
                    DynamicObjectType dynamicObjectType = bill.getDynamicObjectType();
                    DynamicProperty prop = dynamicObjectType.getProperty(changeStatusId);
                    if (prop != null) {
                        bill.set(changeStatusId, (Object)"B1");
                    }
                    ChangeModelHelper.invokeReviseLogServise(bill, bill, "unsubmit");
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u201c\u66f4\u6b63\u64a4\u9500\u201d\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"ReviseUnSubmitOpServise_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }
}

