/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.chargeagainst.valid.ChargeAgainstValid;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ChargeAgainstOp
extends DefaultEntityOperate
implements ICloseCallBack {
    private static final Log logger = LogFactory.getLog(ChargeAgainstOp.class);
    private final String CHARGE_AGAINST_CALLBACK = "chargeagainstCallback";
    private static final String CA_DATE = "cadate";
    private static final String CA_REASON = "careason";

    protected boolean beforeInvokeOperation(OperationResult result) {
        logger.info("ChargeAgainstOp:beforeInvokeOperation");
        boolean superResult = super.beforeInvokeOperation(result);
        if (!superResult) {
            return false;
        }
        DynamicObject bill = this.getBillOb();
        ChargeAgainstValid valid = new ChargeAgainstValid(this.getOption());
        valid.billValidate(bill);
        String param = this.getOption().getVariableValue("caConfirm", "");
        if ("success".equals(param)) {
            return true;
        }
        this.opCaPage(bill);
        return false;
    }

    public OperationResult invokeOperation() {
        logger.info("ChargeAgainstOp:invokeOperation");
        return super.invokeOperation();
    }

    private void opCaPage(DynamicObject bill) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("im_changeagainst");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("caBillPk", bill.getPkValue());
        parameter.setCustomParam("caBillType", (Object)bill.getDataEntityType().getName());
        parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "chargeagainstCallback"));
        this.getView().showForm(parameter);
    }

    private DynamicObject getBillOb() {
        IFormView view = this.getView();
        DynamicObject bill = null;
        if (view instanceof IBillView) {
            Object pk = view.getModel().getDataEntity().getPkValue();
            bill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)this.getEntityId());
        } else if (view instanceof IListView) {
            ListSelectedRowCollection listSelectedData = this.getListSelectedData();
            Object[] pks = listSelectedData.getPrimaryKeyValues();
            if (pks.length != 1) {
                String message = ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u51b2\u9500\u3002", (String)"ChargeAgainstOp_0", (String)"bos-ext-scmc", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            Object pk = listSelectedData.get(0).getPrimaryKeyValue();
            bill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)this.getEntityId());
        } else {
            String message = ResManager.loadKDString((String)"\u975e\u5355\u636e\u7f16\u8f91\u754c\u9762\u6216\u8005\u5217\u8868\u89e6\u53d1\u7684\u51b2\u9500\u64cd\u4f5c\u3002", (String)"ChargeAgainstOp_8", (String)"bos-ext-scmc", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        return bill;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        logger.info("ChargeAgainstOp:ClosedCallBackEvent");
        String actionId = e.getActionId();
        Object object = e.getReturnData();
        if (object != null && "chargeagainstCallback".equals(actionId)) {
            JSONObject returnData = (JSONObject)object;
            String reason = returnData.getString(CA_REASON);
            Date date = returnData.getDate(CA_DATE);
            Date bookData = returnData.getDate("bookDate");
            if (date == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u51b2\u9500\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChargeAgainstOp_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
            if (bookData == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChargeAgainstOp_9", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
            Object billPk = returnData.get((Object)"caBillPk");
            String billType = returnData.getString("caBillType");
            OperateOption nextOption = OperateOption.create();
            nextOption.setVariableValue("caConfirm", "success");
            nextOption.setVariableValue(CA_REASON, reason);
            nextOption.setVariableValue(CA_DATE, String.valueOf(date.getTime()));
            nextOption.setVariableValue("bookDate", String.valueOf(bookData.getTime()));
            nextOption.setVariableValue("caBillPk", String.valueOf(billPk));
            nextOption.setVariableValue("caBillType", billType);
            nextOption.setVariableValue("strictvalidation", String.valueOf(true));
            nextOption.setVariableValue("ignoreValidation", String.valueOf(false));
            e.getView().invokeOperation("chargeAgainst", nextOption);
        }
    }
}

