/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.SCMCLang;
import kd.bos.ext.scmc.chargeagainst.consts.BillOpEnum;
import kd.bos.ext.scmc.chargeagainst.handle.BillOpHandle;
import kd.bos.ext.scmc.chargeagainst.handle.RedBlueBillHandle;
import kd.bos.ext.scmc.chargeagainst.handle.RemoteServiceHandle;
import kd.bos.ext.scmc.chargeagainst.service.CaLogService;
import kd.bos.ext.scmc.chargeagainst.util.CommonUtil;
import kd.bos.ext.scmc.chargeagainst.vo.CaPageVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;

public class RollbackHandle {
    private static final Log logger = LogFactory.getLog(RollbackHandle.class);
    private CaPageVo caPageVo;
    private CaLogService caLogService;
    private RemoteServiceHandle remoteServiceHandle;
    private RedBlueBillHandle redBlueBillHandle;
    private BillOpHandle billOpHandle;

    public static RollbackHandle build(RemoteServiceHandle remoteServiceHandle, RedBlueBillHandle redBlueBillHandle, BillOpHandle billOpHandle, CaLogService caLogService, CaPageVo caPageVo) {
        RollbackHandle handle = new RollbackHandle();
        handle.setCaLogService(caLogService);
        handle.setCaPageVo(caPageVo);
        handle.setRemoteServiceHandle(remoteServiceHandle);
        handle.setRedBlueBillHandle(redBlueBillHandle);
        handle.setBillOpHandle(billOpHandle);
        return handle;
    }

    public void rollbackData() {
        try {
            this.updateCaBilledStatus(Boolean.FALSE);
            OperateOption option = CommonUtil.getCaOption();
            this.doBillRollbackOp(option, this.redBlueBillHandle.getAllCaBill());
            this.remoteServiceHandle.rollBackInterface();
            this.caLogService.getCaLogVo().setCastatus("3");
        }
        catch (Exception e) {
            logger.error("\u51b2\u9500\u56de\u6eda\u5931\u8d25", (Throwable)e);
            this.caLogService.getCaLogVo().setCastatus("2");
            this.caLogService.getCaLogVo().setCaBillFailcause(SCMCLang.chargeOffRollBackFail(e.getMessage()));
            throw e;
        }
    }

    private void doBillRollbackOp(OperateOption option, Map<String, List<DynamicObject>> allCabilleds) {
        for (Map.Entry<String, List<DynamicObject>> bills : allCabilleds.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)bills.getValue())) continue;
            Set pks = bills.getValue().stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            String billType = bills.getKey();
            QFilter qFilter = new QFilter("id", "in", pks);
            DynamicObjectCollection queryList = QueryServiceHelper.query((String)billType, (String)"id,billstatus", (QFilter[])qFilter.toArray());
            ArrayList<Object> auditBills = new ArrayList<Object>(8);
            ArrayList<Object> submitBills = new ArrayList<Object>(8);
            ArrayList<Object> saveBills = new ArrayList<Object>(8);
            for (DynamicObject ob : queryList) {
                String status = ob.getString("billstatus");
                Object id = ob.get("id");
                if ("C".equals(status)) {
                    auditBills.add(id);
                    saveBills.add(id);
                    continue;
                }
                if ("B".equals(status)) {
                    submitBills.add(id);
                    saveBills.add(id);
                    continue;
                }
                if (!"A".equals(status)) continue;
                saveBills.add(id);
            }
            this.executeOp(billType, auditBills, option, BillOpEnum.UNAUDIT);
            this.executeOp(billType, submitBills, option, BillOpEnum.UNSUBMIT);
            this.executeOp(billType, saveBills, option, BillOpEnum.DELETE);
        }
    }

    private OperationResult executeOp(String billType, List<Object> generatBillList, OperateOption option, BillOpEnum op) {
        if (CollectionUtils.isEmpty(generatBillList)) {
            return null;
        }
        Object[] generaBills = generatBillList.toArray(new Object[generatBillList.size()]);
        OperationResult result = OperationServiceHelper.executeOperate((String)op.getOpKey(), (String)billType, (Object[])generaBills, (OperateOption)option);
        List successPkIds = result.getSuccessPkIds();
        this.caLogService.getCaLogVo().setGenerateBillEntry(billType, successPkIds, op);
        if (!result.isSuccess()) {
            String errDetail = CommonUtil.getErrDetail(result);
            logger.error(op.getOpName() + "\u51b2\u9500\u5355\u636e" + billType + "\u5931\u8d25\uff1a" + errDetail);
            throw new KDBizException(SCMCLang.calBillFail(op.getOpName(), errDetail));
        }
        logger.info(op.getOpName() + "\u51b2\u9500\u5355\u636e\u6210\u529f");
        return result;
    }

    private void updateCaBilledStatus(Boolean status) {
        Map<String, List<DynamicObject>> allCabilleds = this.redBlueBillHandle.getAllCaBilled();
        for (Map.Entry<String, List<DynamicObject>> cabilled : allCabilleds.entrySet()) {
            this.batchUpdate(status, cabilled);
        }
    }

    private String getErrorMessage(Exception e) {
        String errorMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        return errorMessage;
    }

    private void batchUpdate(Boolean status, Map.Entry<String, List<DynamicObject>> cabilled) {
        String billType = cabilled.getKey();
        List<DynamicObject> caBillList = cabilled.getValue();
        String isChargeOffed = this.caPageVo.getModelField().getCaModelField(billType).getIsChargeOffed();
        for (DynamicObject ob : caBillList) {
            ob.set(isChargeOffed, (Object)status);
        }
        SaveServiceHelper.update((DynamicObject[])caBillList.toArray(new DynamicObject[caBillList.size()]));
    }

    public RedBlueBillHandle getRedBlueBillHandle() {
        return this.redBlueBillHandle;
    }

    public void setRedBlueBillHandle(RedBlueBillHandle redBlueBillHandle) {
        this.redBlueBillHandle = redBlueBillHandle;
    }

    public CaPageVo getCaPageVo() {
        return this.caPageVo;
    }

    public void setCaPageVo(CaPageVo caPageVo) {
        this.caPageVo = caPageVo;
    }

    public CaLogService getCaLogService() {
        return this.caLogService;
    }

    public void setCaLogService(CaLogService caLogService) {
        this.caLogService = caLogService;
    }

    public RemoteServiceHandle getRemoteServiceHandle() {
        return this.remoteServiceHandle;
    }

    public void setRemoteServiceHandle(RemoteServiceHandle remoteServiceHandle) {
        this.remoteServiceHandle = remoteServiceHandle;
    }

    public BillOpHandle getBillOpHandle() {
        return this.billOpHandle;
    }

    public void setBillOpHandle(BillOpHandle billOpHandle) {
        this.billOpHandle = billOpHandle;
    }
}

