/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.util;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.SCMCLang;
import kd.bos.ext.scmc.chargeagainst.consts.BillOpEnum;
import kd.bos.ext.scmc.chargeagainst.service.CaLogService;
import kd.bos.ext.scmc.chargeagainst.util.PropertyDataType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.lang3.StringUtils;

public class CommonUtil {
    private static final Log logger = LogFactory.getLog(CommonUtil.class);

    public static List<String> getAmoutAndQtyFieldList(DynamicObject billOb, String entry) {
        ArrayList<String> listFields = new ArrayList<String>(12);
        Map allFields = ((BillEntityType)billOb.getDataEntityType()).getAllFields();
        for (IDataEntityProperty pro : allFields.values()) {
            String field;
            String proDataType = CommonUtil.getProDataType(pro);
            if (!PropertyDataType.AMOUNT.getDataType().equals(proDataType) && !PropertyDataType.QTY.getDataType().equals(proDataType) || (field = CommonUtil.getField(pro, entry)) == null) continue;
            listFields.add(field);
        }
        return listFields;
    }

    private static String getField(IDataEntityProperty po, String entry) {
        IDataEntityType parent;
        String entryName;
        String name = po.getName();
        if ((entry = entry + ".").equals(entryName = CommonUtil.getEntryName(parent = po.getParent(), ""))) {
            return name;
        }
        return null;
    }

    private static String getField(IDataEntityProperty po) {
        String name = po.getName();
        IDataEntityType parent = po.getParent();
        String entryName = CommonUtil.getEntryName(parent, "");
        return entryName + name;
    }

    private static String getEntryName(IDataEntityType entry, String entryName) {
        IDataEntityType parent;
        String name = entry.getName();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            entryName = name + "." + entryName;
        }
        if ((parent = entry.getParent()) != null) {
            CommonUtil.getEntryName(parent, entryName);
        }
        return entryName;
    }

    public static String getProDataType(IDataEntityProperty property) {
        if (property instanceof BooleanProp) {
            return "boolean";
        }
        if (property instanceof LargeTextProp) {
            return ((LargeTextProp)property).getClientType();
        }
        if (property instanceof TextProp) {
            return "simpleText";
        }
        if (property instanceof PriceProp) {
            return "price";
        }
        if (property instanceof AmountProp) {
            return "amount";
        }
        if (property instanceof BigIntProp) {
            return "long";
        }
        if (property instanceof IntegerProp) {
            return "int";
        }
        if (property instanceof QtyProp) {
            return "qty";
        }
        if (property instanceof DecimalProp) {
            return "othernumber";
        }
        if (property instanceof DateProp) {
            return ((DateProp)property).getFilterControlType();
        }
        if (property instanceof MaterielProp) {
            return "material";
        }
        if (property instanceof OrgProp) {
            return ((OrgProp)property).getFilterControlType();
        }
        if (property instanceof UserProp) {
            return ((UserProp)property).getFilterControlType();
        }
        if (property instanceof ItemClassProp) {
            return "multibasedata";
        }
        if (property instanceof ComboProp) {
            return ((ComboProp)property).getFilterControlType();
        }
        if (property instanceof FlexProp) {
            return "flex";
        }
        if (property instanceof BasedataProp) {
            return "otherbasedata";
        }
        return "unknown";
    }

    public static void executeOp(Object[] ids, String billTypeName, OperateOption option, BillOpEnum op) {
        OperationResult result = OperationServiceHelper.executeOperate((String)op.getOpKey(), (String)billTypeName, (Object[])ids, (OperateOption)option);
        if (!result.isSuccess()) {
            logger.error(op.getOpName() + "\u51b2\u9500\u5355\u636e" + billTypeName + "\u5931\u8d25\uff1a" + CommonUtil.getErrDetail(result));
            throw new KDBizException(SCMCLang.calBillFail(op.getOpName(), CommonUtil.getErrDetail(result)));
        }
    }

    @SdkDeprecated
    public static OperateOption getCaOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("ignoreValidation", String.valueOf(false));
        option.setVariableValue("isIgnoreVirualBillValidate", String.valueOf(true));
        option.setVariableValue("isSysCall", "true");
        return option;
    }

    public static String getBillNo(DynamicObject dataEntity) {
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        String billNoKey = ((BillEntityType)dataEntityType).getBillNo();
        String billNo = dataEntity.getString(billNoKey);
        return billNo;
    }

    public static String getBillNo(DynamicObject[] dataEntitys) {
        StringBuilder build = new StringBuilder();
        for (DynamicObject dataEntity : dataEntitys) {
            IDataEntityType dataEntityType = dataEntity.getDataEntityType();
            String billNoKey = ((BillEntityType)dataEntityType).getBillNo();
            String billNo = dataEntity.getString(billNoKey);
            build.append(billNo);
            build.append(",");
        }
        String result = build.toString();
        result = result.substring(0, result.length() - 1);
        return build.toString();
    }

    public static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage());
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    public static void setErrorLog(String billType, OperationResult result, String errDetail, CaLogService caLogService) {
        HashSet<Object> successPkIds = new HashSet<Object>(result.getSuccessPkIds());
        caLogService.getCaLogVo().setGenerateBillEntry(billType, successPkIds, errDetail);
    }

    public static Map<String, Object> buildSrmSyncData(String billNumber, Object pkValue, String type) {
        HashMap<String, Object> retrunData = new HashMap<String, Object>(16);
        retrunData.put("type", type);
        HashMap dataMap = new HashMap(16);
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)billNumber, (Long[])new Long[]{(Long)pkValue});
        if (CollectionUtils.isEmpty((Map)dirtTargetBills)) {
            return null;
        }
        List bfRows = (List)dirtTargetBills.get(pkValue);
        HashSet<Object> hashSet = new HashSet<Object>(16);
        hashSet.add(pkValue);
        if (bfRows != null) {
            Iterator iterator = bfRows.iterator();
            while (iterator.hasNext()) {
                ConvertDataService reader = new ConvertDataService();
                BFRow row = (BFRow)iterator.next();
                BFRowId tid = row.getId();
                Long mainTableId = tid.getMainTableId();
                TableDefine tableDefine = reader.loadTableDefine(mainTableId);
                String entityNumber = tableDefine.getEntityNumber();
                if ("pur_instock".equals(entityNumber)) {
                    dataMap.put("pur_instock", hashSet);
                    continue;
                }
                if ("pur_return".equals(entityNumber)) {
                    dataMap.put("pur_return", hashSet);
                    continue;
                }
                if ("pur_receipt".equals(entityNumber)) {
                    dataMap.put("pur_receipt", hashSet);
                    continue;
                }
                if ("pur_receipt_return".equals(entityNumber)) {
                    dataMap.put("pur_receipt_return", hashSet);
                    continue;
                }
                if (!"pur_moduledelivery".equals(entityNumber)) continue;
                dataMap.put("pur_moduledelivery", hashSet);
            }
        }
        if (dataMap.isEmpty()) {
            return null;
        }
        retrunData.put("dataMap", dataMap);
        return retrunData;
    }

    public static String getDateString(Date date) {
        String result = "";
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            result = dateFormat.format(date);
        }
        return result;
    }

    public static void rollbackWfRecord(List<Map<String, Object>> list, String appId, String method) {
        logger.info(String.format("\u5f00\u59cb\u8c03\u7528\u63a5\u53e3%s\uff0c\u5e94\u7528%s,\u53c2\u6570\u4e3a%s", method, appId, JSONObject.toJSONString(list)));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (Map<String, Object> params : list) {
            CommonUtil.doRollBackService(appId, method, params);
        }
    }

    public static void removeAllReserveByBillRollBack(String billType, Long billId) {
        logger.info("\u56de\u6eda\u9884\u7559\u8bb0\u5f55,\u5355\u636e:{},ID:{}", (Object)billType, (Object)billId);
        OperationResult operationResult = (OperationResult)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"removeAllReserveByBillRollBack", (Object[])new Object[]{billType, Collections.singleton(billId)});
        if (!operationResult.isSuccess()) {
            logger.info("\u56de\u6eda\u91ca\u653e\u9884\u7559\u5931\u8d25\uff1a{}", (Object)operationResult.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u56de\u6eda\u91ca\u653e\u9884\u7559\u5931\u8d25\u3002", (String)"BOSEXT-E-550823", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        logger.info("\u56de\u6eda\u91ca\u653e\u9884\u7559\u6210\u529f");
    }

    private static void doRollBackService(String appId, String method, Map<String, Object> params) {
        if ("ap".equals(appId) && "redVerifyRecordRollBack".equals(method)) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ApWrittenOffVerifyService", (String)"redVerifyRecordRollBack", (Object[])new Object[]{params});
        } else if ("ap".equals(appId) && "writtenOffVerifyRollBack".equals(method)) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ApWrittenOffVerifyService", (String)"writtenOffVerifyRollBack", (Object[])new Object[]{params});
        } else if ("ar".equals(appId) && "redVerifyRecordRollBack".equals(method)) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"ArWrittenOffVerifyService", (String)"redVerifyRecordRollBack", (Object[])new Object[]{params});
        } else if ("ar".equals(appId) && "writtenOffVerifyRollBack".equals(method)) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"ArWrittenOffVerifyService", (String)"writtenOffVerifyRollBack", (Object[])new Object[]{params});
        }
    }

    private static Map<String, Object> buildParams(List<Map<String, Object>> list, String method) {
        Map<Object, Object> requestParams = new HashMap(16);
        if ("redVerifyRecordRollBack".equals(method)) {
            requestParams = CommonUtil.buildRedVerifyRollbackParams(list);
        } else if ("writtenOffVerifyRollBack".equals(method)) {
            requestParams = CommonUtil.buildWfVerifyRollbackParams(list);
        }
        return requestParams;
    }

    private static Map<String, Object> buildWfVerifyRollbackParams(List<Map<String, Object>> list) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        ArrayList srcIds = new ArrayList(16);
        ArrayList billIds = new ArrayList(16);
        for (Map<String, Object> map : list) {
            srcIds.addAll((List)map.get("writtenOffSrcIds"));
            billIds.addAll((List)map.get("writtenOffBillIds"));
        }
        params.put("writtenOffSrcIds", srcIds);
        params.put("writtenOffBillIds", billIds);
        return params;
    }

    private static Map<String, Object> buildRedVerifyRollbackParams(List<Map<String, Object>> list) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        ArrayList updateIds = new ArrayList(16);
        ArrayList redIds = new ArrayList(16);
        for (Map<String, Object> map : list) {
            updateIds.addAll((List)map.get("updatedVerifyRecordIds"));
            redIds.addAll((List)map.get("redVerifyRecordIds"));
        }
        params.put("updatedVerifyRecordIds", updateIds);
        params.put("redVerifyRecordIds", redIds);
        return params;
    }

    public static boolean isExistField(String billType, String field) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        IDataEntityProperty property = dataEntityType.findProperty(field);
        return property != null;
    }

    public static boolean isExistField(DynamicObject bill, String field) {
        DynamicProperty property = bill.getDynamicObjectType().getProperty(field);
        return property != null;
    }
}

