/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.SCMCLang;
import kd.bos.ext.scmc.chargeagainst.util.CaModelField;
import kd.bos.ext.scmc.chargeagainst.util.CaModelFieldCaChe;
import kd.bos.ext.scmc.chargeagainst.util.CommonUtil;
import kd.bos.ext.scmc.chargeagainst.vo.BFRowBillResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class WfRecordHelper {
    public static Set<String> checkWfRecordBills(DynamicObject dataEntity, CaModelFieldCaChe modelField) {
        HashSet<String> wfRecordBills = new HashSet<String>(8);
        String srcEntryName = dataEntity.getDataEntityType().getName();
        if ("im_saloutbill".equals(srcEntryName)) {
            Set<String> arRecords = WfRecordHelper.getWfRecordSet(dataEntity, srcEntryName, "ar_verifyrecord", modelField);
            wfRecordBills.addAll(arRecords);
            for (String record : arRecords) {
                String[] split = record.split("@");
                String billType = split[0];
                if (!"ar_revcfmbill".equals(billType)) continue;
                WfRecordHelper.arRevcfmWfRecordDeal(wfRecordBills, split[1], billType);
            }
            if (CollectionUtils.isEmpty(wfRecordBills)) {
                arRecords = WfRecordHelper.getSalOutWfRecordSet(dataEntity, srcEntryName, "ar_saloutwfrecord", modelField);
                wfRecordBills.addAll(arRecords);
            }
        } else if ("im_purinbill".equals(srcEntryName) || "im_purreceivebill".equals(srcEntryName)) {
            Set<String> arRecords = WfRecordHelper.getWfRecordSet(dataEntity, srcEntryName, "ap_verifyrecord", modelField);
            wfRecordBills.addAll(arRecords);
        }
        return wfRecordBills;
    }

    private static Set<String> getSalOutWfRecordSet(DynamicObject dataEntity, String billType, String WfRecordTable, CaModelFieldCaChe modelField) {
        String name = dataEntity.getDataEntityType().getDisplayName().getLocaleValue();
        String billNo = CommonUtil.getBillNo(dataEntity);
        HashSet<String> wfRecordBills = new HashSet<String>(8);
        QFilter qFilter = new QFilter("entry.billid", "=", dataEntity.getPkValue());
        qFilter.and("entry.billtype", "=", (Object)billType);
        DynamicObjectCollection wfRecordList = QueryServiceHelper.query((String)WfRecordTable, (String)"entry.billid as billid,entry.billtype as billtype,entry.assbillid as entry.e_billid,entry.assbilltype as entry.e_billtype,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])qFilter.toArray());
        WfRecordHelper.getWfRecord(wfRecordBills, wfRecordList, name, billNo);
        QFilter qFilterNew = new QFilter("entry.assbillid", "=", dataEntity.getPkValue());
        qFilterNew.and("entry.assbilltype", "=", (Object)billType);
        DynamicObjectCollection wfRecordTwoList = QueryServiceHelper.query((String)WfRecordTable, (String)"entry.billid as billid,entry.billtype as billtype,entry.assbillid as entry.e_billid,entry.assbilltype as entry.e_billtype,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])qFilterNew.toArray());
        WfRecordHelper.getWfRecord(wfRecordBills, wfRecordTwoList, name, billNo);
        return wfRecordBills;
    }

    private static Set<String> getWfRecordSet(DynamicObject dataEntity, String billType, String WfRecordTable, CaModelFieldCaChe modelField) {
        CaModelField caModelField = modelField.getCaModelField(billType);
        ArrayList<Long> settleorgs = new ArrayList<Long>(12);
        String name = dataEntity.getDataEntityType().getDisplayName().getLocaleValue();
        String billNo = CommonUtil.getBillNo(dataEntity);
        DynamicObjectCollection billentry = dataEntity.getDynamicObjectCollection(caModelField.getBillEntry());
        for (DynamicObject entry : billentry) {
            DynamicObject settleOrg = entry.getDynamicObject("entrysettleorg");
            settleorgs.add((Long)settleOrg.getPkValue());
        }
        HashSet<String> wfRecordBills = new HashSet<String>(8);
        QFilter qFilter = new QFilter("org", "in", settleorgs);
        qFilter.and("billid", "=", dataEntity.getPkValue());
        qFilter.and("billtype", "=", (Object)billType);
        ArrayList<String> list = new ArrayList<String>(8);
        list.add("purself");
        list.add("ominself");
        list.add("salself");
        qFilter.and("verifyrelation", "not in", list);
        DynamicObjectCollection wfRecordList = QueryServiceHelper.query((String)WfRecordTable, (String)"billid,billtype,entry.e_billid,entry.e_billtype,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])qFilter.toArray());
        WfRecordHelper.getWfRecord(wfRecordBills, wfRecordList, name, billNo);
        QFilter qFilterNew = new QFilter("org", "in", settleorgs);
        qFilterNew.and("entry.e_billid", "=", dataEntity.getPkValue());
        qFilterNew.and("entry.e_billtype", "=", (Object)billType);
        DynamicObjectCollection wfRecordTwoList = QueryServiceHelper.query((String)WfRecordTable, (String)"billid,billtype,entry.e_billid,entry.e_billtype,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])qFilter.toArray());
        WfRecordHelper.getWfRecord(wfRecordBills, wfRecordTwoList, name, billNo);
        return wfRecordBills;
    }

    private static void getWfRecord(Set<String> wfRecordBills, DynamicObjectCollection wfRecordList, String name, String billNo) {
        for (DynamicObject wfRecord : wfRecordList) {
            boolean entryIsWriteOff = wfRecord.getBoolean("entry.e_iswrittenoff");
            if (entryIsWriteOff) continue;
            String reBillIdType = wfRecord.getString("billtype");
            String reBillId = wfRecord.getString("billid");
            wfRecordBills.add(reBillIdType + "@" + reBillId);
            String entryBillId = wfRecord.getString("entry.e_billid");
            String entryBillIdType = wfRecord.getString("entry.e_billtype");
            boolean entryHadWriteOff = wfRecord.getBoolean("entry.e_hadwrittenoff");
            wfRecordBills.add(entryBillIdType + "@" + entryBillId);
            if (entryHadWriteOff) continue;
            throw new KDBizException(SCMCLang.wfRecordAllBeChargeOff(name, billNo));
        }
    }

    private static void arRevcfmWfRecordDeal(Set<String> wfRecordBills, String pk, String billType) {
        Long billId = Long.parseLong(pk);
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtSourceBills((String)billType, (Long[])new Long[]{billId});
        List bfRows = (List)dirtTargetBills.get(billId);
        for (BFRow next : bfRows) {
            BFRowId tid = next.getSId();
            BFRowBillResult bfRowBillResult = WfRecordHelper.getBFRowBillResult(tid);
            String entityNumber = bfRowBillResult.getEntityNumber();
            if (!"ar_finarbill".equals(entityNumber)) continue;
            wfRecordBills.add(entityNumber + "@" + tid.getBillId());
        }
    }

    private static BFRowBillResult getBFRowBillResult(BFRowId tid) {
        ConvertDataService reader = new ConvertDataService();
        Long mainTableId = tid.getMainTableId();
        TableDefine tableDefine = reader.loadTableDefine(mainTableId);
        String entityNumber = tableDefine.getEntityNumber();
        Long billId = tid.getBillId();
        return new BFRowBillResult(entityNumber, billId);
    }
}

