/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.valid.impl;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.SCMCLang;
import kd.bos.ext.scmc.chargeagainst.util.CaModelFieldCaChe;
import kd.bos.ext.scmc.chargeagainst.util.DateUtils;
import kd.bos.ext.scmc.chargeagainst.valid.CaValida;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PageMessageValid
implements CaValida {
    private OperateOption option;
    private CaModelFieldCaChe modelField;
    private static final String CA_PERMISS = "/NCNJ/321ENR";

    public static PageMessageValid build(OperateOption option, CaModelFieldCaChe modelField) {
        PageMessageValid valid = new PageMessageValid();
        valid.setOption(option);
        valid.setModelField(modelField);
        return valid;
    }

    @Override
    public void validate(List<DynamicObject> dataEntityList) {
        for (DynamicObject dataEntity : dataEntityList) {
            this.checkBillPageMessage(dataEntity);
        }
    }

    private void checkBillPageMessage(DynamicObject dataEntity) {
        String appId = ((BillEntityType)dataEntity.getDataEntityType()).getAppId();
        String orgKey = ((BillEntityType)dataEntity.getDataEntityType()).getMainOrg();
        DynamicObject orgId = dataEntity.getDynamicObject(orgKey);
        String billNumber = dataEntity.getDataEntityType().getName();
        String billName = dataEntity.getDataEntityType().getDisplayName().getLocaleValue();
        int isHavePerm = PermissionServiceHelper.checkPermission((Long)Long.parseLong(RequestContext.get().getUserId()), (Long)((Long)orgId.getPkValue()), (String)appId, (String)billNumber, (String)CA_PERMISS);
        if (isHavePerm != 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u51b2\u9500\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"ChargeAgainstValid_0", (String)"bos-ext-scmc", (Object[])new Object[0]), billName));
        }
        this.checkBookData(dataEntity);
    }

    private void checkBookData(DynamicObject dataEntity) {
        String billNumber = dataEntity.getDataEntityType().getName();
        String bookDataTime = this.option.getVariableValue("bookDate", null);
        String caDataTime = this.option.getVariableValue("cadate", null);
        if (bookDataTime == null || caDataTime == null) {
            return;
        }
        Date bookData = new Date(Long.parseLong(bookDataTime));
        Date caData = new Date(Long.parseLong(caDataTime));
        String bookDateField = this.modelField.getCaModelField(billNumber).getBookDate();
        Date date = dataEntity.getDate(bookDateField);
        Date dealDate = DateUtils.getDayStartTime(date);
        if (dealDate != null && dealDate.compareTo(bookData) > 0) {
            throw new KDBizException(SCMCLang.bookDateLessSrcBookDate(bookData, dealDate));
        }
        if (caData.compareTo(bookData) > 0) {
            throw new KDBizException(SCMCLang.bookDateLessChargeDate(bookData, caData));
        }
    }

    private void setOption(OperateOption option) {
        this.option = option;
    }

    private void setModelField(CaModelFieldCaChe modelField) {
        this.modelField = modelField;
    }
}

