/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.iscc;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.Propagation;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class BillRelUpdateOpAction
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(BillRelUpdateOpAction.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        OperateOption option = this.getOption();
        if ("1".equals(option.getVariableValue("billrelupdate", "0"))) {
            return;
        }
        DynamicObject[] entities = e.getDataEntities();
        if (null == entities || entities.length == 0) {
            return;
        }
        this.process(entities, e.getOperationKey());
    }

    private void process(DynamicObject[] entities, String operationKey) {
        String entityNumber = this.billEntityType.getName();
        List ids = Stream.of(entities).map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
        log.info("\u5355\u636e\u6807\u8bc6:{},\u5355\u636eid:{},\u64cd\u4f5c:{}", new Object[]{entityNumber, ids, operationKey});
        try {
            BillEntityType entityType = (BillEntityType)entities[0].getDataEntityType();
            String entityTypeStr = entityType.getName();
            String idKey = entityType.getPrimaryKey().getName();
            ArrayList<Long> billIds = new ArrayList<Long>(entities.length);
            ArrayList<String> businessInfoList = new ArrayList<String>(entities.length);
            for (DynamicObject entity : entities) {
                long id = entity.getLong(idKey);
                billIds.add(id);
                businessInfoList.add(entityTypeStr + "#" + id);
            }
            CommonParam param = new CommonParam();
            param.put((Object)"entityNumber", (Object)entityType.getName());
            param.put((Object)"ids", (Object)SerializationUtils.toJsonString(billIds));
            param.put((Object)"operationKey", (Object)operationKey);
            this.execute("iscc_billrelupdate", "relupdate", "scmc", "iscc", "BillRelUpdateOpService", this.billEntityType.getDBRouteKey(), businessInfoList, (Param)param, null);
        }
        catch (KDException ex) {
            log.error("\u5355\u636e\u66f4\u65b0\u65b9\u6848\u5f02\u5e38KDException", (Object)ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            log.error("\u5355\u636e\u66f4\u65b0\u65b9\u6848\u5f02\u5e38Exception", (Object)ex.getMessage());
            throw ex;
        }
    }

    private void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String serviceName, String dbRoute, List<String> businessInfo, Param param, String bizId) throws KDException {
        ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)dbRoute), (Propagation)Propagation.REQUIRES_NEW);
        ECGlobalSession.register((String)cloudId, (String)appId, (String)serviceName, (Param)param, (String)branchScenesCode, (String)bizId);
        if (!CollectionUtils.isEmpty(businessInfo)) {
            ECGlobalSession.setBusinessType((String)"BillRelUpdateOpAction");
            ECGlobalSession.setBusinessInfo(businessInfo);
        }
        ECGlobalSession.setAsync((boolean)true);
    }
}

