/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.isv;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.GlobalSessionType;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class IsvIntegrationOpAction
extends AbstractOpBizRuleAction {
    public static final String SENSE_CODE = "isv_integration_listener";
    private static final Log log = LogFactory.getLog(IsvIntegrationOpAction.class);
    private static final String CLOUD_ID = "mpscmm";
    private static final String APP_ID = "msisv";
    private static final String SERVICE_NAME = "IsvIntegrationService";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Object[] dataEntities = e.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        this.process((DynamicObject[])dataEntities, e.getOperationKey());
    }

    private void process(DynamicObject[] dataEntities, String operationKey) {
        String entityNumber = this.billEntityType.getName();
        List ids = Stream.of(dataEntities).map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
        log.info("\u5355\u636e\u6807\u8bc6:{},\u5355\u636eid:{},\u64cd\u4f5c\u7f16\u7801:{}", new Object[]{entityNumber, ids, operationKey});
        ArrayList<String> businessInfos = new ArrayList<String>(dataEntities.length);
        for (DynamicObject entity : dataEntities) {
            businessInfos.add(entityNumber + "#" + entity.getPkValue());
        }
        try {
            List pipelineMapList = (List)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)"loadIsvPipelineList", (Object[])new Object[]{entityNumber, ids, operationKey});
            if (ObjectUtils.isEmpty((Object)pipelineMapList)) {
                return;
            }
            IsvIntegrationOpAction.writeCollectInfo(0, 0L, entityNumber, Collections.singletonMap("key1", String.valueOf(pipelineMapList.size())));
            for (Map pipelineMap : pipelineMapList) {
                CommonParam commonParam = new CommonParam();
                commonParam.putAll(pipelineMap);
                String cloudId = (String)pipelineMap.get("cloudId");
                String appId = (String)pipelineMap.get("appId");
                String serviceName = (String)pipelineMap.get("serviceName");
                this.ecExecute(cloudId, appId, serviceName, (Param)commonParam, businessInfos);
            }
        }
        catch (KDException ex) {
            log.error("\u751f\u6001\u63a5\u5165\u76d1\u542c\u5f02\u5e38KDException", (Object)ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            log.error("\u751f\u6001\u63a5\u5165\u76d1\u542c\u5f02\u5e38Exception", (Object)ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    private void ecExecute(String cloudId, String appId, String serviceName, Param param, List<String> businessInfos) throws Exception {
        String dbRouteKey = this.billEntityType.getDBRouteKey();
        ECGlobalSession.begin((String)SENSE_CODE, (DBRoute)DBRoute.of((String)dbRouteKey), (GlobalSessionType)GlobalSessionType.COMBINATION);
        ECGlobalSession.register((String)cloudId, (String)appId, (String)serviceName, (Param)param);
        ECGlobalSession.setBusinessType((String)"IsvIntegrationOpAction");
        ECGlobalSession.setBusinessInfo(businessInfos);
        ECGlobalSession.setAsync((boolean)true);
    }

    private static void writeCollectInfo(int count, Long time, String formid, Map<String, String> var) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("keyword", (Object)"POA-FEATURE-MONITOR");
        jsonObject.put("featureNumber", (Object)"SCM2218-09");
        jsonObject.put("count", (Object)count);
        jsonObject.put("time:", (Object)time);
        jsonObject.put("formid", (Object)formid);
        jsonObject.put("var", var);
        log.info(jsonObject.toJSONString());
    }
}

