/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.scmc.operation.helper.InvAvbQtyQueryExtHelper;
import kd.bos.ext.scmc.operation.helper.NoUpdateFieldsAnalysisExtHelper;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AvbInventoryQuery
extends FormOperate {
    private static final Log logger = LogFactory.getLog(AvbInventoryQuery.class);
    private Map<String, Object> mapParam;

    public void initialize(Map<String, Object> arg0) {
        super.initialize(arg0);
        Map custParamObj = (Map)arg0.get("parameter");
        String paramValue = (String)custParamObj.get("parameter");
        this.mapParam = StringUtils.isBlank((CharSequence)paramValue) ? new HashMap<String, Object>() : (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
    }

    protected OperationResult invokeOperation() {
        IFormView view = this.getView();
        String entryKey = (String)this.mapParam.get("entrykey");
        String entryNoUpdateFieldkey = (String)this.mapParam.get("entrynoupdatefieldkey");
        if (null == entryKey || entryKey.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u53ef\u7528\u5e93\u5b58\u914d\u7f6e\u7684\u57fa\u7840\u4fe1\u606f\u201c\u5206\u5f55\u6807\u8bc6\u201d\u3002", (String)"AvbInventoryQuery_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return null;
        }
        EntryGrid grid = (EntryGrid)view.getControl(entryKey);
        if (null == grid) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u53ef\u7528\u5e93\u5b58\u914d\u7f6e\u7684\u57fa\u7840\u4fe1\u606f\u201c\u5206\u5f55\u6807\u8bc6\u201d\u3002", (String)"AvbInventoryQuery_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return null;
        }
        IDataModel model = view.getModel();
        int rowCount = model.getEntryRowCount(entryKey);
        if (rowCount == 0) {
            return null;
        }
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            EntryData entryData = grid.getEntryData();
            int startIndex = entryData.getStartIndex();
            int endIndex = entryData.getEndIndex();
            int pageRow = endIndex - startIndex;
            selectRows = new int[pageRow];
            for (int i = 0; i < pageRow; ++i) {
                selectRows[i] = i + startIndex;
            }
        }
        List fieldList = (List)this.mapParam.get("fielddata");
        NoUpdateFieldsAnalysisExtHelper.setNoUpdateFields(model, entryNoUpdateFieldkey, fieldList);
        Map<Integer, List<QFilter>> filterMap = this.getFilterMap(selectRows, entryNoUpdateFieldkey);
        Map updateQtyFieldsMap = (Map)this.mapParam.get("updateQtyFields");
        if (null == updateQtyFieldsMap || updateQtyFieldsMap.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5e93\u5b58\u5931\u8d25\uff0c\u672a\u5728\u201c\u663e\u793a\u53ef\u7528\u5e93\u5b58\u670d\u52a1\u201d\u914d\u7f6e\u6570\u91cf\u5b57\u6bb5\u6620\u5c04\u3002", (String)"AvbInventoryQuery_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return null;
        }
        Object filterFields = this.mapParam.get("filterFields");
        Map<Integer, Map<String, BigDecimal>> avbQtyMap = InvAvbQtyQueryExtHelper.getAvbQtyMap(filterMap, updateQtyFieldsMap, filterFields);
        InvAvbQtyQueryExtHelper.setAvbQtyWithAvbQtyMap(updateQtyFieldsMap, avbQtyMap, view);
        this.getView().getFormShowParameter().setCustomParam("avbQtyFilterMap", filterMap);
        this.getView().getFormShowParameter().setCustomParam("updateQtyFields", (Object)updateQtyFieldsMap);
        this.getView().getFormShowParameter().setCustomParam("filterFields", filterFields);
        this.showNotificationMsg(fieldList, avbQtyMap);
        return super.invokeOperation();
    }

    private Map<Integer, List<QFilter>> getFilterMap(int[] selectRows, String entryNoUpdateFieldkey) {
        HashMap<Integer, List<QFilter>> filterMap = new HashMap<Integer, List<QFilter>>(selectRows.length);
        for (int index : selectRows) {
            List<QFilter> filterList = this.getSingleFilterList(index, entryNoUpdateFieldkey);
            filterMap.put(index, filterList);
        }
        return filterMap;
    }

    private List<QFilter> getSingleFilterList(int index, String entryNoUpdateFieldkey) {
        List fields;
        IDataModel model = this.getView().getModel();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(16);
        ArrayList<String> entryNoUpdateFieldValueList = new ArrayList(4);
        if (null != entryNoUpdateFieldkey && !entryNoUpdateFieldkey.isEmpty()) {
            String entryNoUpdateFieldValue = (String)model.getValue(entryNoUpdateFieldkey, index);
            entryNoUpdateFieldValueList = NoUpdateFieldsAnalysisExtHelper.getNoUpdateFieldsList(entryNoUpdateFieldValue);
        }
        if (this.mapParam != null && (fields = (List)this.mapParam.get("fielddata")) != null) {
            for (int i = 0; i < fields.size(); ++i) {
                QFilter filter;
                Map field = (Map)fields.get(i);
                boolean isQFilter = (Boolean)field.get("qfilter");
                if (!isQFilter || null == (filter = this.getFilterByField(model, index, field, entryNoUpdateFieldValueList))) continue;
                filterList.add(filter);
            }
        }
        return filterList;
    }

    private QFilter getFilterByField(IDataModel model, int index, Map<String, Object> field, List<String> entryNoUpdateFieldValueList) {
        String valueStr;
        Object valueOfCurrKey;
        Object value;
        String currentKey = (String)field.get("currentmetadatakey");
        if (currentKey.isEmpty()) {
            return null;
        }
        String[] keys = currentKey.split("\\.");
        String invField = (String)field.get("metadatakey");
        if (keys.length == 1) {
            value = model.getValue(keys[0]);
        } else if (keys.length == 2) {
            value = model.getValue(keys[1], index);
            if (entryNoUpdateFieldValueList.contains(keys[1])) {
                return null;
            }
        } else {
            value = model.getValue(keys[2], index);
            if (entryNoUpdateFieldValueList.contains(keys[2])) {
                return null;
            }
        }
        Object object = valueOfCurrKey = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value;
        if (null == valueOfCurrKey) {
            return null;
        }
        if (value instanceof String && (valueStr = (String)value).isEmpty()) {
            return null;
        }
        QFilter filter = new QFilter(invField, "=", valueOfCurrKey);
        return filter;
    }

    private void showNotificationMsg(List<Map<String, Object>> fieldList, Map<Integer, Map<String, BigDecimal>> avbQtyMap) {
        String materialKey;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Map<Integer, Object> seq2MaterialMap = this.getNotMatchedSeq2MatMap(model, avbQtyMap, materialKey = this.getMaterialKey(fieldList));
        String warningMsg = this.getMaterialWarningMsg(seq2MaterialMap);
        if (StringUtils.isEmpty((CharSequence)warningMsg)) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u53ef\u7528\u5e93\u5b58\u67e5\u8be2\u5b8c\u6210\u3002", (String)"querySuccess", (String)"bos-ext-scmc", (Object[])new Object[0]));
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u53ef\u7528\u5e93\u5b58\u67e5\u8be2\u5b8c\u6210\uff0c\u5176\u4e2d%s\u6682\u65e0\u53ef\u7528\u5e93\u5b58\u3002", (String)"queryWithWarning", (String)"bos-ext-scmc", (Object[])new Object[]{warningMsg}));
        }
    }

    private Map<Integer, Object> getNotMatchedSeq2MatMap(IDataModel model, Map<Integer, Map<String, BigDecimal>> avbQtyMap, String materialKey) {
        HashMap<Integer, Object> seq2MaterialMap = new HashMap<Integer, Object>();
        for (Map.Entry<Integer, Map<String, BigDecimal>> qtyMapEntry : avbQtyMap.entrySet()) {
            boolean hasQty = false;
            for (BigDecimal qty : qtyMapEntry.getValue().values()) {
                if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) continue;
                hasQty = true;
                break;
            }
            if (hasQty) continue;
            if (!StringUtils.isEmpty((CharSequence)materialKey)) {
                seq2MaterialMap.put(qtyMapEntry.getKey(), model.getValue(materialKey, qtyMapEntry.getKey().intValue()));
                continue;
            }
            seq2MaterialMap.put(qtyMapEntry.getKey(), null);
        }
        return seq2MaterialMap;
    }

    private String getMaterialWarningMsg(Map<Integer, Object> seq2MaterialMap) {
        Map materials;
        StringBuilder warningMsg = new StringBuilder();
        HashSet<Long> matIdSet = new HashSet<Long>();
        if (seq2MaterialMap != null && !seq2MaterialMap.isEmpty()) {
            for (Map.Entry entry : seq2MaterialMap.entrySet()) {
                Object material = entry.getValue();
                if (material instanceof DynamicObject) {
                    String matName = ((DynamicObject)material).getString("name");
                    String matNum = ((DynamicObject)material).getString("number");
                    if (StringUtils.isEmpty((CharSequence)matName) || StringUtils.isEmpty((CharSequence)matNum)) {
                        if (!(((DynamicObject)material).getPkValue() instanceof Long)) continue;
                        matIdSet.add((Long)((DynamicObject)material).getPkValue());
                        continue;
                    }
                    if (warningMsg.length() > 0) {
                        warningMsg.append("\u3001");
                    }
                    warningMsg.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\uff1a%1$s\uff08%2$s\uff09", (String)"material", (String)"bos-ext-scmc", (Object[])new Object[0]), matName, matNum));
                    continue;
                }
                if (material instanceof Long) {
                    matIdSet.add((Long)material);
                    continue;
                }
                if (warningMsg.length() > 0) {
                    warningMsg.append("\u3001");
                }
                warningMsg.append(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55", (String)"seq", (String)"bos-ext-scmc", (Object[])new Object[]{(Integer)entry.getKey() + 1}));
            }
        }
        if (!matIdSet.isEmpty() && (materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"name,number", (QFilter[])new QFilter("id", "in", matIdSet).toArray())) != null && !materials.isEmpty()) {
            for (Object material : materials.values()) {
                if (material == null || StringUtils.isEmpty((CharSequence)material.getString("name")) || StringUtils.isEmpty((CharSequence)material.getString("number"))) continue;
                if (warningMsg.length() > 0) {
                    warningMsg.append("\u3001");
                }
                warningMsg.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\uff1a%1$s\uff08%2$s\uff09", (String)"material", (String)"bos-ext-scmc", (Object[])new Object[0]), material.getString("name"), material.getString("number")));
            }
        }
        if (warningMsg.length() <= 0) {
            for (Integer n : seq2MaterialMap.keySet()) {
                if (warningMsg.length() > 0) {
                    warningMsg.append("\u3001");
                }
                warningMsg.append(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55", (String)"seq", (String)"bos-ext-scmc", (Object[])new Object[]{n + 1}));
            }
        }
        return warningMsg.toString();
    }

    private String getMaterialKey(List<Map<String, Object>> fieldList) {
        String materialKey = null;
        for (Map<String, Object> field : fieldList) {
            int index;
            if (!"material".equals(field.get("metadatakey")) || (index = (materialKey = (String)field.get("currentmetadatakey")).lastIndexOf(".")) == -1) continue;
            materialKey = materialKey.substring(index + 1);
        }
        return materialKey;
    }
}

