/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;

public class SelectSn
extends FormOperate
implements ICloseCallBack {
    private static final String FORM_CHOOSESN = "plat_selectsn";
    private static final String ENTITY_TRANSOUTBILL = "im_transoutbill";
    private Map<String, String> param = new HashMap<String, String>();
    private static final String KEY_INVACC = "invacc";
    private static final String KEY_EXINVACC = "exinvacc";
    private static final String KEY_MOVEDC = "movedc";
    private static final String KEY_MATERIAL = "material";
    private static final String KEY_ENTRYFIELD = "entryfield";
    private static final String KEY_SNENTRYFIELD = "snentryfield";
    private static final String KEY_ORG = "org";
    private static final String KEY_WAREHOUSE = "warehouse";
    private static final String KEY_LOCATION = "location";
    private static final String KEY_AUXPTY = "auxpty";
    private static final String KEY_LOT = "lot";
    private static final String KEY_LOTNUM = "lotnum";
    private static final String KEY_SNSIZE = "snsize";
    private static final String KEY_SN = "sn";
    private static final String[] notInvschemeBill = new String[]{"im_materialreqbill", "im_initbill", "im_transapply", "im_locationtransfer"};
    private static String MoveDirectEnum_SRC = "A";
    private static String MoveDirectEnum_DES = "B";
    private static String TRANSCEIVER_1 = "0";
    private static String TRANSCEIVER_2 = "1";
    private static String TRANSCEIVER_3 = "2";

    public void initialize(Map<String, Object> opMeta) {
        super.initialize(opMeta);
        Map mapParam = new HashMap();
        Object objValue = opMeta.get("parameter");
        Map paramValue = new HashMap();
        if (objValue instanceof Map) {
            paramValue = (Map)objValue;
        }
        if (StringUtils.isNotBlank(paramValue)) {
            Object paramJson = paramValue.get("parameter");
            mapParam = (Map)SerializationUtils.fromJsonString((String)((String)paramJson), Map.class);
            this.param.put(KEY_ENTRYFIELD, (String)mapParam.get(KEY_ENTRYFIELD));
            this.param.put(KEY_SNENTRYFIELD, (String)mapParam.get(KEY_SNENTRYFIELD));
            this.param.put(KEY_MATERIAL, (String)mapParam.get(KEY_MATERIAL));
            this.param.put(KEY_ORG, (String)mapParam.get(KEY_ORG));
            this.param.put(KEY_WAREHOUSE, (String)mapParam.get(KEY_WAREHOUSE));
            this.param.put(KEY_LOCATION, (String)mapParam.get(KEY_LOCATION));
            this.param.put(KEY_LOT, (String)mapParam.get(KEY_LOT));
            this.param.put(KEY_LOTNUM, (String)mapParam.get(KEY_LOTNUM));
            this.param.put(KEY_SNSIZE, (String)mapParam.get(KEY_SNSIZE));
            this.param.put(KEY_SN, (String)mapParam.get(KEY_SN));
            this.param.put(KEY_AUXPTY, (String)mapParam.get(KEY_AUXPTY));
        }
    }

    protected OperationResult invokeOperation() {
        long srcbillid;
        DynamicObject srcEntity;
        int rowIndex = this.getView().getModel().getEntryCurrentRowIndex(this.param.get(KEY_ENTRYFIELD));
        DynamicObject entity = this.getView().getModel().getDataEntity();
        DynamicObject row = this.getView().getModel().getEntryRowEntity(this.param.get(KEY_ENTRYFIELD), rowIndex);
        FormShowParameter formParam = new FormShowParameter();
        formParam.setFormId(FORM_CHOOSESN);
        formParam.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "selectsn");
        formParam.setCloseCallBack(callBack);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject material = row.getDynamicObject(this.param.get(KEY_MATERIAL));
        List<Object> invAcc = this.getInvAccIds(entity, row, paramMap);
        if (invAcc.size() > 0) {
            paramMap.put(KEY_INVACC, invAcc);
        }
        paramMap.put(KEY_SNSIZE, row.get(this.param.get(KEY_SNSIZE)));
        paramMap.put(KEY_MOVEDC, this.getMoveDc(entity, row));
        paramMap.put(KEY_MATERIAL, material.getPkValue());
        formParam.setCustomParam("param", (Object)SerializationUtils.toJsonString(paramMap));
        formParam.setCustomParam("field", (Object)SerializationUtils.toJsonString(this.param));
        formParam.setCustomParam("pk", entity.getPkValue());
        String entityName = entity.getDataEntityType().getName();
        if ("im_transinbill".equals(entityName) && (srcEntity = BusinessDataServiceHelper.loadSingle((Object)(srcbillid = row.getLong("srcbillid")), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ENTITY_TRANSOUTBILL))) != null) {
            long snPk;
            ArrayList<Long> pks = new ArrayList<Long>();
            for (DynamicObject srow : srcEntity.getDynamicObjectCollection(this.param.get(KEY_ENTRYFIELD))) {
                for (DynamicObject snrow : srow.getDynamicObjectCollection(this.param.get(KEY_SNENTRYFIELD))) {
                    snPk = snrow.getLong("serialid_id");
                    if (0L == snPk) continue;
                    pks.add(snPk);
                }
            }
            if (pks.size() > 0) {
                Map des = BFTrackerServiceHelper.findTargetBills((String)ENTITY_TRANSOUTBILL, (Long[])new Long[]{srcbillid});
                ArrayList desPks = new ArrayList();
                des.values().forEach(a -> desPks.addAll(a));
                desPks.remove(entity.getPkValue());
                if (desPks.size() > 0) {
                    DynamicObject[] doc = BusinessDataServiceHelper.load((Object[])desPks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"im_transinbill"));
                    ArrayList<Long> desSnPks = new ArrayList<Long>();
                    for (DynamicObject desEntity : doc) {
                        for (DynamicObject srow : desEntity.getDynamicObjectCollection(this.param.get(KEY_ENTRYFIELD))) {
                            for (DynamicObject snrow : srow.getDynamicObjectCollection(this.param.get(KEY_SNENTRYFIELD))) {
                                snPk = snrow.getLong("serialid_id");
                                if (0L == snPk) continue;
                                desSnPks.add(snPk);
                            }
                        }
                    }
                    pks.removeAll(desSnPks);
                }
                formParam.setCustomParam("snPks", (Object)SerializationUtils.toJsonString(pks));
            }
        }
        this.getView().showForm(formParam);
        return super.invokeOperation();
    }

    private String getMoveDc(DynamicObject entity, DynamicObject row) {
        String direction = this.getDirection(entity);
        if (TRANSCEIVER_2.equals(direction) || TRANSCEIVER_3.equals(direction)) {
            return MoveDirectEnum_DES;
        }
        return MoveDirectEnum_SRC;
    }

    private String getDirection(DynamicObject dataEntity) {
        String formId = dataEntity.getDataEntityType().getName();
        if (Arrays.asList(notInvschemeBill).contains(formId)) {
            return "0";
        }
        DynamicObject invscheme = dataEntity.getDynamicObject("invscheme");
        if (invscheme == null) {
            throw new KDBizException(SelectSn.getMsgSelectSnStr());
        }
        invscheme = BusinessDataServiceHelper.loadSingle((Object)invscheme.getPkValue(), (String)"im_invscheme");
        DynamicObject transceiverType = invscheme.getDynamicObject("transceivertype");
        String bizdirection = transceiverType.getString("transceiver");
        return bizdirection;
    }

    private static String getMsgSelectSnStr() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u4e8b\u52a1", (String)"SelectSn_0", (String)"bos-ext-scmc", (Object[])new Object[0]);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        block3 : switch (key = evt.getActionId()) {
            case "selectsn": {
                String returnData = (String)evt.getReturnData();
                if (returnData == null) break;
                Map map = (Map)SerializationUtils.fromJsonString((String)returnData, Map.class);
                List data = (List)SerializationUtils.fromJsonString((String)((String)map.get("data")), List.class);
                Map field = (Map)SerializationUtils.fromJsonString((String)((String)map.get("field")), Map.class);
                IDataModel model = evt.getView().getModel();
                DynamicObjectCollection snRows = model.getEntryEntity((String)field.get(KEY_SNENTRYFIELD));
                int blank = 0;
                ArrayList<Object> snPks = new ArrayList<Object>();
                for (DynamicObject row : snRows) {
                    DynamicObject sn = row.getDynamicObject((String)field.get(KEY_SN));
                    if (sn == null) {
                        ++blank;
                        continue;
                    }
                    snPks.add(sn.getPkValue());
                }
                int size = data.size() - blank;
                if (size > 0) {
                    model.batchCreateNewEntryRow((String)field.get(KEY_SNENTRYFIELD), size);
                }
                int index = 0;
                int seq = 0;
                for (DynamicObject row : snRows) {
                    String value = row.getString((String)field.get(KEY_SN));
                    if (value == null || StringUtils.isBlank((CharSequence)value.trim())) {
                        Object[] sns = DynamicObjectSerializeUtil.deserialize((String)((String)((Map)data.get(index)).get(KEY_SN)), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile"));
                        ++index;
                        DynamicObject sn = (DynamicObject)sns[0];
                        if (snPks.contains(sn.getPkValue())) break block3;
                        model.setValue((String)field.get(KEY_SN), sns[0], seq);
                    }
                    ++seq;
                    if (data.size() != index) continue;
                    break block3;
                }
                break;
            }
        }
    }

    private List<Object> getInvAccIds(DynamicObject entity, DynamicObject row, Map<String, Object> paramMap) {
        String entityName = this.getView().getModel().getDataEntity().getDataEntityType().getName();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        this.buildQfilter(entity, this.param.get(KEY_ORG), KEY_ORG, filters);
        this.buildQfilter(row, this.param.get(KEY_MATERIAL), KEY_MATERIAL, filters);
        this.buildQfilter(row, this.param.get(KEY_LOTNUM), KEY_LOTNUM, filters);
        this.buildQfilter(row, this.param.get(KEY_WAREHOUSE), KEY_WAREHOUSE, filters);
        this.buildQfilter(row, this.param.get(KEY_LOCATION), KEY_LOCATION, filters);
        this.buildQfilter(row, this.param.get(KEY_AUXPTY), KEY_AUXPTY, filters);
        DynamicObjectCollection doc = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvAccSearchService", (String)"queryAcc", (Object[])new Object[]{"im_invacc", entityName, Collections.singletonList("id"), filters.toArray(new QFilter[filters.size()]), null});
        ArrayList<Object> accIds = new ArrayList<Object>();
        doc.forEach(p -> accIds.add(p.get("id")));
        if (accIds.size() > 0) {
            paramMap.put(KEY_INVACC, accIds);
        }
        if (entity.getDataEntityType().getName().equals(ENTITY_TRANSOUTBILL)) {
            DynamicObjectCollection doc2 = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvAccSearchService", (String)"queryAcc", (Object[])new Object[]{"im_invacc", entityName, Collections.singletonList("id"), filters.toArray(new QFilter[filters.size()]), null});
            ArrayList accIds2 = new ArrayList();
            doc2.forEach(p -> accIds2.add(p.get("id")));
            if (accIds2.size() > 0) {
                paramMap.put(KEY_EXINVACC, accIds2);
            }
        }
        return accIds;
    }

    private void buildQfilter(DynamicObject dynamic, String prop, String filterProp, List<QFilter> filters) {
        if (prop == null) {
            return;
        }
        Object dy = dynamic.get(prop);
        if (dy != null) {
            if (dy instanceof DynamicObject) {
                DynamicObject dyna = (DynamicObject)dy;
                if (KEY_MATERIAL.equals(prop)) {
                    filters.add(new QFilter(filterProp, "=", dyna.get("masterid_id")));
                } else {
                    filters.add(new QFilter(filterProp, "=", dyna.getPkValue()));
                }
            } else {
                filters.add(new QFilter(filterProp, "=", dy));
            }
        }
    }
}

