/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.bizrule;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.scmc.validation.ContPerformCtrlValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class ContPerformCtrlOpAction
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(ContPerformCtrlOpAction.class);
    private static final String CONTPERFORMCTRLSERVICE = "IContPerformCtrlService";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        String entityKey = this.billEntityType.getName();
        List fields = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)CONTPERFORMCTRLSERVICE, (String)"onPreparePropertys", (Object[])new Object[]{entityKey});
        if (fields != null && fields.size() > 0) {
            e.getFieldKeys().addAll(fields);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ContPerformCtrlValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills.length > 0) {
            String dbRouteKey = bills[0].getDataEntityType().getDBRouteKey();
            log.info("ContPerformCtrlOpAction-----dbRouteKey:" + dbRouteKey);
            if ("scm".equals(dbRouteKey)) {
                this.invokePerformCtrlService(bills);
            }
            try (TXHandle txHandle = TX.required();){
                try {
                    this.invokePerformCtrlService(bills);
                }
                catch (Exception exc) {
                    txHandle.markRollback();
                    throw exc;
                }
            }
        }
    }

    private Map<String, String> invokePerformCtrlService(DynamicObject[] bills) {
        String operationKey = (String)this.operateMeta.get("key");
        return (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)CONTPERFORMCTRLSERVICE, (String)"writeback", (Object[])new Object[]{bills, operationKey});
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        OperationResult op = this.getOperationResult();
        if (op.getSuccessPkIds().size() > 0) {
            String operationKey = (String)this.operateMeta.get("key");
            DynamicObject[] bills = e.getDataEntities();
            if (bills.length > 0) {
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)CONTPERFORMCTRLSERVICE, (String)"record", (Object[])new Object[]{bills, operationKey});
            }
        }
    }
}

