/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.documentedit;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.helper.WebOfficeBrowserParam;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;

public class DocumentEditOp
extends DefaultEntityOperate
implements ICloseCallBack {
    private static final Log log = LogFactory.getLog(DocumentEditOp.class);
    private Map<String, Object> mapParam = new HashMap<String, Object>();

    public void initialize(Map<String, Object> arg0) {
        super.initialize(arg0);
        Map operateParams = (Map)arg0.get("parameter");
        String paramsStr = (String)operateParams.get("parameter");
        Map params = (Map)SerializationUtils.fromJsonString((String)paramsStr, Map.class);
        this.mapParam = (Map)params.get("settingparam");
        String editForm = (String)this.mapParam.get("editform");
        if (kd.bos.util.StringUtils.isEmpty((String)editForm)) {
            this.mapParam.put("editform", "mscon_document");
        }
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        super.beforeInvokeOperation(result);
        if (!result.isSuccess()) {
            return false;
        }
        IFormView view = this.getView();
        if (view instanceof ListView) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5217\u8868\u64cd\u4f5c\u3002", (String)"DocumentEditOp_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
            this.getView().showErrorNotification(result.getMessage());
            return false;
        }
        IDataModel model = this.getView().getModel();
        DynamicObject bill = model.getDataEntity();
        Object pkValue = bill.getPkValue();
        if (pkValue == null || (Long)pkValue == 0L) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"DocumentEditOp_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
            this.getView().showTipNotification(result.getMessage());
            return false;
        }
        return true;
    }

    public OperationResult invokeOperation() {
        IFormView view = this.getView();
        DynamicObject bill = view.getModel().getDataEntity(true);
        this.mapParam.put("entityId", this.getEntityId());
        this.mapParam.put("pkId", bill.getPkValue());
        this.mapParam.put("operatekey", this.getOperateKey());
        this.mapParam.put("customParam", this.getParameter());
        Map response = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscon", (String)"DocumentEditService4Bos", (String)"beforeOpenDocumentList", (Object[])new Object[]{this.mapParam});
        List fileList = (List)response.get("fileList");
        Boolean isShowListForm = (Boolean)response.get("isShowListForm");
        if (fileList != null && isShowListForm.booleanValue()) {
            HashMap<String, Object> customerMap = new HashMap<String, Object>();
            customerMap.put("list", fileList);
            customerMap.put("entityId", this.getEntityId());
            customerMap.putAll(this.getParameter());
            FormShowParameter showParameter = new FormShowParameter();
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Modal);
            showParameter.setFormId((String)response.get("documentListFormId"));
            showParameter.setCustomParams(customerMap);
            showParameter.setOpenStyle(openStyle);
            showParameter.setHasRight(true);
            CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "selectOpenFileUrl");
            showParameter.setCloseCallBack(closeCallBack);
            this.cacheDocumentEditParam(this.mapParam, view);
            this.getView().showForm(showParameter);
        } else {
            if (fileList == null || fileList.size() == 0) {
                this.mapParam.put("openDocument", null);
            } else {
                Map data = (Map)fileList.get(0);
                this.mapParam.put("openDocument", data);
            }
            this.cacheDocumentEditParam(this.mapParam, view);
            this.openEditForm((String)this.mapParam.get("editform"), this.getView());
        }
        OperationResult result = new OperationResult();
        result.setShowMessage(false);
        result.setSuccess(true);
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        IFormView view = evt.getView();
        if ("selectOpenFileUrl".equals(actionId)) {
            Map data = (Map)returnData;
            Map<String, Object> param = this.getDocumentEditParam(view);
            if (data != null && !data.isEmpty()) {
                String url;
                FileService fileService = FileServiceFactory.getAttachmentFileService();
                if (fileService.exists(url = fileService.getFileServiceExt().getRealPath((String)data.get("url")))) {
                    param.put("openDocument", data);
                    this.cacheDocumentEditParam(param, view);
                    this.openEditForm((String)param.get("editform"), view);
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"DocumentEditOp_2", (String)"bos-ext-scmc", (Object[])new Object[0]));
                }
            } else if (data != null && data.isEmpty()) {
                this.openEditForm((String)param.get("editform"), view);
            }
        }
    }

    private Map<String, Object> getDocumentEditParam(IFormView view) {
        Map<String, Object> param = new HashMap<String, Object>();
        IPageCache pageCache = view.getPageCache();
        String params = pageCache.get("params");
        if (kd.bos.util.StringUtils.isNotEmpty((String)params)) {
            param = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
        }
        return param;
    }

    private void cacheDocumentEditParam(Map<String, Object> param, IFormView view) {
        IPageCache pageCache = view.getPageCache();
        pageCache.put("params", SerializationUtils.toJsonString(param));
    }

    private void openEditForm(String editForm, IFormView view) {
        try {
            String pageId = view.getPageId();
            HashMap<String, String> map = new HashMap<String, String>();
            String pageIdDecode = URLEncoder.encode(URLEncoder.encode(pageId, "utf-8"), "utf-8");
            map.put("pageId", pageIdDecode);
            WebOfficeBrowserParam webOfficeBrowserParam = new WebOfficeBrowserParam(editForm);
            webOfficeBrowserParam.setParams(map);
            webOfficeBrowserParam.setHideAddressBar(true);
            view.openUrl(DocumentEditOp.buildUrl(webOfficeBrowserParam));
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static String buildUrl(WebOfficeBrowserParam param) {
        String customParams;
        Map params;
        StringBuilder formUrl = new StringBuilder();
        formUrl.append("?formId=").append(param.getFormId());
        if (StringUtils.isNotBlank((CharSequence)param.getBillFormId())) {
            formUrl.append("&billFormId=").append(param.getBillFormId());
        }
        StringBuilder dFormUrl = new StringBuilder();
        dFormUrl.append("#/dform?formId=").append(param.getFormId());
        if (StringUtils.isNotBlank((CharSequence)param.getBillFormId())) {
            dFormUrl.append("&billFormId=").append(param.getBillFormId());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getPkId())) {
            dFormUrl.append("&pkId=").append(param.getPkId());
        }
        if (param.getStatus() != null) {
            dFormUrl.append("&Status=").append(param.getStatus().getValue());
        }
        if (null != (params = param.getParams()) && !params.isEmpty()) {
            customParams = "";
            try {
                customParams = URLEncoder.encode(URLEncoder.encode(SerializationUtils.toJsonString((Object)params), "utf-8"), "utf-8");
            }
            catch (UnsupportedEncodingException var9) {
                log.error((Throwable)var9);
            }
            if (StringUtils.isNotBlank((CharSequence)customParams)) {
                dFormUrl.append("&customParams=").append(customParams);
            }
        }
        customParams = param.getProtocol();
        String domainUrl = UrlService.getDomainContextUrl();
        domainUrl = RevProxyUtil.addSlash((String)domainUrl);
        StringBuilder url = new StringBuilder();
        url.append(customParams).append(domainUrl).append((CharSequence)formUrl);
        try {
            return dFormUrl.insert(0, EncreptSessionUtils.encryptTokenLoinSession((String)url.toString())).toString();
        }
        catch (UnsupportedEncodingException var8) {
            return "";
        }
    }
}

