/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.entryrowop;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.SCMCLang;
import kd.bos.ext.scmc.operation.entryrowop.model.EntryRowOpArgs;
import kd.bos.ext.scmc.plugin.operation.IEntryRowOpFormPlugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class EntryRowOp
extends FormOperate
implements ICloseCallBack {
    private static final Log logger = LogFactory.getLog(EntryRowOp.class);
    private Map<String, Object> mapParam;
    private static final String POP_VIEW = "scmc_entryrowopparam";

    public void initialize(Map<String, Object> arg0) {
        super.initialize(arg0);
        Map custParamObj = (Map)arg0.get("parameter");
        String paramValue = (String)custParamObj.get("parameter");
        this.mapParam = StringUtils.isBlank((CharSequence)paramValue) ? new HashMap<String, Object>() : (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
    }

    protected OperationResult invokeOperation() {
        Object productType;
        IFormView view = this.getView();
        String opType = this.getType();
        String entryKey = (String)this.mapParam.get("entrykey");
        EntryGrid grid = (EntryGrid)view.getControl(entryKey);
        int[] selectRows = grid.getSelectRows();
        if (selectRows == null || selectRows.length != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"EntryRowOp_3", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return super.invokeOperation();
        }
        String entityId = this.getEntityId();
        if ("im_saloutbill".equals(entityId) && "kitparent".equals(productType = view.getModel().getValue("kitproducttype", selectRows[0]))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5957\u4ef6\u7236\u9879\u7269\u6599\u4e0d\u5141\u8bb8\u62c6\u5206\u884c\u3002", (String)"EntryRowOp_6", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return super.invokeOperation();
        }
        String closeCallBackActionId = "";
        String caption = ResManager.loadKDString((String)"\u884c\u8bbe\u7f6e", (String)"EntryRowOp_0", (String)"bos-ext-scmc", (Object[])new Object[0]);
        if ("entryrowsplitop".equals(opType)) {
            closeCallBackActionId = "entryrowsplit_callback";
            caption = ResManager.loadKDString((String)"\u62c6\u5206\u884c\u8bbe\u7f6e", (String)"EntryRowOp_1", (String)"bos-ext-scmc", (Object[])new Object[0]);
        } else if ("entryrowcopyop".equals(opType)) {
            closeCallBackActionId = "entryrowcopy_callback";
            caption = ResManager.loadKDString((String)"\u590d\u5236\u884c\u8bbe\u7f6e", (String)"EntryRowOp_2", (String)"bos-ext-scmc", (Object[])new Object[0]);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(POP_VIEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(caption);
        parameter.setCustomParam("param", this.mapParam);
        parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeCallBackActionId));
        view.showForm(parameter);
        return super.invokeOperation();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        IFormView mainView = e.getView();
        Map returnData = (Map)e.getReturnData();
        if (returnData == null || !"entryrowsplit_callback".equals(actionId) && !"entryrowcopy_callback".equals(actionId)) {
            return;
        }
        String entryKey = (String)returnData.get("entrykey");
        EntryGrid grid = (EntryGrid)mainView.getControl(entryKey);
        int[] selectRows = grid.getSelectRows();
        if (selectRows == null || selectRows.length != 1) {
            mainView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"EntryRowOp_3", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return;
        }
        int selectRowIndex = selectRows[0];
        String materialKey = (String)returnData.get("material");
        Object material = mainView.getModel().getValue(materialKey, selectRowIndex);
        if (material == null) {
            mainView.showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5206\u5f55\u6ca1\u6709\u7269\u6599\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u62c6\u5206\u884c\u3002", (String)"BOS-EXT-SCMC-E-511535", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return;
        }
        returnData.put("actionid", actionId);
        List<Integer> newRowIndex = this.executeEntryRowOp(mainView, returnData, selectRowIndex);
        if (!"entryrowsplit_callback".equals(actionId)) {
            logger.info("EntryRowOp=====actionId = " + actionId);
            return;
        }
        EntryRowOpArgs args = new EntryRowOpArgs();
        args.setView(mainView);
        args.setEntryKey(entryKey);
        args.setSrcRowIndex(selectRowIndex);
        args.setNewRowIndex(newRowIndex);
        String pluginName = (String)returnData.get("pluginname");
        this.excutePlugin(pluginName, args);
    }

    private List<Integer> executeEntryRowOp(IFormView mainView, Map<String, Object> returnData, int selectRowIndex) {
        int index;
        IDataModel model = mainView.getModel();
        int rowcount = (Integer)returnData.get("rowcount");
        String addType = (String)returnData.get("createtype");
        String actionId = (String)returnData.get("actionid");
        String entryKey = (String)returnData.get("entrykey");
        JSONArray fieldData = (JSONArray)returnData.get("fielddata");
        String copyColumnKey = "copyrow";
        if ("entryrowsplit_callback".equals(actionId)) {
            copyColumnKey = "splitrow";
        }
        int entryRowCount = model.getEntryRowCount(entryKey);
        boolean isAppend = true;
        if ("1".equals(addType)) {
            index = selectRowIndex + 1;
            isAppend = false;
        } else {
            index = entryRowCount;
        }
        DynamicObjectCollection entry_lk = null;
        if (this.isDrawByBOTP(model, entryKey)) {
            entry_lk = this.getSrcRowRelation(selectRowIndex, model, entryKey);
        }
        model.getDataEntity(true);
        model.beginInit();
        if (isAppend) {
            model.batchCreateNewEntryRow(entryKey, rowcount - 1);
        }
        ArrayList<Integer> newEntryRowIndex = new ArrayList<Integer>(rowcount);
        for (int i = 0; i < rowcount - 1; ++i) {
            if (!isAppend) {
                model.insertEntryRow(entryKey, index + i);
            }
            for (Object fieldObject : fieldData) {
                boolean isCopy;
                JSONObject fieldSettingMap = (JSONObject)fieldObject;
                String currentMetaDataKey = fieldSettingMap.getString("currentmetadatakey");
                String entryKeyParam = currentMetaDataKey.split("\\.")[0];
                if (!entryKey.equals(entryKeyParam) || !(isCopy = fieldSettingMap.getBoolean(copyColumnKey).booleanValue())) continue;
                String fieldKey = currentMetaDataKey.split("\\.")[1];
                Control control = mainView.getControl(fieldKey);
                if (control instanceof DateRangeEdit) {
                    String startDateFieldKey = ((DateRangeEdit)control).getStartDateFieldKey();
                    String endDateFieldKey = ((DateRangeEdit)control).getEndDateFieldKey();
                    Object startDateField = model.getValue(startDateFieldKey, selectRowIndex);
                    model.setValue(startDateFieldKey, startDateField, index + i);
                    Object endDateField = model.getValue(endDateFieldKey, selectRowIndex);
                    model.setValue(endDateFieldKey, endDateField, index + i);
                    continue;
                }
                if (model.getProperty(fieldKey) == null) continue;
                Object srcValue = model.getValue(fieldKey, selectRowIndex);
                model.setValue(fieldKey, srcValue, index + i);
            }
            this.setEntryRelation(model, entryKey, index + i, entry_lk);
            newEntryRowIndex.add(index + i);
        }
        model.endInit();
        mainView.updateView(entryKey);
        mainView.getFormShowParameter().setCustomParam("entryRowOp", (Object)true);
        return newEntryRowIndex;
    }

    private void setEntryRelation(IDataModel model, String entryKey, int index, DynamicObjectCollection entry_lk) {
        if (entry_lk == null || entry_lk.isEmpty()) {
            return;
        }
        DynamicObject entry = (DynamicObject)model.getDataEntity().getDynamicObjectCollection(entryKey).get(index);
        if ("im_transinbill".equals(model.getDataEntityType().getName()) || "im_transapply".equals(model.getDataEntityType().getName())) {
            entryKey = "inv" + entryKey;
        }
        DynamicObjectCollection newEntryLk = entry.getDynamicObjectCollection(entryKey + "_lk");
        for (DynamicObject entryLk : entry_lk) {
            DynamicObject newLk = new DynamicObject(entryLk.getDynamicObjectType());
            newLk.set(entryKey + "_lk_stableid", entryLk.get(entryKey + "_lk_stableid"));
            newLk.set(entryKey + "_lk_sbillid", entryLk.get(entryKey + "_lk_sbillid"));
            newLk.set(entryKey + "_lk_sid", entryLk.get(entryKey + "_lk_sid"));
            newEntryLk.add((Object)newLk);
        }
    }

    private DynamicObjectCollection getSrcRowRelation(int selectRowIndex, IDataModel model, String entryKey) {
        DynamicObjectCollection entrys = model.getEntryEntity(entryKey);
        DynamicObject selectedEntry = (DynamicObject)entrys.get(selectRowIndex);
        if ("im_transinbill".equals(model.getDataEntityType().getName()) || "im_transapply".equals(model.getDataEntityType().getName())) {
            entryKey = "inv" + entryKey;
        }
        return selectedEntry.getDynamicObjectCollection(entryKey + "_lk");
    }

    private void excutePlugin(String pluginName, EntryRowOpArgs args) {
        if (StringUtils.isEmpty((CharSequence)pluginName)) {
            return;
        }
        try {
            Class<?> pluginClass = Class.forName(pluginName);
            IEntryRowOpFormPlugin calQtyPlugin = (IEntryRowOpFormPlugin)pluginClass.newInstance();
            calQtyPlugin.calQtyTypeFields(args);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new KDBizException(SCMCLang.pluginLoadFail(pluginName, "kd.bos.ext.scmc.plugin.operation.IEntryRowOpFormPlugin"));
        }
    }

    private boolean isDrawByBOTP(IDataModel model, String entryKey) {
        IDataEntityProperty dataEntityProperty;
        int size;
        DynamicObject bill = model.getDataEntity(true);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryKey);
        if (entrys == null || (size = entrys.size()) == 0) {
            return false;
        }
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)model.getDataEntityType().getName());
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        String linkEntityKey = entryKey + "_lk";
        List items = linkSet.getItems();
        for (LinkSetItemElement item : items) {
            if (!entryKey.equals(item.getParentEntityKey())) continue;
            linkEntityKey = item.getLinkEntityKey();
            break;
        }
        if ((dataEntityProperty = model.getDataEntityType().findProperty(linkEntityKey)) == null) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObjectCollection linkColl = entry.getDynamicObjectCollection(linkEntityKey);
            if (linkColl == null || linkColl.size() <= 0) continue;
            return true;
        }
        return false;
    }
}

