/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class InvAvbQtyQueryExtHelper {
    private static final Log logger = LogFactory.getLog(InvAvbQtyQueryExtHelper.class);
    private static final String algoKey = InvAvbQtyQueryExtHelper.class.getName();
    private static final Map<String, String> avbQtyInvaccFieldsMap = new HashMap<String, String>(8);
    private static final String AVBBQTY = "avbbqty";
    private static final String AVBBASEQTY = "avbbaseqty";
    private static final String AVBBTNDQTY = "avbbtndqty";
    private static final String REAL_BAL_TB = "im_inv_realbalance";
    private static final String CONFIG_CODE_HOT_REVERSE = "INV0007";
    private static final String[] RESERVE_SP_FIELDS;

    public static Map<Integer, Map<String, BigDecimal>> getAvbQtyMap(Map<Integer, List<QFilter>> filterMap, Map<String, String> updateQtyFieldsMap, Object filterFields) {
        logger.info("InvAvbQtyQueryHelper-------------filterFields:" + filterFields + ";updateQtyFields:" + updateQtyFieldsMap);
        HashMap<Integer, Map<String, BigDecimal>> avbQtyMap = new HashMap<Integer, Map<String, BigDecimal>>(16);
        if (filterMap != null && !filterMap.isEmpty()) {
            if (updateQtyFieldsMap == null || updateQtyFieldsMap.isEmpty()) {
                return avbQtyMap;
            }
            DynamicObject totalResCifDynamic = BusinessDataServiceHelper.loadSingle((Object)1406552222187325440L, (String)"msmod_total_reserveset");
            boolean isEnableTotalRes = totalResCifDynamic.getBoolean("isenable");
            DynamicObjectCollection cfgEntry = totalResCifDynamic.getDynamicObjectCollection("entryentity");
            boolean totalAggQty = Boolean.FALSE;
            for (DynamicObject dynamicObject : cfgEntry) {
                if (!"showinvqty".equals(dynamicObject.getString("relateditem"))) continue;
                totalAggQty = dynamicObject.getBoolean("totalaggqty");
            }
            String isInit = totalResCifDynamic.getString("isinit");
            for (Map.Entry<Integer, List<QFilter>> entry : filterMap.entrySet()) {
                Map<String, BigDecimal> qtyMap;
                int index = entry.getKey();
                List<QFilter> qFilters = entry.getValue();
                logger.info("InvAvbQtyQueryHelper-------------qFilters:" + qFilters);
                List selColList = (List)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"checkDimRange", (Object[])new Object[]{qFilters});
                if (isEnableTotalRes && totalAggQty && selColList != null && selColList.size() != 0 && "1".equals(isInit)) {
                    StringBuilder selCols = new StringBuilder();
                    int i = 0;
                    for (String selCol : selColList) {
                        if (i++ > 0) {
                            selCols.append(',');
                        }
                        selCols.append(selCol);
                    }
                    selCols.append(",baseqty,qty,qty2nd");
                    selCols.append(",lockbaseqty,lockqty,lockqty2nd");
                    selCols.append(",(baseqty-lockbaseqty) as avbbaseqty");
                    selCols.append(",(qty-lockqty) as avbqty");
                    selCols.append(",(qty2nd-lockqty2nd) as avbqty2nd");
                    selCols.append(",id");
                    DataSet totalResDs = QueryServiceHelper.queryDataSet((String)InvAvbQtyQueryExtHelper.class.getName(), (String)"msmod_reserveaggre", (String)selCols.toString(), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), null);
                    totalResDs = InvAvbQtyQueryExtHelper.mergeReserveQty(totalResDs);
                    qtyMap = InvAvbQtyQueryExtHelper.getTotalSumQtyMap(totalResDs, selColList, updateQtyFieldsMap);
                } else {
                    DataSet avbbaseqtyDs = InvAvbQtyQueryExtHelper.getInvAvbDataSet(qFilters);
                    qtyMap = InvAvbQtyQueryExtHelper.getSumQtyMap(avbbaseqtyDs, updateQtyFieldsMap);
                }
                avbQtyMap.put(index, qtyMap);
                logger.info("InvAvbQtyQueryHelper-------------index:" + index + ";qtyMap:" + qtyMap);
            }
        }
        return avbQtyMap;
    }

    private static Map<String, BigDecimal> getTotalSumQtyMap(DataSet totalResDs, List<String> selColList, Map<String, String> updateQtyFieldsMap) {
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(8);
        DataSet groupByDS = totalResDs.groupBy(selColList.toArray(new String[0])).sum("qty").sum("baseqty").sum("qty2nd").sum("avbqty").sum(AVBBASEQTY).sum("avbqty2nd").finish();
        for (Row row : groupByDS) {
            for (Map.Entry<String, String> entry : updateQtyFieldsMap.entrySet()) {
                String field = entry.getKey();
                String qtyField = entry.getValue();
                qtyMap.put(qtyField, row.getBigDecimal(field));
            }
        }
        return qtyMap;
    }

    public static DataSet getInvAvbDataSet(List<QFilter> qFilters) {
        DataSet ds = InvAvbQtyQueryExtHelper.getInvaccDataSet(qFilters);
        ds = InvAvbQtyQueryExtHelper.mergeReserveQty(ds);
        DataSet avbbaseqtyDs = InvAvbQtyQueryExtHelper.getAvbbaseqty(ds);
        return avbbaseqtyDs;
    }

    private static DataSet getInvaccDataSet(List<QFilter> qFilters) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)REAL_BAL_TB);
        ArrayList selectorSet = new ArrayList(dt.getAllFields().keySet());
        selectorSet.add("material.name");
        selectorSet.add("id");
        selectorSet.remove("keycol");
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)REAL_BAL_TB, (String)String.join((CharSequence)",", selectorSet), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"");
        return ds;
    }

    private static Map<String, BigDecimal> getSumQtyMap(DataSet dataSet, Map<String, String> updateQtyFieldsMap) {
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(8);
        DataSet groupByDS = dataSet.groupBy(new String[]{"org", "material"}).sum("qty").sum("baseqty").sum("qty2nd").sum(AVBBQTY).sum(AVBBASEQTY).sum(AVBBTNDQTY).finish();
        for (Row row : groupByDS) {
            for (Map.Entry<String, String> entry : updateQtyFieldsMap.entrySet()) {
                String field = entry.getKey();
                String rowKey = avbQtyInvaccFieldsMap.get(field) == null ? field : avbQtyInvaccFieldsMap.get(field);
                String qtyField = entry.getValue();
                qtyMap.put(qtyField, row.getBigDecimal(rowKey));
            }
        }
        return qtyMap;
    }

    public static void setAvbQty(Map<Integer, List<QFilter>> filterMap, Map<String, String> updateQtyFieldsMap, Object filterFields, IFormView view) {
        Map<Integer, Map<String, BigDecimal>> avbQtyMap = InvAvbQtyQueryExtHelper.getAvbQtyMap(filterMap, updateQtyFieldsMap, filterFields);
        InvAvbQtyQueryExtHelper.setAvbQtyWithAvbQtyMap(updateQtyFieldsMap, avbQtyMap, view);
    }

    public static void setAvbQtyWithAvbQtyMap(Map<String, String> updateQtyFieldsMap, Map<Integer, Map<String, BigDecimal>> avbQtyMap, IFormView view) {
        IDataModel model = view.getModel();
        for (Map.Entry<Integer, Map<String, BigDecimal>> entry : avbQtyMap.entrySet()) {
            int index = entry.getKey();
            Map<String, BigDecimal> qtyMap = entry.getValue();
            if (null == qtyMap || qtyMap.isEmpty()) {
                for (String string : updateQtyFieldsMap.values()) {
                    model.setValue(string, null, index);
                }
                continue;
            }
            for (Map.Entry entry2 : qtyMap.entrySet()) {
                model.setValue((String)entry2.getKey(), entry2.getValue(), index);
            }
        }
    }

    public static DataSet getAvbbaseqty(DataSet ds) {
        DataSet reserveData = QueryServiceHelper.queryDataSet((String)"ReserveHelper", (String)"sbs_reservation", (String)"supplybillid,reserveqty,reservebaseqty,reserveunit2ndqty", (QFilter[])new QFilter[]{new QFilter("supplyformid", "=", (Object)REAL_BAL_TB)}, (String)null);
        DataSet invaccSumReserve = reserveData.select("Cast(supplybillid as Long) supplybillid,reservebaseqty,reserveqty,reserveunit2ndqty").groupBy(new String[]{"supplybillid"}).sum("reservebaseqty").sum("reserveqty").sum("reserveunit2ndqty").finish();
        List<String> invaccFields = InvAvbQtyQueryExtHelper.getDataSetCols(ds);
        List<String> reserveFields = InvAvbQtyQueryExtHelper.getDataSetCols(invaccSumReserve);
        JoinHint hint = new JoinHint();
        hint.setNullAsZero(true);
        DataSet qty = ds.join(invaccSumReserve, JoinType.LEFT).on("id", "supplybillid").hint(hint).select(invaccFields.toArray(new String[0]), reserveFields.toArray(new String[0])).finish();
        invaccFields.add("case when reserveqty is Null then 0 else reserveqty end as reserveqty");
        invaccFields.add("case when reservebaseqty is Null then 0 else reservebaseqty end as reservebaseqty");
        invaccFields.add("case when reserveunit2ndqty is Null then 0 else reserveunit2ndqty end as reserveunit2ndqty");
        DataSet avbbaseqty = qty.select(invaccFields.toArray(new String[0]));
        String[] fieldNames = avbbaseqty.getRowMeta().getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fieldNames[i].equals("reserveqty")) {
                fieldNames[i] = "lockqty + reserveqty AS reserveqty";
            }
            if (fieldNames[i].equals("reservebaseqty")) {
                fieldNames[i] = "lockbaseqty + reservebaseqty AS reservebaseqty";
            }
            if (!fieldNames[i].equals("reserveunit2ndqty")) continue;
            fieldNames[i] = "lockqty2nd + reserveunit2ndqty AS reserveunit2ndqty";
        }
        avbbaseqty = avbbaseqty.select(fieldNames);
        List<String> invaccFields1 = InvAvbQtyQueryExtHelper.getDataSetCols(avbbaseqty);
        invaccFields1.add("(baseqty-reservebaseqty) as avbbaseqty");
        invaccFields1.add("(qty-reserveqty) as avbbqty");
        invaccFields1.add("(qty2nd-reserveunit2ndqty) as avbbtndqty");
        invaccFields1.add("reservebaseqty as reservoeqty");
        invaccFields1.remove(AVBBASEQTY);
        DataSet finish = avbbaseqty.select(invaccFields1.toArray(new String[0]));
        return finish;
    }

    private static List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        int count = fields.length;
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            list.add(fields[i].getName().toLowerCase());
        }
        return list;
    }

    private static DataSet mergeReserveQty(DataSet invAccDataSet) {
        if (!InvAvbQtyQueryExtHelper.getScmParam(CONFIG_CODE_HOT_REVERSE)) {
            return invAccDataSet;
        }
        DataSet spDataSet = QueryServiceHelper.queryDataSet((String)InvAvbQtyQueryExtHelper.class.getName(), (String)"msmod_reserve_bal_sp", (String)"invid,baseqty as spbaseqty,qty as spqty ,qty2nd as spqty2nd", null, null);
        if (!spDataSet.hasNext()) {
            return invAccDataSet;
        }
        spDataSet = spDataSet.groupBy(new String[]{"invid"}).sum("spbaseqty").sum("spqty").sum("spqty2nd").finish();
        String[] invaccFields = invAccDataSet.getRowMeta().getFieldNames();
        DataSet qty = invAccDataSet.join(spDataSet, JoinType.LEFT).on("id", "invid").select(invaccFields, RESERVE_SP_FIELDS).finish();
        DataSet lockQty = InvAvbQtyQueryExtHelper.calReverseQty(qty);
        return InvAvbQtyQueryExtHelper.calAvbQty(lockQty);
    }

    private static DataSet calReverseQty(DataSet qty) {
        String[] spFieldNames = qty.getRowMeta().getFieldNames();
        for (int i = 0; i < spFieldNames.length; ++i) {
            if ("lockqty".equals(spFieldNames[i])) {
                spFieldNames[i] = "(lockqty + spqty) AS lockqty";
            }
            if ("lockbaseqty".equals(spFieldNames[i])) {
                spFieldNames[i] = "(spbaseqty + lockbaseqty) AS lockbaseqty";
            }
            if (!"lockqty2nd".equals(spFieldNames[i])) continue;
            spFieldNames[i] = "(spqty2nd + lockqty2nd) AS lockqty2nd";
        }
        return qty.select(spFieldNames);
    }

    private static DataSet calAvbQty(DataSet select) {
        String[] invFieldNames = select.getRowMeta().getFieldNames();
        for (int i = 0; i < invFieldNames.length; ++i) {
            if (AVBBASEQTY.equals(invFieldNames[i])) {
                invFieldNames[i] = "(baseqty-lockbaseqty) as avbbaseqty";
            }
            if ("avbqty".equals(invFieldNames[i])) {
                invFieldNames[i] = "(qty-lockqty) as avbqty";
            }
            if (!"avbqty2nd".equals(invFieldNames[i])) continue;
            invFieldNames[i] = "(qty2nd-lockqty2nd) as avbqty2nd";
        }
        return select.select(invFieldNames);
    }

    private static boolean getScmParam(String key) {
        QFilter qFilter = new QFilter("number", "=", (Object)key);
        DynamicObject scmParam = QueryServiceHelper.queryOne((String)"sbs_scmcapplevelparam", (String)"enable", (QFilter[])qFilter.toArray());
        if (scmParam == null) {
            return false;
        }
        return scmParam.getBoolean("enable");
    }

    static {
        avbQtyInvaccFieldsMap.put("avbqty", AVBBQTY);
        avbQtyInvaccFieldsMap.put("avbqty2nd", AVBBTNDQTY);
        RESERVE_SP_FIELDS = new String[]{"case when spbaseqty is null then 0 else spbaseqty end as spbaseqty", "case when spqty is null then 0 else spqty end as spqty", "case when spqty2nd is null then 0 else spqty2nd end as spqty2nd"};
    }
}

