/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.price;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.operation.price.AbstractInvPriceQueryPlugin;
import kd.bos.ext.scmc.operation.price.PricingUtils;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;

public class InvPriceQuery
extends FormOperate {
    private static final Log log = LogFactory.getLog(InvPriceQuery.class);
    private Map<String, Object> mapParam;
    private AbstractInvPriceQueryPlugin plugin = null;
    private String entryKey = null;
    private String priceKey = null;
    private long exrateTableId = 0L;
    private Date exrateDate = null;
    private long targetCurrency = 0L;

    public void initialize(Map<String, Object> arg) {
        super.initialize(arg);
        Map custParamObj = (Map)arg.get("parameter");
        String paramValue = (String)custParamObj.get("parameter");
        this.mapParam = StringUtils.isBlank((CharSequence)paramValue) ? new HashMap<String, Object>(16) : (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
        String pluginName = (String)this.mapParam.get("pluginname");
        if (StringUtils.isNotBlank((CharSequence)pluginName)) {
            Object newInstance = null;
            try {
                newInstance = Class.forName(pluginName).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error("InvPriceQuery\u53d6\u4ef7\u63d2\u4ef6\u5b9e\u4f8b\u5316\u5931\u8d25\uff1a", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u4ef7\u63d2\u4ef6\u5b9e\u4f8b\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u64cd\u4f5c\u7684\u63d2\u4ef6\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"BOSEXT-E-056784", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
            if (newInstance instanceof AbstractInvPriceQueryPlugin) {
                this.plugin = newInstance;
                this.plugin.setOp(this);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u4ef7\u63d2\u4ef6\u672a\u5b9e\u73b0IInvPriceQueryPlugin\u63a5\u53e3\uff0c\u8bf7\u5904\u7406\u540e\u91cd\u8bd5\u3002", (String)"BOSEXT-E-725864", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
        }
    }

    public OperationResult invokeOperation() {
        this.preparedPricingInfo();
        Map<Object, Map<String, Object>> result = this.queryPrice();
        this.fillToBill(result);
        return super.invokeOperation();
    }

    private void preparedPricingInfo() {
        this.entryKey = (String)this.mapParam.get("entrykey");
        this.priceKey = (String)this.mapParam.get("pricekey");
        String exrateDateKey = "biztime";
        String currencyKey = "settlecurrency";
        String materialKey = "material";
        IDataModel model = this.getView().getModel();
        BillEntityType type = (BillEntityType)model.getDataEntity().getDataEntityType();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.entryKey);
        int[] selectRowIndexs = entryGrid.getSelectRows();
        if (selectRowIndexs == null || selectRowIndexs.length == 0) {
            String failReason = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u5206\u5f55\u3002", (String)"PlsSelectOneEntry", (String)"bos-ext-scmc", (Object[])new Object[0]);
            throw new KDBizException(failReason);
        }
        StringBuilder noMaterialEntry = new StringBuilder();
        boolean allHaveMaterial = true;
        String failReason = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u672a\u5f55\u5165\u7269\u6599\u3002\n", (String)"EntryNotInsertMaterial", (String)"bos-ext-scmc", (Object[])new Object[0]);
        for (int rowIndex : selectRowIndexs) {
            DynamicObject material = (DynamicObject)model.getValue(materialKey, rowIndex);
            if (material != null) continue;
            allHaveMaterial = false;
            noMaterialEntry.append(String.format(failReason, rowIndex + 1));
        }
        if (!allHaveMaterial) {
            throw new KDBizException(noMaterialEntry.toString());
        }
        String mainOrgKey = type.getMainOrg();
        if (StringUtils.isEmpty((CharSequence)mainOrgKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u672a\u914d\u7f6e\u4e3b\u4e1a\u52a1\u4e2d\u7ec4\u7ec7\u3002", (String)"BillNotConfigMainOrg", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        DynamicObject mainOrg = (DynamicObject)model.getValue(mainOrgKey);
        if (mainOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"MainOrgIsEmpty", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        this.exrateDate = (Date)model.getValue(exrateDateKey);
        if (this.exrateDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u65e5\u671f\u3002", (String)"PlsInputBizTime", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        DynamicObject currency = (DynamicObject)model.getValue(currencyKey);
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e01\u79cd\u3002", (String)"PlsInputCurrency", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        this.targetCurrency = currency.getLong("id");
        Map<String, Long> currencyAndExRateTable = PricingUtils.getCurrencyAndExRateTable(mainOrg.getLong("id"));
        if (currencyAndExRateTable == null || currencyAndExRateTable.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u6c47\u7387\u8868\u3002", (String)"MainOrgNotSetExrateTable", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        this.exrateTableId = currencyAndExRateTable.get("exchangeRateTableID");
    }

    private Map<Object, Map<String, Object>> queryPrice() {
        Map<Long, Map<String, Object>> allparams = this.buildPriceParam();
        this.executeAfterBuildQueryPraram(allparams);
        HashMap<Object, Map<String, Object>> costPriceResult = new HashMap();
        try {
            costPriceResult = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostPriceService", (String)"getPrice", (Object[])new Object[]{allparams});
        }
        catch (Exception e) {
            String erroInfo = String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u67e5\u8be2\uff1a\n\u8c03\u7528\u6838\u7b97\u6210\u672c\u4ef7\u53d6\u4ef7\u670d\u52a1\u5f02\u5e38\uff1a%s\n", (String)"BOSEXT-E-326402", (String)"bos-ext-scmc", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            log.info("InvPriceQuery\u67e5\u8be2\u53c2\u6570:" + allparams);
            log.info("InvPriceQuery\u9519\u8bef\u4fe1\u606f:" + erroInfo);
            throw new KDBizException(erroInfo);
        }
        return costPriceResult;
    }

    private Map<Long, Map<String, Object>> buildPriceParam() {
        IDataModel model = this.getView().getModel();
        DynamicObject bill = model.getDataEntity(true);
        MainEntityType entityType = (MainEntityType)bill.getDataEntityType();
        String entityTypeStr = entityType.getName();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.entryKey);
        int[] selectRowIndexs = entryGrid.getSelectRows();
        HashSet<String> entities = new HashSet<String>();
        entities.add(entityTypeStr);
        Map resultMapping = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostPriceService", (String)"getBillFields", (Object[])new Object[]{entities});
        if (resultMapping == null || resultMapping.size() == 0) {
            String failReason = ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u914d\u7f6e\u6838\u7b97\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\uff0c\u65e0\u6cd5\u8fdb\u884c\u4ef7\u683c\u67e5\u8be2\u3002", (String)"NotConfigFiCalBillField", (String)"bos-ext-scmc", (Object[])new Object[0]);
            throw new KDBizException(String.format(failReason, bill.getDataEntityType().getDisplayName()));
        }
        Map fiedlMap = (Map)resultMapping.get(entityTypeStr);
        HashMap<String, String> headMap = new HashMap<String, String>(fiedlMap.size());
        HashMap<String, String> entryMap = new HashMap<String, String>(fiedlMap.size());
        for (Map.Entry fieldKeys : fiedlMap.entrySet()) {
            String costfieldKey = (String)fieldKeys.getKey();
            String billfieldKey = (String)fieldKeys.getValue();
            IDataEntityProperty findProperty = entityType.findProperty(billfieldKey);
            String parentKey = findProperty.getParent().getName();
            if (StringUtils.isEmpty((CharSequence)parentKey)) continue;
            if (parentKey.equals(entityTypeStr)) {
                headMap.put(costfieldKey, billfieldKey);
                continue;
            }
            if (!parentKey.equals(this.entryKey)) continue;
            entryMap.put(costfieldKey, billfieldKey);
        }
        HashMap<Long, Map<String, Object>> allparams = new HashMap<Long, Map<String, Object>>(selectRowIndexs.length);
        Map<String, Object> pricingHeadParam = PricingUtils.getPricingParam(bill, headMap);
        for (int rowIndex : selectRowIndexs) {
            HashMap<String, Object> pricingParam = new HashMap<String, Object>(2);
            pricingParam.putAll(pricingHeadParam);
            pricingParam.putAll(PricingUtils.getPricingParam(model.getEntryRowEntity(this.entryKey, rowIndex), entryMap));
            if (pricingParam.size() == 0) continue;
            pricingParam.put("entityobject", entityTypeStr);
            allparams.put(Long.valueOf(rowIndex), pricingParam);
        }
        return allparams;
    }

    private void fillToBill(Map<Object, Map<String, Object>> result) {
        IDataModel model = this.getView().getModel();
        this.executeBeforeFillBill(result);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.entryKey);
        int[] selectRowIndexs = entryGrid.getSelectRows();
        boolean isAllPricingSuccess = true;
        StringBuilder strs = new StringBuilder();
        HashMap<Long, BigDecimal> currencyExrate = new HashMap<Long, BigDecimal>(result.size());
        for (int rowIndex : selectRowIndexs) {
            Map<String, Object> priceResult = result.get(rowIndex);
            if (priceResult == null || priceResult.size() == 0) {
                isAllPricingSuccess = false;
                strs.append(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u83b7\u53d6\u4ef7\u683c\u5931\u8d25\u3002\n", (String)"EntryPriceGetFail", (String)"bos-ext-scmc", (Object[])new Object[0]), rowIndex + 1));
                continue;
            }
            BigDecimal price = (BigDecimal)priceResult.get("price");
            long currencyId = (Long)priceResult.get("currency");
            if (this.targetCurrency != currencyId) {
                BigDecimal exRate = (BigDecimal)currencyExrate.get(currencyId);
                if (exRate == null) {
                    exRate = PricingUtils.getExRate(this.exrateTableId, currencyId, this.targetCurrency, this.exrateDate);
                    currencyExrate.put(currencyId, exRate);
                }
                price = price.multiply(exRate);
            }
            model.setValue(this.priceKey, (Object)price, rowIndex);
        }
        this.executeAfterFillBil();
        if (!isAllPricingSuccess) {
            this.getView().showTipNotification(strs.toString());
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u67e5\u8be2\u6210\u529f\u3002", (String)"PriceQuerySuccess", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }

    private void executeAfterBuildQueryPraram(Object param) {
        if (this.plugin == null) {
            return;
        }
        this.plugin.afterBuildQueryPraram(param);
    }

    private void executeBeforeFillBill(Object result) {
        if (this.plugin == null) {
            return;
        }
        this.plugin.beforeFillBill(result);
    }

    private void executeAfterFillBil() {
        if (this.plugin == null) {
            return;
        }
        this.plugin.afterFillBill();
    }
}

