/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.plugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;

public class MetadataMapperPlugin
extends AbstractFormPlugin {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_METADATA = "metadata";
    private static final String KEY_METADATAKEY = "metadatakey";
    private static final String KEY_CURRENTMETADATA = "currentmetadata";
    private static final String KEY_CURRENTMETADATAKEY = "currentmetadatakey";

    public void registerListener(EventObject e) {
        TextEdit t = (TextEdit)this.getControl(KEY_CURRENTMETADATA);
        t.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String number = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (StringUtils.isBlank((CharSequence)number)) {
            return;
        }
        String sql = "SELECT FID FROM t_meta_entitydesign WHERE FNUMBER= ?";
        List formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{number}, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
                while (rs.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", rs.getString("FID"));
                    list.add(map);
                }
                return list;
            }
        });
        String entityId = "";
        if (formList != null && formList.size() > 0) {
            entityId = (String)((Map)formList.get(0)).get("id");
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        String entityName = entityMetadata.getRootEntity().getName().getLocaleValue();
        TextEdit textEdit = (TextEdit)this.getControl(KEY_METADATA);
        textEdit.setText(entityName);
        this.getView().updateView();
        List fields = entityMetadata.getRootEntity().getItems();
        ArrayList list = new ArrayList(fields.size());
        for (EntityItem field : fields) {
            HashMap<String, String> fieldItem = new HashMap<String, String>();
            fieldItem.put("key", field.getKey());
            fieldItem.put("name", field.getName().toString());
            list.add(fieldItem);
        }
        if (list != null && list.size() > 0) {
            int size = list.size();
            this.getView().getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, size);
            for (int i = 0; i < size; ++i) {
                Map map = (Map)list.get(i);
                this.getModel().setValue(KEY_METADATA, map.get("name"), i);
                this.getModel().setValue(KEY_METADATAKEY, map.get("key"), i);
            }
        }
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (KEY_CURRENTMETADATA.equals(key)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("scmc_fieldselect");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("currentnumber", this.getView().getFormShowParameter().getCustomParam("currentnumber"));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fieldSelectCallBack"));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        if (e.getReturnData() != null && "fieldSelectCallBack".equals(actionId = e.getActionId())) {
            Map data = (Map)e.getReturnData();
            Map field = (Map)data.get("field");
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows != null && selectRows.length > 0) {
                int row = selectRows[0];
                if (field != null) {
                    this.getModel().setValue(KEY_CURRENTMETADATA, field.get("fieldname"), row);
                    this.getModel().setValue(KEY_CURRENTMETADATAKEY, field.get("fieldkey"), row);
                } else {
                    this.getModel().setValue(KEY_CURRENTMETADATA, (Object)"", row);
                    this.getModel().setValue(KEY_CURRENTMETADATAKEY, (Object)"", row);
                }
            }
        }
    }
}

