/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.plugin.bizrule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.scmc.paramentity.bizrule.SnParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.entity.operation.AbstractOpBizRuleParameterEdit;

public class SnOpBizRulePlugin
extends AbstractOpBizRuleParameterEdit {
    private static final String COL_ENTRYFIELD = "entryfield";
    private static final String COL_SNENTRYFIELD = "snentryfield";
    private static final String COL_MATERIAL = "material";
    private static final String COL_SN = "sn";
    private static final String COL_AUXPTY = "auxpty";
    private static final String KEY_mainMapping = "propmapping";
    private static final String KEY_moveEntity = "bd_snmovetrack";
    private static final String ROW = "row";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_METADATA = "metadata";
    private static final String KEY_METADATAKEY = "metadatakey";
    private static final String KEY_CURRENTMETADATA = "currentmetadata";
    private static final String KEY_CURRENTMETADATAKEY = "currentmetadatakey";

    public void afterCreateNewData(EventObject e) {
        this.getView().getParentView().getFormShowParameter().getCustomParams();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONArray metaContext = (JSONArray)formShowParameter.getCustomParam("MetaContext");
        JSONObject metaData = metaContext.getJSONArray(0).getJSONObject(0);
        String currentNumber = metaData.getString("Key");
        Map ob = this.getOriParameter();
        this.buildEntryFieldCombo();
        SnParameter param = new SnParameter();
        if (!ObjectUtils.isEmpty((Object)ob)) {
            String json = SerializationUtils.toJsonString((Object)ob);
            param = (SnParameter)SerializationUtils.fromJsonString((String)json, SnParameter.class);
            this.showMappingParam(KEY_mainMapping, KEY_moveEntity, currentNumber, param.getSnFields());
            this.setDefaultEntryProp(param);
        }
        this.showMappingParam(KEY_mainMapping, KEY_moveEntity, currentNumber, param.getSnFields());
    }

    private void showMappingParam(String targetKey, String targetEntity, String currentNumber, List<Map<String, Object>> paramList) {
        String pageId = Uuid16.create().toString();
        this.getPageCache().put(targetKey, pageId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("scmc_rule_snmapping");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(targetKey);
        parameter.setPageId(pageId);
        parameter.setCustomParam("entitynumber", (Object)targetEntity);
        parameter.setCustomParam("currentnumber", (Object)currentNumber);
        parameter.setCustomParam("datalist", paramList);
        this.getView().showForm(parameter);
    }

    private void buildEntryFieldCombo() {
        List formContext = this.getFormContext();
        ArrayList<ComboItem> operateParamItems = new ArrayList<ComboItem>();
        ArrayList<ComboItem> snoperateParamItems = new ArrayList<ComboItem>();
        ArrayList<ComboItem> materialParamItems = new ArrayList<ComboItem>();
        ArrayList<ComboItem> snParamItems = new ArrayList<ComboItem>();
        ArrayList<ComboItem> auxptyParamItems = new ArrayList<ComboItem>();
        for (Map field : (List)formContext.get(0)) {
            String fieldType;
            switch (fieldType = field.get("_Type_").toString()) {
                case "EntryEntity": {
                    operateParamItems.add(new ComboItem(new LocaleString(field.get("Name").toString()), field.get("Key").toString()));
                    break;
                }
                case "SubEntryEntity": {
                    snoperateParamItems.add(new ComboItem(new LocaleString(field.get("Name").toString()), field.get("Key").toString()));
                    break;
                }
                case "MaterielField": {
                    materialParamItems.add(new ComboItem(new LocaleString(field.get("Name").toString()), field.get("Key").toString()));
                    break;
                }
                case "TextField": {
                    snParamItems.add(new ComboItem(new LocaleString(field.get("Name").toString()), field.get("Key").toString()));
                    break;
                }
                case "FlexField": {
                    auxptyParamItems.add(new ComboItem(new LocaleString(field.get("Name").toString()), field.get("Key").toString()));
                    break;
                }
            }
        }
        this.setItemData(COL_ENTRYFIELD, operateParamItems);
        this.setItemData(COL_SNENTRYFIELD, snoperateParamItems);
        this.setItemData(COL_MATERIAL, materialParamItems);
        this.setItemData(COL_SN, snParamItems);
        this.setItemData(COL_AUXPTY, auxptyParamItems);
    }

    private void setItemData(String key, List<ComboItem> ParamItems) {
        if (ParamItems.size() > 0) {
            ComboEdit combo = (ComboEdit)this.getControl(key);
            combo.setComboItems(ParamItems);
            this.getModel().setValue(key, (Object)ParamItems.get(0).getValue());
        }
    }

    private void setDefaultEntryProp(SnParameter param) {
        if (StringUtils.isNotEmpty((CharSequence)param.getMainEntryKey())) {
            this.getModel().setValue(COL_ENTRYFIELD, (Object)param.getMainEntryKey());
            this.getModel().setValue(COL_SNENTRYFIELD, (Object)param.getSnEntryKey());
            this.getModel().setValue(COL_MATERIAL, (Object)param.getMaterial());
            this.getModel().setValue(COL_SN, (Object)param.getSn());
            this.getModel().setValue(COL_AUXPTY, (Object)param.getAuxpty());
        }
    }

    public String getParameter() {
        SnParameter parameter = new SnParameter();
        parameter.setSnFields(this.getPropMapping(KEY_mainMapping));
        parameter.setMainEntryKey(this.getModel().getDataEntity().getString(COL_ENTRYFIELD));
        parameter.setSnEntryKey(this.getModel().getDataEntity().getString(COL_SNENTRYFIELD));
        parameter.setMaterial(this.getModel().getDataEntity().getString(COL_MATERIAL));
        parameter.setSn(this.getModel().getDataEntity().getString(COL_SN));
        parameter.setAuxpty(this.getModel().getDataEntity().getString(COL_AUXPTY));
        return SerializationUtils.toJsonString((Object)parameter);
    }

    private List<Map<String, Object>> getPropMapping(String pageIdKey) {
        String pageId = this.getPageCache().get(pageIdKey);
        IDataModel model = this.getView().getView(pageId).getModel();
        ArrayList<Map<String, Object>> Fields = new ArrayList<Map<String, Object>>();
        int entryRowCount = model.getEntryRowCount(KEY_ENTRYENTITY);
        if (entryRowCount > 0) {
            for (int i = 0; i < entryRowCount; ++i) {
                Object curNumber = model.getValue(KEY_CURRENTMETADATAKEY, i);
                if (!StringUtils.isNotBlank((Object)curNumber)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(ROW, i);
                map.put(KEY_METADATA, model.getValue(KEY_METADATA, i));
                map.put(KEY_METADATAKEY, model.getValue(KEY_METADATAKEY, i));
                map.put(KEY_CURRENTMETADATA, model.getValue(KEY_CURRENTMETADATA, i));
                map.put(KEY_CURRENTMETADATAKEY, curNumber);
                Fields.add(map);
            }
        }
        return Fields;
    }
}

