/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.plugin.func;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;

public class FuncGetSettleRelationValueEdit
extends AbstractFuncParamPlugIn {
    private static final String ENTITY_SETTLE_RELATION = "ism_settlerelations";
    private static final String RELATION_FIELD = "relationfield";
    private static final String RELATION_FIELD_VALUE = "relationfieldvalue";
    private static final String FIELD_LOCATION = "fieldlocation";
    private static final String FIELD_LOCATION_HEAD = "0";
    private static final String FIELD_LOCATION_ENTRY = "1";
    private static final String DEFINE_PATH = "definepath";
    private static final String RELATION_FIELD_CB = "relationfieldCloseCallBack";
    private static final String[] fields = new String[]{"bulerelation", "modifier", "creator", "materialgroupstand", "materialgroup", "tooutgenerateplan", "demandgenerateplan", "suppliergenerateplan", "interorgsettlerule"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{DEFINE_PATH});
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{RELATION_FIELD});
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        if (RELATION_FIELD.equals(control.getKey())) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ENTITY_SETTLE_RELATION);
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(entityType, (HashSet)null, BasedataProp.class);
            parameter.setIncludePKField(true);
            TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
            this.filterField(srcBillNode, fields);
            this.showSelectFieldForm(srcBillNode, RELATION_FIELD_CB);
        }
    }

    private void filterField(TreeNode srcBillNode, String ... filterKey) {
        if (filterKey == null || filterKey.length == 0) {
            return;
        }
        HashSet filters = new HashSet(filterKey.length);
        Collections.addAll(filters, filterKey);
        List children = srcBillNode.getChildren();
        for (TreeNode treeNode : children) {
            List subchildren = treeNode.getChildren();
            Iterator iterator = subchildren.iterator();
            while (iterator.hasNext()) {
                TreeNode subchild = (TreeNode)iterator.next();
                String id = subchild.getId();
                if (!filters.contains(id)) continue;
                iterator.remove();
            }
        }
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (RELATION_FIELD_CB.equals(e.getActionId())) {
            this.closeRelationFieldBack(e);
        }
    }

    private void closeRelationFieldBack(ClosedCallBackEvent e) {
        String returnData = (String)e.getReturnData();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ENTITY_SETTLE_RELATION);
        IDataEntityProperty findProperty = entityType.findProperty(returnData);
        if (findProperty == null || !(findProperty instanceof BasedataProp)) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue(RELATION_FIELD, (Object)findProperty.getDisplayName().getLocaleValue());
        model.setValue(RELATION_FIELD_VALUE, (Object)returnData);
        IDataEntityType parent = findProperty.getParent();
        if (parent != null && "settlerelationdetail".equals(parent.getName())) {
            model.setValue(FIELD_LOCATION, (Object)FIELD_LOCATION_ENTRY);
            this.getView().setVisible(Boolean.TRUE, new String[]{DEFINE_PATH});
        } else {
            model.setValue(FIELD_LOCATION, (Object)FIELD_LOCATION_HEAD);
            this.getView().setVisible(Boolean.FALSE, new String[]{DEFINE_PATH});
        }
        model.setValue(DEFINE_PATH, null);
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        IDataModel model = this.getModel();
        String relationField = (String)model.getValue(RELATION_FIELD_VALUE);
        String fieldLocation = (String)model.getValue(FIELD_LOCATION);
        String path = (String)model.getValue(DEFINE_PATH);
        if (StringUtils.isBlank((CharSequence)relationField)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u8def\u5f84\u5b57\u6bb5\u3002", (String)"PlsSelectRelationField", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return false;
        }
        if (FIELD_LOCATION_ENTRY.equals(fieldLocation) && StringUtils.isEmpty((CharSequence)path)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f4d\u7f6e\u3002", (String)"PlsSelectRelationFieldLoc", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public String getSetting() {
        IDataModel model = this.getModel();
        String relationField = (String)model.getValue(RELATION_FIELD_VALUE);
        String fieldLocation = (String)model.getValue(FIELD_LOCATION);
        String path = (String)model.getValue(DEFINE_PATH);
        String setting = String.format("%s('%s', '%s', '%s')", this.getFuncId(), relationField, fieldLocation, path);
        return setting;
    }
}

