/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.plugin.operation;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.CustOpParameterPlugin;
import kd.bos.metadata.entity.operation.CustOperationParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;

public class QuoteParamPlugin
extends CustOpParameterPlugin {
    private static final String FORMID_SELECTFIELD = "botp_selectfield";
    private static final String TREENODES = "treenodes";
    private static final String PK_ORGSIGN_NAME = "orgsignname";
    private static final String PK_ORG_SIGN = "orgsign";
    private static final String PK_PLUGINS = "plugins";
    private static final String SELECT_PLUGINS = "selectServicePlugins";
    private static final String IS_TRI_LISTENER = "islistener";
    private static final String PK_PRICEPOSITION = "priceposition";
    private static final String HEAD_PRICEPOSITION = "headposition";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ComboEdit edit = (ComboEdit)this.getView().getControl(PK_PRICEPOSITION);
        ArrayList<String[]> list = new ArrayList<String[]>();
        String headerTitle = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"QuoteParamPlugin_3", (String)"bos-ext-scmc", (Object[])new Object[0]);
        String[] headComboValue = new String[]{headerTitle, HEAD_PRICEPOSITION};
        list.add(headComboValue);
        MainEntityType mainEntityType = this.getCurrentEntity();
        Map allEntities = mainEntityType.getAllEntities();
        allEntities.forEach((k, v) -> {
            if (v instanceof EntryType && !(v instanceof LinkEntryType) || v instanceof SubEntryType) {
                String[] comboValue = new String[]{v.getDisplayName().getLocaleValue(), v.getName()};
                list.add(comboValue);
            }
        });
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(list.size());
        list.forEach(new DynamicEnum(items));
        edit.setComboItems(items);
    }

    public boolean check(StringBuilder msgBuilder) {
        boolean pass = true;
        String priceSignName = (String)this.getModel().getValue(PK_ORGSIGN_NAME);
        if (StringUtils.isBlank((CharSequence)priceSignName)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u7ec4\u7ec7\u3002", (String)"QuoteParamPlugin_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
            pass = false;
            return pass;
        }
        String pricePositionStr = (String)this.getModel().getValue(PK_PRICEPOSITION);
        if (StringUtils.isNotEmpty((CharSequence)pricePositionStr) && StringUtils.isNotEmpty((CharSequence)PK_ORG_SIGN)) {
            String[] pricePositionSplit;
            String priceOrgSign = (String)this.getModel().getValue(PK_ORG_SIGN);
            MainEntityType type = this.getCurrentEntity();
            String orgPosition = HEAD_PRICEPOSITION;
            String[] orgDevideFiled = priceOrgSign.split("\\.");
            if (orgDevideFiled.length > 2) {
                String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u5927\u4e8e2\u3002", (String)"QuoteParamPlugin_1", (String)"bos-ext-scmc", (Object[])new Object[0]);
                msgBuilder.append(message);
                pass = false;
            } else if (orgDevideFiled.length == 2) {
                String orgSign = orgDevideFiled[orgDevideFiled.length - 1];
                IDataEntityProperty orgProperty = (IDataEntityProperty)type.getAllFields().get(orgSign);
                if (orgProperty != null && orgProperty.getParent() instanceof EntryType) {
                    orgPosition = orgDevideFiled[orgDevideFiled.length - 2];
                }
            }
            for (String pricePosition : pricePositionSplit = pricePositionStr.split("\\,")) {
                if (!StringUtils.isNotEmpty((CharSequence)pricePosition) || HEAD_PRICEPOSITION.equals(pricePosition) || orgPosition.equals(HEAD_PRICEPOSITION) || orgPosition.equals(pricePosition)) continue;
                String entryPricePositionName = type.getAllEntities().get(pricePosition) != null ? ((EntityType)type.getAllEntities().get(pricePosition)).getDisplayName().getLocaleValue() : "";
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u7ec4\u7ec7\u4e0e\u53d6\u4ef7\u4f4d\u7f6e\u201c%s\u201d\u5b58\u5728\u4e0d\u5339\u914d\u3002", (String)"QuoteParamPlugin_2", (String)"bos-ext-scmc", (Object[])new Object[0]), entryPricePositionName));
                pass = false;
            }
        }
        return pass;
    }

    protected void showParameter(CustOperationParameter v) {
        Map mapParam = new HashMap();
        String paramValue = v.getParameter();
        if (StringUtils.isNotBlank((CharSequence)paramValue)) {
            mapParam = (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
        }
        Map settingParam = (Map)mapParam.get("settingparam");
        IDataModel model = this.getModel();
        if (settingParam != null && settingParam.size() > 0) {
            model.setValue(PK_PLUGINS, settingParam.get(PK_PLUGINS));
            model.setValue(PK_ORGSIGN_NAME, settingParam.get(PK_ORGSIGN_NAME));
            model.setValue(PK_ORG_SIGN, settingParam.get(PK_ORG_SIGN));
            model.setValue(IS_TRI_LISTENER, settingParam.get(IS_TRI_LISTENER));
            model.setValue(PK_PRICEPOSITION, settingParam.get(PK_PRICEPOSITION));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getView().getControl(PK_PLUGINS) != null) {
            this.addClickListeners(new String[]{PK_PLUGINS});
        }
        if (this.getView().getControl(PK_ORGSIGN_NAME) != null) {
            this.addClickListeners(new String[]{PK_ORGSIGN_NAME});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "plugins": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("ide_plugins");
                Object plugins = this.getModel().getValue(PK_PLUGINS);
                parameter.setCustomParam("value", plugins != null && !StringUtils.isBlank((CharSequence)plugins.toString()) ? SerializationUtils.fromJsonStringToList((String)plugins.toString(), Map.class) : new ArrayList());
                parameter.setCustomParam("formId", this.getView().getFormShowParameter().getCustomParam("formId"));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_PLUGINS));
                this.getView().showForm(parameter);
                break;
            }
            case "orgsignname": {
                PropTreeBuildOption o2 = new PropTreeBuildOption(null, OrgProp.class);
                this.showBillTree(o2, PK_ORGSIGN_NAME);
            }
        }
    }

    private void showBillTree(PropTreeBuildOption option, String callBackFlag) {
        MainEntityType EntityType2 = this.getCurrentEntity();
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)EntityType2, (PropTreeBuildOption)option);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        showParameter.getCustomParams().put(TREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackFlag));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private MainEntityType getCurrentEntity() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        String id = entityMetadata.getRootEntity().getId();
        String masterId = MetadataDao.getMasterId((String)id);
        String currentNumber = MetadataDao.getNumberById((String)(StringUtils.isBlank((CharSequence)masterId) ? id : masterId));
        return MetadataServiceHelper.getDataEntityType((String)currentNumber);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            String actionId;
            switch (actionId = e.getActionId()) {
                case "selectServicePlugins": {
                    Map ret = (Map)e.getReturnData();
                    List plugins = (List)ret.get("value");
                    this.getModel().setValue(PK_PLUGINS, (Object)SerializationUtils.toJsonString((Object)plugins));
                    break;
                }
                case "orgsignname": {
                    Object returnData1 = e.getReturnData();
                    this.setCallBackResult(returnData1, PK_ORGSIGN_NAME);
                }
            }
        }
    }

    private void setCallBackResult(Object returnData, String propertyFlag) {
        String[] fieldIds;
        String parentName;
        String fieldId = returnData.toString();
        MainEntityType EntityType2 = this.getCurrentEntity();
        String srcBillId = EntityType2.getAppId();
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)EntityType2, (String)fieldId);
        String[] split = fieldId.split("\\.");
        String tempFieldId = split[0];
        IDataEntityProperty findProperty = EntityType2.findProperty(tempFieldId);
        if (findProperty != null && !srcBillId.equals(parentName = findProperty.getParent().getName())) {
            fieldId = parentName.concat(".").concat(fieldId);
        }
        if ((fieldIds = fieldId.split("\\.")) != null && fieldIds.length > 4) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c0f\u4e8e\u56db\u7ea7\u7684\u5b57\u6bb5", (String)"QuoteSchemePlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (propertyFlag) {
            case "orgsignname": {
                this.getModel().setValue(PK_ORGSIGN_NAME, (Object)fieldCaption);
                this.getModel().setValue(PK_ORG_SIGN, (Object)fieldId);
            }
        }
    }

    protected void returnParameter(CustOperationParameter v) {
        HashMap mapParam = new HashMap();
        IDataModel model = this.getModel();
        HashMap<String, Object> settingParam = new HashMap<String, Object>();
        settingParam.put(PK_PLUGINS, model.getValue(PK_PLUGINS));
        settingParam.put(PK_ORGSIGN_NAME, model.getValue(PK_ORGSIGN_NAME));
        settingParam.put(PK_ORG_SIGN, model.getValue(PK_ORG_SIGN));
        settingParam.put(IS_TRI_LISTENER, model.getValue(IS_TRI_LISTENER));
        settingParam.put(PK_PRICEPOSITION, model.getValue(PK_PRICEPOSITION));
        mapParam.put("settingparam", settingParam);
        String paramValue = SerializationUtils.toJsonString(mapParam);
        v.setParameter(paramValue);
    }

    private static class DynamicEnum
    implements Consumer<String[]> {
        private List<ComboItem> comboItems;

        public DynamicEnum(List<ComboItem> items) {
            this.comboItems = items;
        }

        @Override
        public void accept(String[] t) {
            String key = t[0];
            String value = t[1];
            LocaleString caption = new LocaleString(RequestContext.get().getLang().toString(), key);
            this.comboItems.add(new ComboItem(caption, value));
        }
    }
}

