/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.reservation.bizrule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.ext.scmc.reservation.validation.ReserveOperateErrorInfo;
import kd.bos.ext.scmc.reservation.validation.ReserveValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class AutoReserve
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(AutoReserve.class);
    private OperationResult result;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        if (datas == null || datas.length == 0) {
            return;
        }
        List<Object> ids = this.getIds(datas);
        if (ids.isEmpty()) {
            this.result = new OperationResult();
            return;
        }
        String name = datas[0].getDataEntityType().getName();
        String operationKey = e.getOperationKey();
        QFilter fs = new QFilter("group.number", "=", (Object)"MpsAutoReserve").and(new QFilter("billobject", "=", (Object)name)).and(new QFilter("enable", "=", (Object)"1").and(new QFilter("billoperation", "like", (Object)("%," + operationKey + ",%"))));
        boolean exists = QueryServiceHelper.exists((String)"msmod_reserve_service_cfg", (QFilter[])fs.toArray());
        if (exists) {
            logger.info("\u5f53\u524d\u5355\u636e\u5b9e\u4f53:" + name + "\uff0c\u64cd\u4f5c\uff1a" + operationKey + "\u5b58\u5728\u542f\u7528\u7684\u65b0\u81ea\u52a8\u9884\u7559\u670d\u52a1\uff0c\u4e0d\u6267\u884c\u5e93\u5b58\u81ea\u52a8\u9884\u7559\uff08\u65e7\uff09\u670d\u52a1");
            this.result = new OperationResult();
            return;
        }
        DynamicObject requestBill = datas[0];
        boolean isFromDataBase = requestBill.getDataEntityState().getFromDatabase();
        this.result = "submit".equals(e.getOperationKey()) && !isFromDataBase ? (OperationResult)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"ReserveService", (String)"autoReserveByDynamicObject", (Object[])new Object[]{name, requestBill}) : (OperationResult)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"ReserveService", (String)"autoReserveByIds", (Object[])new Object[]{name, ids});
    }

    private boolean checkIsModified(DynamicObject requestBill) {
        List<String> ignoreColumns = Arrays.asList("billstatus", "auditor", "auditdate", "auditor_id", "modifytime", "lastupdateuser", "lastupdatetime");
        long dirtySize = requestBill.getDataEntityState().GetDirtyProperties().stream().filter(dirtyProp -> !ignoreColumns.contains(dirtyProp.getName())).count();
        return dirtySize > 0L || requestBill.getDataEntityState().getRemovedItems() != false;
    }

    private List<Object> getIds(DynamicObject[] datas) {
        ArrayList<Object> ids = new ArrayList<Object>(datas.length);
        for (DynamicObject data : datas) {
            ids.add(data.getPkValue());
        }
        return ids;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (this.result == null || StringUtils.isBlank((CharSequence)this.result.getMessage())) {
            return;
        }
        OperationResult op = this.getOperationResult();
        if (op.getSuccessPkIds().size() == 1 && op.getAllErrorOrValidateInfo().isEmpty()) {
            op.setMessage(this.result.getMessage());
            op.setShowMessage(true);
        } else if (!op.getSuccessPkIds().isEmpty()) {
            ReserveValidateResult reserveValidateResult = new ReserveValidateResult();
            ReserveOperateErrorInfo errInfo = new ReserveOperateErrorInfo();
            errInfo.setLevel(ErrorLevel.Error);
            errInfo.setMessage(this.result.getMessage());
            reserveValidateResult.addErrorInfo(errInfo);
            op.getValidateResult().addValidateError("autoReserve", (ValidateResult)reserveValidateResult);
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        DynamicObject[] datas = e.getDataEntitys();
        if (datas == null || datas.length == 0) {
            return;
        }
        List<Object> ids = this.getIds(datas);
        if (ids.isEmpty()) {
            return;
        }
        String name = datas[0].getDataEntityType().getName();
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"ReserveService", (String)"unAutoReserve", (Object[])new Object[]{name, ids});
    }
}

