/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.reservation.mscommon;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.scmc.reservation.validation.ReserveOperateErrorInfo;
import kd.bos.ext.scmc.reservation.validation.ReserveValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class AutoReserve
extends AbstractOpBizRuleAction {
    private OperationResult result;
    private Log log = LogFactory.getLog(AutoReserve.class);
    private boolean isFromListForm = false;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        this.isFromListForm = true;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        boolean isIgnore = "true".equalsIgnoreCase(this.operateOption.getVariableValue("ismoperate", "false"));
        if (isIgnore) {
            return;
        }
        final DynamicObject[] dataArray = e.getDataEntities();
        if (dataArray == null || dataArray.length == 0) {
            return;
        }
        final String billName = dataArray[0].getDataEntityType().getName();
        String reserveAllParam = this.getOption().getVariableValue("isReserveAll", "");
        HashMap<String, String> cusParams = new HashMap<String, String>(16);
        if (StringUtils.isNotEmpty((CharSequence)reserveAllParam)) {
            cusParams.put("isReserveAll", reserveAllParam);
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onRollbacked() {
                if (dataArray == null || dataArray.length == 0) {
                    return;
                }
                List ids = AutoReserve.this.getIds(dataArray);
                DynamicObject record = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"buildReleaseOpRecord", (Object[])new Object[]{billName, JSON.toJSONString((Object)ids), "UNAUTORE"});
                if (record != null) {
                    long recordId = record.getLong("id");
                    DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"unAutoReserve", (Object[])new Object[]{recordId, billName, ids, null});
                }
            }
        });
        this.result = cusParams.isEmpty() ? (OperationResult)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"dealAuToReserve", (Object[])new Object[]{billName, dataArray, this.isFromListForm, e.getOperationKey()}) : (OperationResult)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"dealAuToReserve", (Object[])new Object[]{billName, dataArray, this.isFromListForm, e.getOperationKey(), cusParams});
    }

    private List<Object> getIds(DynamicObject[] datas) {
        ArrayList<Object> ids = new ArrayList<Object>(datas.length);
        for (DynamicObject data : datas) {
            ids.add(data.getPkValue());
        }
        return ids;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        OperationResult op;
        super.afterExecuteOperationTransaction(e);
        if (this.result == null || StringUtils.isBlank((CharSequence)this.result.getMessage())) {
            return;
        }
        Map customData = this.result.getCustomData();
        if (customData != null && !customData.isEmpty()) {
            this.getOperationResult().getCustomData().putAll(customData);
        }
        if ((op = this.getOperationResult()).getSuccessPkIds().size() == 1 && op.getAllErrorOrValidateInfo().isEmpty()) {
            op.setMessage(this.result.getMessage());
            op.setShowMessage(true);
        } else {
            ReserveValidateResult reserveValidateResult = new ReserveValidateResult();
            ReserveOperateErrorInfo errInfo = new ReserveOperateErrorInfo();
            errInfo.setLevel(ErrorLevel.Info);
            errInfo.setMessage(this.result.getMessage());
            reserveValidateResult.addErrorInfo(errInfo);
            op.getAllErrorInfo().add(errInfo);
        }
    }
}

