/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.reservation.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class AutoReserveValidate
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(AutoReserveValidate.class);

    public void validate() {
        this.checkSrcReserve();
    }

    private void checkSrcReserve() {
        int len = this.dataEntities.length;
        Long[] billIds = new Long[len];
        for (int i = 0; i < len; ++i) {
            billIds[i] = (Long)this.dataEntities[i].getBillPkId();
        }
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        Map<Long, Set<Long>> srcIdsMap = this.getSrcBotpIds(billIds);
        for (Set<Long> srcIds : srcIdsMap.values()) {
            srcBillIds.addAll(srcIds);
        }
        if (srcBillIds.isEmpty()) {
            return;
        }
        QFilter reF = new QFilter("bill_id", "in", srcBillIds);
        DataSet reserveRecords = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ":checkSrcReserve"), (String)"msmod_reserve_record", (String)"bill_id", (QFilter[])reF.toArray(), null);
        HashSet<Long> reserveBillIds = new HashSet<Long>(16);
        while (reserveRecords.hasNext()) {
            Row row = reserveRecords.next();
            reserveBillIds.add(row.getLong("bill_id"));
        }
        if (reserveBillIds.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object pkId = dataEntity.getBillPkId();
            Set<Long> srcIds = srcIdsMap.get(pkId);
            if (srcIds == null || srcIds.isEmpty()) continue;
            log.info("\u6765\u6e90\u5355\u636eid\u4e3a\uff1a" + srcIds);
            log.info("\u9884\u7559\u8bb0\u5f55\u5355\u636eid\u4e3a\uff1a" + reserveBillIds);
            if (!srcIds.removeAll(reserveBillIds)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e\u5df2\u5b58\u5728\u9884\u7559\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u7ee7\u7eed\u9884\u7559\u3002", (String)"AutoReserveValidate_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }

    private Map<Long, Set<Long>> getSrcBotpIds(Long[] billIds) {
        HashMap<Long, Set<Long>> srcBillIds = new HashMap<Long, Set<Long>>(16);
        Map linkUpNodes = BFTrackerServiceHelper.loadBillLinkUpNodes((String)this.entityKey, (Long[])billIds, (boolean)false);
        for (Map.Entry UpNode : linkUpNodes.entrySet()) {
            List srcNodes = ((BFRowLinkUpNode)UpNode.getValue()).findAllSourceNodes();
            HashSet<Long> ids = new HashSet<Long>(srcNodes.size());
            for (BFRowLinkUpNode row : srcNodes) {
                ids.add(row.getRowId().getBillId());
            }
            srcBillIds.put((Long)UpNode.getKey(), (Set<Long>)ids);
        }
        return srcBillIds;
    }
}

