/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.threadpool;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.ext.scmc.threadpool.SCMCRejectedException;
import kd.bos.ext.scmc.threadpool.SCMCRejectedPolicy;
import kd.bos.ext.scmc.threadpool.SCMCTaskType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.bos.unifiedthreadpool.tasktype.TaskType;

public class SCMCThread {
    private static final Log LOG = LogFactory.getLog(SCMCThread.class);
    private static final ThreadExecutorService POOL;
    private SCMCTaskType taskType;
    private SCMCRejectedPolicy policy;
    private RequestContext rc;
    private OperationContext oc;

    public static SCMCThread getDefault() {
        return SCMCThread.get(null, null);
    }

    public static SCMCThread getDefault(SCMCRejectedPolicy policy) {
        return SCMCThread.get(null, policy);
    }

    public static SCMCThread get(SCMCTaskType taskType) {
        return SCMCThread.get(taskType, null);
    }

    public static SCMCThread get(SCMCTaskType taskType, SCMCRejectedPolicy policy) {
        SCMCThread scmcThread = new SCMCThread();
        scmcThread.taskType = taskType == null ? SCMCTaskType.SCMC_COMMON : taskType;
        scmcThread.policy = policy;
        scmcThread.oc = OperationContext.get();
        return scmcThread;
    }

    public SCMCThread setCtx(RequestContext rc, OperationContext oc) {
        this.oc = oc;
        this.rc = rc;
        return this;
    }

    private SCMCThread() {
    }

    public void execute(Runnable run) {
        try {
            POOL.execute(run, this.taskType.getName(), this.rc, this.oc == null ? null : this.oc.copy());
        }
        catch (SCMCRejectedException exc) {
            SCMCRejectedPolicy currentPolicy = this.policy == null ? SCMCRejectedPolicy.CALLER_RUNS : this.policy;
            LOG.warn("SCMCThread executeRejected policy=" + currentPolicy.getClass().getName() + ", taskType=" + this.taskType.getName());
            currentPolicy.executeRejected(run, exc);
        }
    }

    public <T> Future<T> submit(Callable<T> call) {
        try {
            return POOL.submit(call, this.taskType.getName(), this.rc, this.oc == null ? null : this.oc.copy());
        }
        catch (SCMCRejectedException exc) {
            SCMCRejectedPolicy currentPolicy = this.policy == null ? SCMCRejectedPolicy.CALLER_RUNS : this.policy;
            LOG.warn("SCMCThread submitRejected policy=" + currentPolicy.getClass().getName() + ", taskType=" + this.taskType.getName());
            return currentPolicy.submitRejected(call, exc);
        }
    }

    static {
        ThreadPoolStrategy tps = ThreadPoolStrategyFactory.create();
        SCMCTaskType[] scmcTypes = SCMCTaskType.values();
        ArrayList<TaskType> taskTypes = new ArrayList<TaskType>(scmcTypes.length);
        for (SCMCTaskType scmcType : scmcTypes) {
            TaskType taskType = scmcType.getTaskType();
            taskTypes.add(taskType);
        }
        tps.register(taskTypes);
        tps.setMaxThreadNum(150);
        tps.setMinThreadNum(10);
        tps.setOverflowThreadNum(20);
        tps.setThreadIdeMinutes(1L);
        tps.setRejectedExecutionHandler((run, executor) -> {
            throw new SCMCRejectedException(executor, run);
        });
        POOL = ThreadPoolFactory.create((String)"scmc", (String)"scmc-threadpool", (ThreadPoolStrategy)tps);
    }
}

