/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class BillExistValidator
extends AbstractValidator {
    public void validate() {
        String billType = null;
        ArrayList<Long> billIds = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Long id = dataEntity.getDataEntity().getLong("id");
            if (billType == null) {
                billType = dataEntity.getDataEntity().getDynamicObjectType().getName();
            }
            billIds.add(id);
        }
        Map findDirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills(billType, (Long[])billIds.toArray(new Long[billIds.size()]));
        if (findDirtTargetBills.isEmpty()) {
            return;
        }
        HashMap<Long, HashSet<Long>> pushedBills = new HashMap<Long, HashSet<Long>>(16);
        for (List targetBill : findDirtTargetBills.values()) {
            for (BFRow bfRow : targetBill) {
                BFRowId id = bfRow.getId();
                Long tgtTableId = id.getTableId();
                HashSet<Long> hashSet = (HashSet<Long>)pushedBills.get(tgtTableId);
                if (hashSet == null) {
                    hashSet = new HashSet<Long>(16);
                    pushedBills.put(tgtTableId, hashSet);
                }
                hashSet.add(id.getBillId());
            }
        }
        Set<Long> filterBills = this.getFilterBillIds(pushedBills);
        block3: for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Long billId = (Long)dataEntity.getBillPkId();
            List dowBFRows = (List)findDirtTargetBills.get(billId);
            if (dowBFRows == null) continue;
            for (BFRow bfRow : dowBFRows) {
                Long dowBillId = bfRow.getId().getBillId();
                if (filterBills.contains(dowBillId)) continue;
                this.addErrorMessage(dataEntity, this.getErroMessage(this.getOperationName()));
                continue block3;
            }
        }
    }

    private String getErroMessage(String opName) {
        return String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd%s\u3002", (String)"BOSEXT-E-358562", (String)"bos-ext-scmc", (Object[])new Object[0]), opName);
    }

    private Set<Long> getFilterBillIds(Map<Long, HashSet<Long>> pushedBills) {
        Map<String, QFilter> filter = this.getConfigBillEntityFilter();
        HashSet<Long> filterBills = new HashSet<Long>(16);
        ConvertDataService service = new ConvertDataService();
        for (Map.Entry<Long, HashSet<Long>> map : pushedBills.entrySet()) {
            TableDefine tableDefine = service.loadTableDefine(map.getKey());
            if (tableDefine == null) continue;
            String entity = tableDefine.getEntityKey();
            QFilter qFilter = filter.get(entity);
            if (qFilter == null) {
                if (!filter.containsKey(entity)) continue;
                filterBills.addAll((Collection<Long>)map.getValue());
                continue;
            }
            DynamicObjectCollection filterBillIds = this.getBillIdObjs(entity, map.getValue(), qFilter);
            for (DynamicObject filterBillIdObj : filterBillIds) {
                filterBills.add(filterBillIdObj.getLong("id"));
            }
        }
        return filterBills;
    }

    private DynamicObjectCollection getBillIdObjs(String entity, HashSet<Long> billIds, QFilter qFilter) {
        DynamicObjectCollection filterBillIds = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds), qFilter});
        return filterBillIds;
    }

    private Map<String, QFilter> getConfigBillEntityFilter() {
        HashMap<String, QFilter> filter = new HashMap<String, QFilter>();
        String paramValue = (String)this.getValidation().get("parameter");
        List param = Collections.emptyList();
        if (StringUtils.isNotBlank((CharSequence)paramValue)) {
            param = (List)SerializationUtils.fromJsonString((String)paramValue, List.class);
        }
        for (Map map : param) {
            String number = (String)map.get("billObjEntityNumber");
            String filterStr = (String)map.get("filterstr_tag");
            if (StringUtils.isNotEmpty((CharSequence)filterStr)) {
                QFilter expression = this.parseToQFilter(number, filterStr);
                filter.put(number, expression);
                continue;
            }
            filter.put(number, null);
        }
        return filter;
    }

    private QFilter parseToQFilter(String billEntity, String filterStr) {
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billEntity), filterCondition);
        fb.buildFilter();
        return fb.getQFilter();
    }
}

