/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.validation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ReserveSupBillValidate
extends AbstractValidator {
    private static final String IS_IGNORE_TASK_VALIDATE = "isIgnoreTaskValidate";

    public void validate() {
        OperateOption option = this.validateContext.getOption();
        boolean isIgnore = "true".equalsIgnoreCase(option.getVariableValue(IS_IGNORE_TASK_VALIDATE, "false"));
        if (isIgnore) {
            return;
        }
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        String operationName = this.getOperationName();
        ExtendedDataEntity[] datas = this.getDataEntities();
        ArrayList<Long> idList = new ArrayList<Long>(this.dataEntities.length);
        String billFormId = "";
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            idList.add(bill.getLong("id"));
        }
        this.isHasReserveRecord(datas, idList, operationName);
    }

    private void isHasReserveRecord(ExtendedDataEntity[] datas, List<Long> idList, String operationName) {
        QFilter qFilter = new QFilter("bal_id", "in", (Object)idList.toArray());
        qFilter.and(new QFilter("base_qty", "!=", (Object)BigDecimal.ZERO));
        DataSet reserveRecordDataSet = QueryServiceHelper.queryDataSet((String)ReserveSupBillValidate.class.getName(), (String)"msmod_reserve_record", (String)"bal_id,s_billnum", (QFilter[])qFilter.toArray(), null);
        HashMap<Long, String> billInfoMap = new HashMap<Long, String>(16);
        while (reserveRecordDataSet.hasNext()) {
            Row row = reserveRecordDataSet.next();
            billInfoMap.put(row.getLong("bal_id"), row.getString("s_billnum"));
        }
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            Long id = bill.getLong("id");
            if (!billInfoMap.containsKey(id)) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u88ab\u9884\u7559\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c%1$s\u64cd\u4f5c\u3002", (String)"ReserveSupBillValidate_0", (String)"bos-ext-scmc", (Object[])new Object[0]), operationName));
        }
    }
}

