/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.scmc.sn.helper.SerialNumberHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class SerialNumberSaveValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"SerialNumberSaveValidator", (String)"validate");){
            int length = this.dataEntities.length;
            HashMap<Object, ExtendedDataEntity> billIdToDataEntityMap = new HashMap<Object, ExtendedDataEntity>(length);
            ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(length);
            for (int dataEntityIndex = 0; dataEntityIndex < length; ++dataEntityIndex) {
                ExtendedDataEntity extendedDataEntity = this.dataEntities[dataEntityIndex];
                Object billId = extendedDataEntity.getBillPkId();
                billIdToDataEntityMap.put(billId, extendedDataEntity);
                bills.add(extendedDataEntity.getDataEntity());
            }
            Map<Object, List<String>> errorMessageData = SerialNumberHelper.validateCallSNService(bills, this.getOperateKey());
            for (Map.Entry<Object, List<String>> errorMessageEntry : errorMessageData.entrySet()) {
                Object billId = errorMessageEntry.getKey();
                ExtendedDataEntity errorDataEntity = (ExtendedDataEntity)billIdToDataEntityMap.get(billId);
                if (errorDataEntity == null) {
                    errorDataEntity = (ExtendedDataEntity)billIdToDataEntityMap.get(0L);
                }
                if (errorDataEntity == null) continue;
                List<String> errorMessages = errorMessageEntry.getValue();
                for (String errorMessage : errorMessages) {
                    this.addErrorMessage(errorDataEntity, errorMessage);
                }
            }
        }
    }
}

