/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.validation;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class WfingBillValidator
extends AbstractValidator {
    public static final String OPER_SETTLE = "wf";
    public static final String APP_NAME = "mpscmm";
    public static final String TRUE = "true";
    private static final Log logger = LogFactory.getLog(WfingBillValidator.class);

    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        OperateOption option = this.getOption();
        String writeOffCheck = option.getVariableValue("writeOffCheck", "");
        if (TRUE.equals(writeOffCheck)) {
            return;
        }
        MainEntityType entityType = (MainEntityType)this.dataEntities[0].getDataEntity().getDataEntityType();
        String billName = entityType.getName();
        IAppCache appCache = AppCache.get((String)"mpscmm-lockwf");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            String lockKey = billName + entity.getPkValue();
            String lockValue = (String)appCache.get(lockKey, String.class);
            logger.info("\u83b7\u53d6\u9501\u7684key:" + lockKey + "\uff0c\u7ed3\u679c\u4e3a:" + lockValue);
            if (!StringUtils.isNotEmpty((CharSequence)lockValue)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u6b63\u5728\u6838\u9500\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"WfingBillValidator_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }
}

