/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.mmc.cache.ManustrConfigCacheMrg;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ManustrConfigCache {
    public static final String ENTITY_MANUSTRCONFIG = "bd_manustrconfig";
    public static final String ENTITY_MANUSTRATEGYDIM = "bd_manustrategydim";
    public static final String FILEDMAPLIST = "filedMapList";
    public static final String DOMAINIDS = "domainIds";
    public static final String ALONEDEMANDTYPE = "alonedemandtype";
    public static final String ISCHECKSAVE = "ischecksave";

    private ManustrConfigCache() {
    }

    public static Map<String, Object> getManustrConfigFieldMap(String key) {
        String type = ManustrConfigCacheMrg.getManustrConfigBilltype();
        String result = ManustrConfigCacheMrg.getCache(type, key);
        Map<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)result) && !"DATA_LOADED".equals(result)) {
            map = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            return map;
        }
        if (StringUtils.isBlank((CharSequence)result)) {
            map = ManustrConfigCache.getManustrConfig(key, type);
            return map;
        }
        return map;
    }

    private static Map<String, Object> getManustrConfig(String billType, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        QFilter qf = new QFilter("status", "=", (Object)"C");
        QFilter qf1 = new QFilter("enable", "=", (Object)"1");
        QFilter qf2 = new QFilter("entryentity.billentity", "=", (Object)billType);
        ArrayList filedMapList = new ArrayList(2);
        ArrayList<String> billTypes = new ArrayList<String>();
        billTypes.add(billType);
        ArrayList<Long> domainIds = new ArrayList<Long>(2);
        Boolean ischecksave = Boolean.FALSE;
        String alonedemandtype = "";
        String selectfield = "id,entryentity.ischecksave,entryentity.alonedemandtype,entryentity.domain,entryentity.billentity,entryentity.subentryentity,subentryentity.dimension,subentryentity.field";
        DynamicObject manuStrConfig = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_MANUSTRCONFIG, (String)selectfield, (QFilter[])new QFilter[]{qf, qf1, qf2});
        if (manuStrConfig == null) {
            String billTypeId = MetadataDao.getIdByNumber((String)billType, (MetaCategory)MetaCategory.Form);
            Iterator dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)billTypeId, (String)"bos_formmeta", (String)"parentid");
            if (dynamicObject == null) {
                ManustrConfigCacheMrg.putCache(type, billType, "DATA_LOADED");
                return map;
            }
            String parentBillTypeId = dynamicObject.getString("parentid_id");
            String parentBillType = MetadataDao.getNumberById((String)parentBillTypeId);
            if (StringUtils.isBlank((CharSequence)parentBillType)) {
                ManustrConfigCacheMrg.putCache(type, billType, "DATA_LOADED");
                return map;
            }
            qf2 = new QFilter("entryentity.billentity", "=", (Object)parentBillType);
            manuStrConfig = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_MANUSTRCONFIG, (String)selectfield, (QFilter[])new QFilter[]{qf, qf1, qf2});
            if (manuStrConfig == null) {
                ManustrConfigCacheMrg.putCache(type, billType, "DATA_LOADED");
                return map;
            }
            billTypes.add(parentBillType);
        }
        DynamicObjectCollection entryEntity = manuStrConfig.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : entryEntity) {
            String dimesion;
            String billEntityName;
            DynamicObject billEntity = entryRow.getDynamicObject("billentity");
            if (billEntity == null || !billTypes.contains(billEntityName = billEntity.getPkValue().toString())) continue;
            if (entryRow.getBoolean(ISCHECKSAVE)) {
                ischecksave = Boolean.TRUE;
            }
            alonedemandtype = entryRow.getString(ALONEDEMANDTYPE);
            Long domainId = entryRow.getLong("domain.id");
            domainIds.add(domainId);
            DynamicObjectCollection subEntryEntity = entryRow.getDynamicObjectCollection("subentryentity");
            boolean isMatchDim = false;
            HashMap<String, String> filedMap = new HashMap<String, String>(8);
            for (DynamicObject subEntryRow : subEntryEntity) {
                dimesion = subEntryRow.getString("dimension.number");
                if (!"GZ009".equals(dimesion)) continue;
                isMatchDim = true;
            }
            if (!isMatchDim) continue;
            for (DynamicObject subEntryRow : subEntryEntity) {
                dimesion = subEntryRow.getString("dimension.number");
                filedMap.put(dimesion, subEntryRow.getString("field"));
            }
            filedMapList.add(filedMap);
        }
        if (filedMapList.isEmpty()) {
            ManustrConfigCacheMrg.putCache(type, billType, "DATA_LOADED");
        }
        map.put(FILEDMAPLIST, filedMapList);
        map.put(DOMAINIDS, domainIds);
        map.put(ALONEDEMANDTYPE, alonedemandtype);
        map.put(ISCHECKSAVE, ischecksave);
        String jsonString = SerializationUtils.toJsonString(map);
        ManustrConfigCacheMrg.putCache(type, billType, jsonString);
        return map;
    }
}

