/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.func;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class GetDefaultProcessroute
implements BOSUDFunction {
    private static final Log logger = LogFactory.getLog(GetDefaultProcessroute.class);
    private ExpressionContext expContext;
    private static final String ENTITYID_ROUTE = "pdm_route";

    public GetDefaultProcessroute() {
    }

    public GetDefaultProcessroute(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public String getName() {
        return "GetDefaultProcessroute";
    }

    public BOSUDFunction getInstance(ExpressionContext arg0) {
        return new GetDefaultProcessroute(this.expContext);
    }

    public Object call(Object ... arg0) {
        if (arg0[0].equals("") || arg0[0] == null || arg0[1].equals("") || arg0[1] == null) {
            return null;
        }
        Long orgId = Long.valueOf(arg0[0].toString());
        Long mftmaterialID = Long.valueOf(arg0[1].toString());
        logger.info("[getRoutefunc]orgid:" + String.valueOf(orgId) + "materialid:" + String.valueOf(mftmaterialID));
        DynamicObject processroute = this.getProcessRoute(mftmaterialID, orgId);
        return processroute == null ? null : processroute.getPkValue();
    }

    public DynamicObject getProcessRoute(Long mftmaterialid, Long orgid) {
        DynamicObject processroute1;
        QFilter statusFilter = new QFilter("ismainprocess", "=", (Object)"1");
        statusFilter.and(new QFilter("status", "=", (Object)"C"));
        statusFilter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter orgqFilter = BaseDataServiceHelper.getBaseDataFilter((String)ENTITYID_ROUTE, (Long)orgid);
        QFilter typeA = new QFilter("processtype", "=", (Object)"A");
        QFilter typeB = new QFilter("processtype", "=", (Object)"B");
        QFilter typeC = new QFilter("processtype", "=", (Object)"C");
        DynamicObject mftmaterial = BusinessDataServiceHelper.loadSingleFromCache((Object)mftmaterialid, (String)"bd_materialmftinfo");
        DynamicObject bdmaterial = mftmaterial.getDynamicObject("masterid");
        QFilter materialFilter = new QFilter("material.id", "=", bdmaterial.getPkValue());
        DynamicObjectCollection materialgroup = mftmaterial.getDynamicObjectCollection("mftcontrolentry");
        ArrayList<Long> grouplist = new ArrayList<Long>();
        for (DynamicObject group : materialgroup) {
            grouplist.add((Long)group.getDynamicObject("materialcontrol").getPkValue());
        }
        DynamicObject processroute = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITYID_ROUTE, (String)"id", (QFilter[])new QFilter[]{orgqFilter, typeA, materialFilter, statusFilter});
        if (processroute != null) {
            return processroute;
        }
        if (grouplist.size() > 0 && (processroute1 = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITYID_ROUTE, (String)"id", (QFilter[])new QFilter[]{orgqFilter, typeB, statusFilter, new QFilter("materialgroup", "in", grouplist)})) != null) {
            return processroute1;
        }
        processroute = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITYID_ROUTE, (String)"id", (QFilter[])new QFilter[]{orgqFilter, typeC, statusFilter});
        if (processroute != null) {
            return processroute;
        }
        logger.info("[getRoutefunc]route is null");
        return null;
    }
}

