/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.func;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class GetDefaultRequireType
implements BOSUDFunction {
    private static final Log logger = LogFactory.getLog(GetDefaultRequireType.class);
    private ExpressionContext expContext;
    public static final String BD_MANUSTRCONFIG = "bd_manustrconfig";
    public static final String BD_MANUSTRATEGYGROUP = "bd_manustrategygroup";
    public static final String BD_MATERIALINVENTORYINFO = "bd_materialinventoryinfo";

    public GetDefaultRequireType() {
    }

    public GetDefaultRequireType(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public String getName() {
        return "GetDefaultRequireType";
    }

    public BOSUDFunction getInstance(ExpressionContext arg0) {
        return new GetDefaultRequireType(this.expContext);
    }

    public Object call(Object ... arg0) {
        if (arg0[0] == null || arg0[0].equals("") || arg0[1] == null || arg0[1].equals("")) {
            return null;
        }
        Object orgObj = arg0[0];
        Object materialObj = arg0[1];
        String billType = arg0[2].toString();
        Long orgId = null;
        Long materialId = null;
        if (orgObj instanceof DynamicObject) {
            DynamicObject org = (DynamicObject)orgObj;
            orgId = org.getLong("id");
        } else if (orgObj instanceof Long) {
            orgId = (Long)orgObj;
        }
        if (materialObj instanceof DynamicObject) {
            DynamicObject mateiral = (DynamicObject)materialObj;
            materialId = mateiral.getLong("id");
        } else if (materialObj instanceof Long) {
            materialId = (Long)materialObj;
        }
        logger.info("[getRequireTypefunc]orgid:" + String.valueOf(orgId) + "materialid:" + String.valueOf(materialId) + "billType:" + billType);
        DynamicObject requireType = this.getRequireType(materialId, orgId, billType);
        return requireType == null ? null : requireType.getPkValue();
    }

    public DynamicObject getRequireType(Long materialId, Long orgId, String billType) {
        DynamicObject requireType = null;
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter billentityqf = new QFilter("entryentity.billentity", "=", (Object)billType);
        QFilter aloneDemandtypeFilter = null;
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)BD_MANUSTRCONFIG, (String)"entryentity.alonedemandtype", (QFilter[])new QFilter[]{statusFilter, enableFilter, billentityqf}, null);){
            for (Row row : queryDataSet) {
                String aloneDemandtype = row.getString("entryentity.alonedemandtype");
                if (aloneDemandtype == null) continue;
                if ("C".equals(aloneDemandtype)) {
                    aloneDemandtypeFilter = new QFilter("entryentity.manustrategy.requiretype.projectreq", "=", (Object)"1");
                    continue;
                }
                if (!"A".equals(aloneDemandtype) && !"B".equals(aloneDemandtype)) continue;
                aloneDemandtypeFilter = new QFilter("entryentity.manustrategy.requiretype.projectreq", "=", (Object)"0");
            }
        }
        QFilter idFilter = BaseDataServiceHelper.getBaseDataFilter((String)BD_MATERIALINVENTORYINFO, (Long)orgId);
        QFilter materialFilter = new QFilter("masterid.id", "in", (Object)materialId);
        Long orgmanustrategygroupId = 0L;
        Long manustrategygroupId = 0L;
        try (DataSet materialinventoryinfoDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)BD_MATERIALINVENTORYINFO, (String)"id,createorg,manustrategygroup", (QFilter[])new QFilter[]{idFilter, materialFilter, statusFilter, enableFilter}, null);){
            for (Row data : materialinventoryinfoDataSet) {
                manustrategygroupId = data.getLong("manustrategygroup");
                if (!orgId.equals(data.getLong("createorg"))) continue;
                orgmanustrategygroupId = data.getLong("manustrategygroup");
            }
        }
        if (orgmanustrategygroupId != null && orgmanustrategygroupId > 0L) {
            manustrategygroupId = orgmanustrategygroupId;
        }
        if (manustrategygroupId == 0L) {
            return requireType;
        }
        QFilter qf = new QFilter("id", "=", (Object)manustrategygroupId);
        Long manustrategyId = 0L;
        int lastPriority = 0;
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)BD_MANUSTRATEGYGROUP, (String)"id,entryentity.manustrategy,entryentity.priority", (QFilter[])new QFilter[]{qf, aloneDemandtypeFilter, statusFilter, enableFilter}, null);){
            for (Row data : queryDataSet) {
                int priority = data.getInteger("entryentity.priority");
                if (priority < lastPriority) continue;
                manustrategyId = data.getLong("entryentity.manustrategy");
                lastPriority = priority;
            }
        }
        if (manustrategyId == 0L) {
            return requireType;
        }
        DynamicObject manustrategy = BusinessDataServiceHelper.loadSingle((String)"bd_manustrategy", (String)"id,requiretype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)manustrategyId), statusFilter, enableFilter});
        if (manustrategy == null) {
            return requireType;
        }
        requireType = manustrategy.getDynamicObject("requiretype");
        if (requireType != null && "C".equals(requireType.getString("status")) && "1".equals(requireType.getString("enable"))) {
            return requireType;
        }
        return null;
    }
}

