/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.operation.bizrule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.ext.mmc.business.helper.RequireTypeHelper;
import kd.bos.ext.mmc.cache.ManustrConfigCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class GetRequireTypeOpAction
extends AbstractOpBizRuleAction {
    public static final String SPLIT = "&&";
    public static final String ENTITY_MATERIALINVENTORYINFO = "bd_materialinventoryinfo";
    public static final String ENTITY_MANUSTRATEGYGROUP = "bd_manustrategygroup";
    private static final String DOT = ".";
    private static final char SUFFIX = '.';
    private static final String ID_SUFFIX = ".id";
    public static final String DIM_MATERIAL_KEY = "materialKey";
    public static final String DIM_ORG_KEY = "orgKey";
    public static final String DIM_ALONEDEMANDTYPE = "alonedemandtype";
    public static final String GZ004 = "GZ004";
    public static final String GZ005 = "GZ005";
    public static final String GZ007 = "GZ007";
    public static final String GZ009 = "GZ009";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        String billid = this.billEntityType.getName();
        Map<String, Object> manustrConfigFieldMap = ManustrConfigCache.getManustrConfigFieldMap(billid);
        if (manustrConfigFieldMap == null || manustrConfigFieldMap.isEmpty()) {
            return;
        }
        List fieldMapList = manustrConfigFieldMap.getOrDefault("filedMapList", new ArrayList());
        if (fieldMapList.isEmpty()) {
            return;
        }
        for (Map fieldMap : fieldMapList) {
            if (!fieldMap.containsKey(GZ009)) continue;
            for (String field : fieldMap.values()) {
                if (e.getFieldKeys().contains(field)) continue;
                if (field.endsWith("id")) {
                    e.getFieldKeys().add(field.substring(0, field.lastIndexOf(DOT)));
                    continue;
                }
                e.getFieldKeys().add(field);
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String billType = this.billEntityType.getName();
        QFilter qf = new QFilter("status", "=", (Object)"C");
        QFilter qf1 = new QFilter("enable", "=", (Object)"1");
        Map<String, Object> manustrConfigFieldMap = ManustrConfigCache.getManustrConfigFieldMap(billType);
        if (manustrConfigFieldMap == null || manustrConfigFieldMap.isEmpty()) {
            return;
        }
        List fieldMapList = manustrConfigFieldMap.getOrDefault("filedMapList", new ArrayList());
        if (fieldMapList.isEmpty()) {
            return;
        }
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(4);
        QFilter qf3 = new QFilter("requiretype", "is not null", null);
        qfs.add(qf);
        qfs.add(qf1);
        qfs.add(qf3);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_manustrategy", (String)"id,requiretype", (QFilter[])qfs.toArray(new QFilter[0]));
        HashMap<Object, Long> map = new HashMap<Object, Long>(load.length);
        for (DynamicObject obj : load) {
            Long requiretypeId = obj.getLong("requiretype.id");
            map.put(obj.getPkValue(), requiretypeId);
        }
        if (map.isEmpty()) {
            return;
        }
        QFilter aloneDemandtypeFilter = null;
        String aloneDemandtype = manustrConfigFieldMap.getOrDefault(DIM_ALONEDEMANDTYPE, "").toString();
        if ("C".equals(aloneDemandtype)) {
            aloneDemandtypeFilter = new QFilter("entryentity.manustrategy.requiretype.projectreq", "=", (Object)"1");
        } else if ("A".equals(aloneDemandtype) || "B".equals(aloneDemandtype)) {
            aloneDemandtypeFilter = new QFilter("entryentity.manustrategy.requiretype.projectreq", "=", (Object)"0");
        }
        DynamicObject[] objArr = e.getDataEntities();
        if (objArr == null) {
            return;
        }
        HashMap<Long, Set<Long>> orgMaterialMap = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> materialInvSet = new HashSet<Long>(16);
        for (DynamicObject bill : objArr) {
            for (Map dimMap : fieldMapList) {
                String requireTypeKey = dimMap.getOrDefault(GZ009, "");
                if (StringUtils.isBlank((CharSequence)requireTypeKey)) continue;
                requireTypeKey = this.removeIdSuffix(requireTypeKey);
                HashMap<String, Integer> entryIndexMap = new HashMap<String, Integer>(4);
                RequireTypeHelper.recursiveCollectDimValue(bill, requireTypeKey, entryIndexMap, dimMap, bill, orgMaterialMap, materialInvSet);
            }
        }
        HashMap<String, Long> orgMatToManuStrGroupMap = new HashMap<String, Long>(16);
        HashSet<Long> manuStrGroupIdSet = new HashSet<Long>(16);
        for (Map.Entry entry : orgMaterialMap.entrySet()) {
            Map<String, Long> manuStrGroupMap = RequireTypeHelper.queryManuStrGroup((Long)entry.getKey(), (Set)entry.getValue());
            if (manuStrGroupMap.isEmpty()) continue;
            orgMatToManuStrGroupMap.putAll(manuStrGroupMap);
            manuStrGroupIdSet.addAll(manuStrGroupMap.values());
        }
        Map<Long, Long> matInvToManuStrGroupMap = RequireTypeHelper.queryManuStrGroup(materialInvSet);
        manuStrGroupIdSet.addAll(matInvToManuStrGroupMap.values());
        Map<Long, DynamicObject> requireTypeMap = RequireTypeHelper.queryPriorityRequireType(manuStrGroupIdSet, aloneDemandtypeFilter);
        for (DynamicObject bill : objArr) {
            for (Map dimMap : fieldMapList) {
                String requireTypeKey = dimMap.getOrDefault(GZ009, "");
                HashMap<String, Integer> entryIndexMap = new HashMap<String, Integer>(4);
                requireTypeKey = this.removeIdSuffix(requireTypeKey);
                this.setRequireTypeDefValue(bill, requireTypeKey, entryIndexMap, dimMap, bill, orgMatToManuStrGroupMap, matInvToManuStrGroupMap, requireTypeMap);
            }
        }
    }

    private void setRequireTypeDefValue(DynamicObject parent, String fieldKey, Map<String, Integer> entryIndexMap, Map<String, String> dimMap, DynamicObject bill, Map<String, Long> orgMatToManuStrGroupMap, Map<Long, Long> matInvToManuStrGroupMap, Map<Long, DynamicObject> requireTypeMap) {
        if (!fieldKey.contains(DOT)) {
            IDataEntityType dataEntityType = parent.getDataEntityType();
            boolean isExist = dataEntityType.getProperties().containsKey((Object)fieldKey);
            if (!isExist) {
                return;
            }
            Long requireTypeId = this.getId(parent.get(fieldKey));
            if (requireTypeId > 0L) {
                return;
            }
            this.setRequireTypeDef(dimMap, entryIndexMap, parent, orgMatToManuStrGroupMap, matInvToManuStrGroupMap, requireTypeMap, fieldKey, bill);
            return;
        }
        int index = fieldKey.indexOf(46);
        String subFieldKey = fieldKey.substring(0, index);
        Object obj = parent.get(subFieldKey);
        fieldKey = fieldKey.substring(index + 1);
        if (obj instanceof DynamicObjectCollection) {
            DynamicObjectCollection entry = (DynamicObjectCollection)obj;
            for (int i = 0; i < entry.size(); ++i) {
                entryIndexMap.put(subFieldKey, i);
                DynamicObject row = (DynamicObject)entry.get(i);
                this.setRequireTypeDefValue(row, fieldKey, entryIndexMap, dimMap, bill, orgMatToManuStrGroupMap, matInvToManuStrGroupMap, requireTypeMap);
            }
        }
    }

    private void setRequireTypeDef(Map<String, String> dimMap, Map<String, Integer> entryIndexMap, DynamicObject bill, Map<String, Long> orgMatToManuStrGroupMap, Map<Long, Long> matInvToManuStrGroupMap, Map<Long, DynamicObject> requireTypeMap, String fieldKey, DynamicObject parentBill) {
        Map<String, Object> dimValueMap = RequireTypeHelper.getDimValue(dimMap, entryIndexMap, parentBill);
        Object materialInvValue = dimValueMap.get(GZ007);
        Object orgValue = dimValueMap.get(GZ004);
        Object materialValue = dimValueMap.get(GZ005);
        Long manuStrGroupId = null;
        if (materialInvValue != null) {
            long materialInvId = RequireTypeHelper.getId(materialInvValue);
            manuStrGroupId = matInvToManuStrGroupMap.get(materialInvId);
        } else if (materialValue != null && orgValue != null) {
            long materialId = RequireTypeHelper.getId(materialValue);
            long orgId = RequireTypeHelper.getId(orgValue);
            String keyStr = RequireTypeHelper.buildMapKey(orgId, materialId);
            manuStrGroupId = orgMatToManuStrGroupMap.get(keyStr);
        }
        if (manuStrGroupId != null) {
            DynamicObject requireTypeDef = requireTypeMap.get(manuStrGroupId);
            if (StringUtils.isBlank((Object)requireTypeDef)) {
                return;
            }
            bill.set(fieldKey, (Object)requireTypeDef);
        }
    }

    private String removeIdSuffix(String field) {
        if (field.endsWith(ID_SUFFIX)) {
            field = field.substring(0, field.lastIndexOf(46));
        }
        return field;
    }

    private long getId(Object object) {
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getLong("id");
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        return 0L;
    }
}

