/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.operation.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.mmc.cache.ManustrConfigCache;
import kd.bos.ext.mmc.operation.validator.ConfigEntryEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class CheckMTOStrategyValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(CheckMTOStrategyValidator.class);
    private static final String[] ARR = new String[]{"GZ004", "GZ005", "GZ007"};
    private static final String SAVE = "save";
    private static final String IMPORTTYPE = "importtype";
    private static final String NOTCHECK_OTHERS_BIZTYPE = "notcheck_others_biztype";
    private static final String NOTCHECK_OTHERS_BIZTYPENAME = "notcheck_others_biztypename";
    private static final String GZ004 = "GZ004";
    private static final String GZ005 = "GZ005";
    private static final String GZ009 = "GZ009";
    private final String key_seq = "seq";
    private final String key_entryseq = "entryseq";
    private final String key_subentryseq = "key_subentryseq";

    public void validate() {
        Long startTime = System.currentTimeMillis();
        log.warn("--------CheckMTOStrategyValidator BEGIN------------");
        Map<String, Object> manustrConfigFieldMap = ManustrConfigCache.getManustrConfigFieldMap(this.entityKey);
        if (manustrConfigFieldMap == null || manustrConfigFieldMap.isEmpty()) {
            return;
        }
        List fieldMapList = manustrConfigFieldMap.getOrDefault("filedMapList", new ArrayList());
        if (fieldMapList.isEmpty()) {
            return;
        }
        Boolean ischecksave = (Boolean)manustrConfigFieldMap.getOrDefault("ischecksave", Boolean.TRUE);
        if (SAVE.equals(this.getOperateKey()) && !this.getOption().getVariables().containsKey(IMPORTTYPE) && !ischecksave.booleanValue()) {
            return;
        }
        QFilter qf = new QFilter("status", "=", (Object)"C");
        QFilter qf1 = new QFilter("enable", "=", (Object)"1");
        QFilter qf3 = new QFilter("traceway.fbasedataid", "is not null", null);
        QFilter qf4 = new QFilter("tracerange.fbasedataid", "is not null", null);
        MainEntityType appBillMainType = MetadataServiceHelper.getDataEntityType((String)this.entityKey);
        DataEntityPropertyCollection properties = appBillMainType.getProperties();
        ArrayList<Map<String, String>> ischeckMapList = new ArrayList<Map<String, String>>();
        ArrayList<ConfigEntryEntity> configList = new ArrayList<ConfigEntryEntity>();
        Long startTime1 = System.currentTimeMillis();
        HashMap<String, String> filedNameMap = new HashMap<String, String>(16);
        List domainIds = manustrConfigFieldMap.getOrDefault("domainIds", new ArrayList());
        this.dealFieldMap(fieldMapList, ischeckMapList, configList, domainIds);
        log.warn("--------CheckMTOStrategyValidator getFieldMap End------------" + (System.currentTimeMillis() - startTime1) / 1000L + 's');
        for (int i = ischeckMapList.size() - 1; i >= 0; --i) {
            if (!((Map)ischeckMapList.get(i)).isEmpty()) continue;
            fieldMapList.remove(i);
            ischeckMapList.remove(i);
            configList.remove(i);
        }
        if (ischeckMapList.isEmpty()) {
            return;
        }
        int rowCount = 0;
        Map datas = BusinessDataServiceHelper.loadFromCache((String)"bd_requiretype", (String)"id,traceway,tracerange", (QFilter[])new QFilter[]{qf, qf1, qf3, qf4});
        int n = fieldMapList.size();
        for (int i = 0; i < n; ++i) {
            boolean isExist;
            Map filedMap = (Map)fieldMapList.get(i);
            ConfigEntryEntity configEntity = (ConfigEntryEntity)configList.get(i);
            HashMap<String, String> headMap = new HashMap<String, String>(8);
            HashMap<String, String> entryMap = new HashMap<String, String>(8);
            Map<String, String> entryEntityMap = this.getEntryFields(headMap, entryMap, filedMap, properties);
            boolean bl = isExist = filedMap.get(GZ005) == null || filedMap.get(GZ004) == null;
            if (isExist && filedMap.get(GZ009) == null || filedMap.get(GZ009) == null || "".equals(filedMap.get(GZ009))) continue;
            startTime1 = System.currentTimeMillis();
            try (AlgoContext context = Algo.newContext();){
                HashSet<Object> invSet = new HashSet<Object>(this.dataEntities.length);
                DataSet billDataSet = this.buildBillDataSet(entryEntityMap.get("entry"), entryEntityMap.get("subentry"), headMap, entryMap, invSet, filedNameMap);
                billDataSet = billDataSet.where("GZ009 != '0' or GZ009 != null");
                for (DynamicObject obj : datas.values()) {
                    DataSet dataSet = billDataSet.copy().where("GZ009 = '" + obj.getPkValue() + "'");
                    Throwable throwable = null;
                    try {
                        while (dataSet.hasNext()) {
                            Row row = dataSet.next();
                            ++rowCount;
                            Set rangeSet = obj.getDynamicObjectCollection("tracerange").stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
                            if (!rangeSet.contains(configEntity.getDomain())) continue;
                            Set fields = configEntity.getFields();
                            Set<String> waySet = obj.getDynamicObjectCollection("traceway").stream().map(x -> x.getString("fbasedataid.number")).collect(Collectors.toSet());
                            waySet.forEach(traceway -> {
                                String subentryName;
                                String entryName = (String)entryEntityMap.get("entryname");
                                if (StringUtils.isEmpty((String)entryName)) {
                                    entryName = ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"CheckMTOStrategyValidator_9", (String)"bos-ext-mmc", (Object[])new Object[0]);
                                }
                                if (StringUtils.isEmpty((String)(subentryName = (String)entryEntityMap.get("subentryname")))) {
                                    subentryName = ResManager.loadKDString((String)"\u5b50\u5355\u636e\u4f53", (String)"CheckMTOStrategyValidator_10", (String)"bos-ext-mmc", (Object[])new Object[0]);
                                }
                                if (fields.contains(traceway) && row.get(traceway) == null) {
                                    if (row.get("entryseq") == null) {
                                        this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"CheckMTOStrategyValidator_0", (String)"bos-ext-mmc", (Object[])new Object[0]), filedNameMap.get(traceway)));
                                    } else if (row.get("key_subentryseq") == null) {
                                        this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\uff1a\u201c%3$s\u201d\u3002", (String)"CheckMTOStrategyValidator_1", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq"), filedNameMap.get(traceway)));
                                    } else {
                                        this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c,\u201c%3$s\u201d\u7b2c%4$s\u884c\uff1a\u201c%5$s\u201d\u3002", (String)"CheckMTOStrategyValidator_2", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq"), subentryName, row.get("key_subentryseq"), filedNameMap.get(traceway)));
                                    }
                                }
                            });
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dataSet == null) continue;
                        if (throwable != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dataSet.close();
                    }
                }
                billDataSet.close();
            }
            log.warn("--------CheckMTOStrategyValidator getFieldMap INVENTORY END------------" + (System.currentTimeMillis() - startTime1) / 1000L + 's');
        }
        log.warn(String.format("--------CheckMTOStrategyValidator END ROW:%s------------%ss", rowCount, (System.currentTimeMillis() - startTime) / 1000L));
    }

    private void dealFieldMap(List<Map<String, String>> fieldMapList, List<Map<String, String>> ischeckMapList, List<ConfigEntryEntity> configList, List<Long> domainIds) {
        Long domainId = 0L;
        if (domainIds != null && !domainIds.isEmpty()) {
            domainId = domainIds.get(0) > 0L ? Long.parseLong(domainIds.get(0).toString()) : 0L;
        }
        for (Map<String, String> fieldMap : fieldMapList) {
            if (!fieldMap.containsKey(GZ009)) continue;
            ConfigEntryEntity configEntity = new ConfigEntryEntity();
            configEntity.setDomain(domainId);
            HashSet<String> li = new HashSet<String>(8);
            HashMap<String, String> ischeckMap = new HashMap<String, String>(8);
            Iterator<Map.Entry<String, String>> iterator = fieldMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> fieldEntry = iterator.next();
                String dimesion = fieldEntry.getKey();
                if (this.getOption().getVariables().containsKey("notcheck_" + dimesion.toLowerCase())) {
                    iterator.remove();
                    continue;
                }
                String field = fieldEntry.getValue();
                if (!Arrays.asList(ARR).contains(dimesion)) {
                    ischeckMap.put(dimesion, field);
                }
                li.add(dimesion);
            }
            configEntity.setFields(li);
            configList.add(configEntity);
            ischeckMapList.add(ischeckMap);
        }
    }

    private List<Field> getAllFields(Map<String, String> headMap, Map<String, String> entryMap) {
        ArrayList<Field> fields = new ArrayList<Field>(16);
        ArrayList<String> fieldStrs = new ArrayList<String>(16);
        fields.add(new Field("seq", (DataType)DateType.IntegerType, true));
        fieldStrs.add("seq");
        fields.add(new Field("entryseq", (DataType)DateType.IntegerType, true));
        fieldStrs.add("entryseq");
        fields.add(new Field("key_subentryseq", (DataType)DateType.IntegerType, true));
        fieldStrs.add("key_subentryseq");
        for (String key : headMap.keySet()) {
            if (fieldStrs.contains(key)) continue;
            fieldStrs.add(key);
            fields.add(new Field(key, (DataType)DateType.StringType, true));
        }
        for (String key : entryMap.keySet()) {
            if (fieldStrs.contains(key)) continue;
            fieldStrs.add(key);
            fields.add(new Field(key, (DataType)DateType.StringType, true));
        }
        return fields;
    }

    private DataSetBuilder createBuilder(List<Field> fields) {
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        return builder;
    }

    private DataSet buildBillDataSet(String entryEntity, String subEntryEntity, Map<String, String> headMap, Map<String, String> entryMap, Set<Object> invSet, Map<String, String> filedNameMap) {
        List<Field> allFields = this.getAllFields(headMap, entryMap);
        DataSetBuilder builder = this.createBuilder(allFields);
        boolean isExist = false;
        String bizTypeName = "";
        List bizIdList = new ArrayList();
        if (this.getOption().getVariables().containsKey(NOTCHECK_OTHERS_BIZTYPE) && this.getOption().getVariables().containsKey(NOTCHECK_OTHERS_BIZTYPENAME)) {
            isExist = true;
            bizTypeName = (String)this.getOption().getVariables().get(NOTCHECK_OTHERS_BIZTYPENAME);
            bizIdList = SerializationUtils.fromJsonStringToList((String)((String)this.getOption().getVariables().get(NOTCHECK_OTHERS_BIZTYPE)), Long.class);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityKey());
        int n = this.dataEntities.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject bizType;
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            if (isExist && bizIdList.contains((bizType = dataEntity.getDynamicObject(bizTypeName)).getPkValue())) continue;
            if (entryMap.isEmpty()) {
                Object[] rowData = new Object[allFields.size()];
                rowData[0] = i;
                headMap.forEach((k, v) -> this.setRowData(invSet, dataEntity, rowData, (String)k, (String)v, allFields, dataEntityType, filedNameMap));
                builder.append(rowData);
                continue;
            }
            DynamicObjectCollection col = dataEntity.getDynamicObjectCollection(entryEntity);
            if (!"".equals(subEntryEntity)) {
                for (DynamicObject entry : col) {
                    DynamicObjectCollection subCol = entry.getDynamicObjectCollection(subEntryEntity);
                    for (DynamicObject subEntry : subCol) {
                        Object[] rowData = new Object[allFields.size()];
                        rowData[0] = i;
                        rowData[1] = entry.get("seq");
                        rowData[2] = subEntry.get("seq");
                        headMap.forEach((k, v) -> this.setRowData(invSet, dataEntity, rowData, (String)k, (String)v, allFields, dataEntityType, filedNameMap));
                        entryMap.forEach((k, v) -> {
                            String value = v.replace(subEntryEntity + ".", "");
                            if (v.startsWith(subEntryEntity)) {
                                this.setRowData(invSet, subEntry, rowData, (String)k, value, allFields, dataEntityType, filedNameMap);
                            } else {
                                this.setRowData(invSet, entry, rowData, (String)k, (String)v, allFields, dataEntityType, filedNameMap);
                            }
                        });
                        builder.append(rowData);
                    }
                }
                continue;
            }
            for (DynamicObject entry : col) {
                Object[] rowData = new Object[allFields.size()];
                rowData[0] = i;
                rowData[1] = entry.get("seq");
                headMap.forEach((k, v) -> this.setRowData(invSet, dataEntity, rowData, (String)k, (String)v, allFields, dataEntityType, filedNameMap));
                entryMap.forEach((k, v) -> this.setRowData(invSet, entry, rowData, (String)k, (String)v, allFields, dataEntityType, filedNameMap));
                builder.append(rowData);
            }
        }
        return builder.build();
    }

    private void setRowData(Set<Object> invSet, DynamicObject dataEntity, Object[] rowData, String k, String v, List<Field> allFields, MainEntityType dataEntityType, Map<String, String> filedNameMap) {
        for (int i = 0; i < allFields.size(); ++i) {
            String[] split;
            Field field = allFields.get(i);
            String name = field.getName();
            if (!name.equals(k) || (split = v.split("\\.")).length == 0) continue;
            String fieldStr = split[0];
            if (dataEntityType.findProperty(fieldStr) == null) {
                return;
            }
            rowData[i] = dataEntity.get(v);
            if (GZ009.equals(k)) {
                invSet.add(dataEntity.get(v));
            }
            if (dataEntityType.findProperty(fieldStr) == null) continue;
            filedNameMap.put(k, dataEntityType.findProperty(fieldStr).getDisplayName().getLocaleValue());
        }
    }

    private Map<String, String> getEntryFields(Map<String, String> headMap, Map<String, String> entryMap, Map<String, String> filedMap, DataEntityPropertyCollection properties) {
        String entryEntityName = "";
        String subEntryEntityName = "";
        String entryName = "";
        String subEntryName = "";
        String name = "";
        for (Map.Entry<String, String> en : filedMap.entrySet()) {
            if (en == null || StringUtils.isEmpty((String)en.getValue())) continue;
            int index = en.getValue().indexOf(".");
            if (index < 0) {
                headMap.put(en.getKey(), en.getValue());
                continue;
            }
            String substring = en.getValue().substring(0, index);
            if (properties.get((Object)substring) instanceof EntryProp) {
                entryMap.put(en.getKey(), en.getValue().substring(index + 1, en.getValue().length()));
                entryEntityName = substring;
                entryName = ((IDataEntityProperty)properties.get((Object)substring)).getDisplayName().toString();
                name = en.getValue().substring(index + 1, en.getValue().length());
                DynamicObjectType propertyType = ((EntryProp)properties.get((Object)substring)).getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProp = propertyType.getProperties();
                if (name.indexOf(".") == -1 || !(entryProp.get((Object)name.substring(0, name.indexOf("."))) instanceof SubEntryProp)) continue;
                subEntryEntityName = name.substring(0, name.indexOf("."));
                subEntryName = ((IDataEntityProperty)entryProp.get((Object)name.substring(0, name.indexOf(".")))).getDisplayName().toString();
                continue;
            }
            headMap.put(en.getKey(), en.getValue());
        }
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("entry", entryEntityName);
        map.put("subentry", subEntryEntityName);
        map.put("entryname", entryName);
        map.put("subentryname", subEntryName);
        return map;
    }
}

